/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix.demo.mina;

import java.io.File;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.channels.spi.SelectorProvider;
import java.nio.charset.StandardCharsets;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.session.IdleStatus;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.filter.codec.textline.TextLineCodecFactory;
import org.apache.mina.filter.logging.LoggingFilter;
import org.apache.mina.transport.socket.nio.NioSocketAcceptor;
import org.newsclub.net.unix.AFUNIXSelectorProvider;
import org.newsclub.net.unix.AFUNIXSocketAddress;
import org.newsclub.net.unix.demo.mina.TimeServerHandler;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class MinaTimeServer {
    public static void main(String[] args) throws IOException {
        int processorCount = Runtime.getRuntime().availableProcessors() + 1;
        NioSocketAcceptor acceptor = new NioSocketAcceptor(processorCount, (SelectorProvider)AFUNIXSelectorProvider.provider());
        acceptor.getFilterChain().addLast("logger", (IoFilter)new LoggingFilter());
        acceptor.getFilterChain().addLast("codec", (IoFilter)new ProtocolCodecFilter((ProtocolCodecFactory)new TextLineCodecFactory(StandardCharsets.UTF_8)));
        acceptor.setHandler((IoHandler)new TimeServerHandler());
        acceptor.getSessionConfig().setReadBufferSize(2048);
        acceptor.getSessionConfig().setIdleTime(IdleStatus.BOTH_IDLE, 10);
        acceptor.bind((SocketAddress)AFUNIXSocketAddress.of((File)new File("/tmp/minatime")));
    }
}

