/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix.demo.server;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import org.newsclub.net.unix.demo.server.DemoServerBase;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class ChargenServer
extends DemoServerBase {
    private static final Chargen SIMPLE_CHARGEN = new SimpleChargen();
    private final boolean fast;
    private FastChargen cachedChargen = null;

    public ChargenServer(SocketAddress listenAddress) {
        this(listenAddress, true);
    }

    public ChargenServer(SocketAddress listenAddress, boolean fast) {
        super(listenAddress);
        this.fast = fast;
    }

    @Override
    protected void onServerStarting() {
        super.onServerStarting();
        System.out.println("- Fast chargen: " + this.fast);
    }

    protected void doServeSocket(Socket socket) throws IOException {
        try (OutputStream os = socket.getOutputStream();){
            this.getChargen(socket).write(socket);
        }
    }

    private synchronized Chargen getChargen(Socket socket) throws SocketException {
        if (!this.fast) {
            return SIMPLE_CHARGEN;
        }
        int bufferSize = socket.getSendBufferSize();
        FastChargen chargen = this.cachedChargen;
        if (chargen == null || chargen.cacheSize != bufferSize) {
            this.cachedChargen = chargen = new FastChargen(bufferSize);
        }
        return chargen;
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static final class FastChargen
    implements Chargen {
        private final int ourDataSize;
        private final int cacheSize;
        private final byte[] cache;

        FastChargen(int sendBufferSize) {
            this.cacheSize = sendBufferSize;
            int lineWidth = 72;
            int firstPrintableCharacter = 32;
            int lastPrintableCharacter = 126;
            int numPrintableCharacters = 95;
            int linefeedLen = 2;
            this.ourDataSize = 7030;
            int bufLen = sendBufferSize + this.ourDataSize;
            ByteArrayOutputStream bos = new ByteArrayOutputStream(bufLen);
            int nWritten = 0;
            block0: while (nWritten < bufLen) {
                int offset = 1;
                for (int row = 0; row < 95; ++row) {
                    for (int i = 0; i < 72; ++i) {
                        int asciiChar = 32 + (offset + i) % 95;
                        bos.write(asciiChar);
                        if (++nWritten == bufLen) break block0;
                    }
                    bos.write(13);
                    bos.write(10);
                    if (++nWritten == bufLen) break block0;
                    ++offset;
                }
            }
            this.cache = bos.toByteArray();
        }

        @Override
        public void write(Socket socket) throws IOException {
            OutputStream os = socket.getOutputStream();
            try {
                int offset = 0;
                while (true) {
                    os.write(this.cache, offset, this.cacheSize);
                    offset = (offset + this.cacheSize) % this.ourDataSize;
                }
            }
            catch (Throwable throwable) {
                if (os != null) {
                    try {
                        os.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static interface Chargen {
        public void write(Socket var1) throws IOException;
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static final class SimpleChargen
    implements Chargen {
        private SimpleChargen() {
        }

        @Override
        public void write(Socket socket) throws IOException {
            BufferedOutputStream bos = new BufferedOutputStream(socket.getOutputStream(), socket.getSendBufferSize());
            try {
                block4: while (true) {
                    int offset = 1;
                    int row = 0;
                    while (true) {
                        if (row >= 95) continue block4;
                        for (int i = 0; i < 72; ++i) {
                            int asciiChar = 32 + (offset + i) % 95;
                            bos.write(asciiChar);
                        }
                        bos.write(13);
                        bos.write(10);
                        ++offset;
                        ++row;
                    }
                    break;
                }
            }
            catch (Throwable throwable) {
                try {
                    bos.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }
}

