/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix.demo.client;

import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import org.newsclub.net.unix.AFUNIXSocket;
import org.newsclub.net.unix.demo.client.DemoClientBase;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class ReadFileHandleClient
extends DemoClientBase {
    @Override
    protected void handleSocket(Socket socket) throws IOException {
        if (!(socket instanceof AFUNIXSocket)) {
            throw new UnsupportedOperationException("File handles can only be sent via UNIX sockets");
        }
        this.handleSocket((AFUNIXSocket)socket);
    }

    protected void handleSocket(AFUNIXSocket socket) throws IOException {
        socket.setAncillaryReceiveBufferSize(1024);
        try (InputStream in = socket.getInputStream();){
            byte[] buf = new byte[socket.getReceiveBufferSize()];
            while (in.read(buf) != -1) {
                FileDescriptor[] descriptors = socket.getReceivedFileDescriptors();
                if (descriptors == null) continue;
                for (FileDescriptor fd : descriptors) {
                    this.handleFileDescriptor(fd);
                }
            }
        }
    }

    private void handleFileDescriptor(FileDescriptor fd) throws IOException {
        try (FileInputStream fin = new FileInputStream(fd);){
            int read;
            byte[] buf = new byte[4096];
            while ((read = fin.read(buf)) != -1) {
                System.out.write(buf, 0, read);
            }
            System.out.flush();
        }
    }
}

