/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix.darwin.system;

import java.nio.ByteBuffer;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class IPUtil {
    public static final int DOMAIN_HEADER_LENGTH = 4;
    public static final int DOMAIN_AF_INET = 2;
    public static final int IPV4_DEFAULT_HEADER_SIZE = 20;
    public static final byte AF_INET_PROTOCOL_ICMP = 1;

    private IPUtil() {
        throw new IllegalStateException("No instances");
    }

    public static int checksumIPv4header(ByteBuffer bb, int start, int end) {
        return IPUtil.checksumIPstyle(bb, start, end, 10);
    }

    public static int checksumICMPheader(ByteBuffer bb, int start, int end) {
        return IPUtil.checksumIPstyle(bb, start, end, 2);
    }

    private static int checksumIPstyle(ByteBuffer bb, int start, int end, int checksumOffset) {
        int checksumAt = start + checksumOffset;
        int sum = 0;
        if (checksumOffset >= end) {
            throw new IllegalArgumentException("checksumOffset");
        }
        bb.putShort(checksumAt, (short)0);
        for (int i = start; i < end; i += 2) {
            int v = bb.getShort(i) & 0xFFFF;
            int overflow = (sum += v) & 0xFFFF0000;
            if (overflow == 0) continue;
            sum = sum + (overflow >>> 16) & 0xFFFF;
        }
        int checksum = ~sum & 0xFFFF;
        bb.putShort(checksumAt, (short)checksum);
        return checksum;
    }

    public static void putIPv4Header(ByteBuffer bb, int payloadLength, byte protocol, int srcIP, int dstIP) {
        bb.put((byte)69);
        bb.put((byte)0);
        bb.putShort((short)(20 + payloadLength));
        bb.putShort((short)0);
        bb.putShort((short)0);
        bb.put((byte)65);
        bb.put(protocol);
        bb.putShort((short)0);
        bb.putInt(srcIP);
        bb.putInt(dstIP);
    }

    public static void putICMPEchoResponse(ByteBuffer bb, short echoIdentifier, short sequenceNumber, ByteBuffer payload) {
        bb.put((byte)0);
        bb.put((byte)0);
        bb.putShort((short)0);
        bb.putShort(echoIdentifier);
        bb.putShort(sequenceNumber);
        bb.put(payload);
    }
}

