/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix;

import java.net.SocketAddress;
import java.net.SocketException;
import java.net.UnixDomainSocketAddress;
import java.util.function.Supplier;
import org.newsclub.net.unix.AFUNIXSocketAddress;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
final class SocketAddressUtil {
    private SocketAddressUtil() {
        throw new IllegalStateException("No instances");
    }

    static Supplier<AFUNIXSocketAddress> supplyAFUNIXSocketAddress(SocketAddress address) {
        if (address instanceof UnixDomainSocketAddress) {
            UnixDomainSocketAddress udsa = (UnixDomainSocketAddress)address;
            return () -> {
                try {
                    return AFUNIXSocketAddress.of(udsa.getPath());
                }
                catch (SocketException e) {
                    return null;
                }
            };
        }
        return null;
    }
}

