/*
 * Decompiled with CFR 0.152.
 */
package com.klaytn.caver.wallet.keyring;

import com.klaytn.caver.account.Account;
import com.klaytn.caver.account.AccountKeyRoleBased;
import com.klaytn.caver.utils.Utils;
import com.klaytn.caver.wallet.keyring.AbstractKeyring;
import com.klaytn.caver.wallet.keyring.KeyStore;
import com.klaytn.caver.wallet.keyring.KeyStoreOption;
import com.klaytn.caver.wallet.keyring.MessageSigned;
import com.klaytn.caver.wallet.keyring.PrivateKey;
import com.klaytn.caver.wallet.keyring.SignatureData;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.web3j.crypto.CipherException;

public class SingleKeyring
extends AbstractKeyring {
    PrivateKey key;

    public SingleKeyring(String address, PrivateKey key) {
        super(address);
        this.key = key;
    }

    @Override
    public List<SignatureData> sign(String txHash, int chainId, int role) {
        PrivateKey key = this.getKeyByRole(role);
        SignatureData data = key.sign(txHash, chainId);
        return Arrays.asList(data);
    }

    @Override
    public SignatureData sign(String txHash, int chainId, int role, int index) {
        this.validatedIndexWithKeys(index, 1);
        PrivateKey key = this.getKeyByRole(role);
        SignatureData data = key.sign(txHash, chainId);
        return data;
    }

    @Override
    public MessageSigned signMessage(String message, int role) {
        PrivateKey key = this.getKeyByRole(role);
        String messageHash = Utils.hashMessage(message);
        SignatureData signatureData = key.signMessage(messageHash);
        return new MessageSigned(messageHash, Arrays.asList(signatureData), message);
    }

    @Override
    public MessageSigned signMessage(String message, int role, int index) {
        this.validatedIndexWithKeys(index, 1);
        String messageHash = Utils.hashMessage(message);
        SignatureData signatureData = this.key.signMessage(messageHash);
        return new MessageSigned(messageHash, Arrays.asList(signatureData), message);
    }

    @Override
    public String getKlaytnWalletKey() {
        return this.key.getPrivateKey() + "0x00" + this.getAddress();
    }

    @Override
    public KeyStore encrypt(String password, KeyStoreOption options) throws CipherException {
        List<KeyStore.Crypto> crypto = KeyStore.Crypto.createCrypto(new PrivateKey[]{this.key}, password, options);
        KeyStore keyStore = new KeyStore();
        keyStore.setAddress(this.address);
        keyStore.setVersion(4);
        keyStore.setId(UUID.randomUUID().toString());
        keyStore.setKeyring(crypto);
        return keyStore;
    }

    @Override
    public KeyStore encryptV3(String password) throws CipherException {
        KeyStoreOption options = KeyStoreOption.getDefaultOptionWithKDF(KeyStore.ScryptKdfParams.getName());
        return this.encryptV3(password, options);
    }

    @Override
    public KeyStore encryptV3(String password, KeyStoreOption options) throws CipherException {
        List<KeyStore.Crypto> crypto = KeyStore.Crypto.createCrypto(new PrivateKey[]{this.key}, password, options);
        KeyStore keyStore = new KeyStore();
        keyStore.setAddress(this.address);
        keyStore.setVersion(3);
        keyStore.setId(UUID.randomUUID().toString());
        keyStore.setCrypto(crypto.get(0));
        return keyStore;
    }

    @Override
    public boolean isDecoupled() {
        return !this.address.toLowerCase().equals(this.key.getDerivedAddress().toLowerCase());
    }

    @Override
    public AbstractKeyring copy() {
        return new SingleKeyring(this.address, this.key);
    }

    public Account toAccount() {
        return Account.createWithAccountKeyPublic(this.address, this.key.getPublicKey(false));
    }

    public String getPublicKey() {
        return this.getPublicKey(false);
    }

    public String getPublicKey(boolean compressed) {
        return this.key.getPublicKey(compressed);
    }

    public PrivateKey getKeyByRole(int role) {
        if (role < 0 || role >= AccountKeyRoleBased.ROLE_GROUP_COUNT) {
            throw new IllegalArgumentException("Invalid role index : " + role);
        }
        return this.key;
    }

    public PrivateKey getKey() {
        return this.key;
    }
}

