/*
 * Decompiled with CFR 0.152.
 */
package com.klaytn.caver.wallet.keyring;

import com.klaytn.caver.account.Account;
import com.klaytn.caver.account.AccountKeyRoleBased;
import com.klaytn.caver.account.WeightedMultiSigOptions;
import com.klaytn.caver.utils.Utils;
import com.klaytn.caver.wallet.keyring.AbstractKeyring;
import com.klaytn.caver.wallet.keyring.KeyStore;
import com.klaytn.caver.wallet.keyring.KeyStoreOption;
import com.klaytn.caver.wallet.keyring.MessageSigned;
import com.klaytn.caver.wallet.keyring.PrivateKey;
import com.klaytn.caver.wallet.keyring.SignatureData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.web3j.crypto.CipherException;

public class MultipleKeyring
extends AbstractKeyring {
    PrivateKey[] keys;

    public MultipleKeyring(String address, PrivateKey[] keys) {
        super(address);
        this.keys = keys;
    }

    @Override
    public List<SignatureData> sign(String txHash, int chainId, int role) {
        PrivateKey[] keyArr = this.getKeyByRole(role);
        return Arrays.stream(keyArr).map(key -> key.sign(txHash, chainId)).collect(Collectors.toList());
    }

    @Override
    public SignatureData sign(String txHash, int chainId, int role, int index) {
        this.validatedIndexWithKeys(index, this.keys.length);
        PrivateKey key = this.getKeyByRole(role)[index];
        SignatureData signatureData = key.sign(txHash, chainId);
        return signatureData;
    }

    @Override
    public MessageSigned signMessage(String message, int role) {
        PrivateKey[] keyArr = this.getKeyByRole(role);
        String messageHash = Utils.hashMessage(message);
        List signatureDataList = Arrays.stream(keyArr).map(key -> key.signMessage(messageHash)).collect(Collectors.toCollection(ArrayList::new));
        MessageSigned signed = new MessageSigned(messageHash, signatureDataList, message);
        return signed;
    }

    @Override
    public MessageSigned signMessage(String message, int role, int index) {
        this.validatedIndexWithKeys(index, this.keys.length);
        PrivateKey key = this.getKeyByRole(role)[index];
        String messageHash = Utils.hashMessage(message);
        SignatureData signatureData = key.signMessage(messageHash);
        MessageSigned signed = new MessageSigned(messageHash, Arrays.asList(signatureData), message);
        return signed;
    }

    @Override
    public KeyStore encrypt(String password, KeyStoreOption options) throws CipherException {
        List<KeyStore.Crypto> cryptoList = KeyStore.Crypto.createCrypto(this.keys, password, options);
        KeyStore keyStore = new KeyStore();
        keyStore.setAddress(this.address);
        keyStore.setVersion(4);
        keyStore.setId(UUID.randomUUID().toString());
        keyStore.setKeyring(cryptoList);
        return keyStore;
    }

    @Override
    public AbstractKeyring copy() {
        return new MultipleKeyring(this.address, this.keys);
    }

    public String[] getPublicKey() {
        return this.getPublicKey(false);
    }

    public String[] getPublicKey(boolean compressed) {
        return (String[])Arrays.stream(this.keys).map(key -> key.getPublicKey(compressed)).toArray(String[]::new);
    }

    public PrivateKey[] getKeyByRole(int role) {
        if (role < 0 || role >= AccountKeyRoleBased.ROLE_GROUP_COUNT) {
            throw new IllegalArgumentException("Invalid role index : " + role);
        }
        return this.keys;
    }

    public Account toAccount() {
        WeightedMultiSigOptions options = WeightedMultiSigOptions.getDefaultOptionsForWeightedMultiSig(this.getPublicKey());
        return this.toAccount(options);
    }

    public Account toAccount(WeightedMultiSigOptions options) {
        return Account.createWithAccountKeyWeightedMultiSig(this.address, this.getPublicKey(), options);
    }

    public PrivateKey[] getKeys() {
        return this.keys;
    }
}

