/*
 * Decompiled with CFR 0.152.
 */
package com.klaytn.caver.wallet.keyring;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.klaytn.caver.account.AccountKeyRoleBased;
import com.klaytn.caver.utils.Utils;
import com.klaytn.caver.wallet.keyring.AbstractKeyring;
import com.klaytn.caver.wallet.keyring.KeyStore;
import com.klaytn.caver.wallet.keyring.MultipleKeyring;
import com.klaytn.caver.wallet.keyring.PrivateKey;
import com.klaytn.caver.wallet.keyring.RoleBasedKeyring;
import com.klaytn.caver.wallet.keyring.SingleKeyring;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.web3j.crypto.CipherException;

public class KeyringFactory {
    public static SingleKeyring generate() {
        return KeyringFactory.generate(null);
    }

    public static SingleKeyring generate(String entropy) {
        PrivateKey privateKey = PrivateKey.generate(entropy);
        String address = privateKey.getDerivedAddress();
        return KeyringFactory.createWithSingleKey(address, privateKey.getPrivateKey());
    }

    public static String generateSingleKey() {
        return KeyringFactory.generateSingleKey(null);
    }

    public static String generateSingleKey(String entropy) {
        return PrivateKey.generate(entropy).getPrivateKey();
    }

    public static String[] generateMultipleKeys(int num) {
        return KeyringFactory.generateMultipleKeys(num, null);
    }

    public static String[] generateMultipleKeys(int num, String entropy) {
        String[] keyArr = new String[num];
        for (int i = 0; i < num; ++i) {
            keyArr[i] = PrivateKey.generate(entropy).getPrivateKey();
        }
        return keyArr;
    }

    public static List<String[]> generateRolBasedKeys(int[] numArr) {
        return KeyringFactory.generateRoleBasedKeys(numArr, null);
    }

    public static List<String[]> generateRoleBasedKeys(int[] numArr, String entropy) {
        String[][] keyArr = new String[3][];
        for (int i = 0; i < numArr.length; ++i) {
            int length = numArr[i];
            String[] arr = new String[length];
            for (int j = 0; j < length; ++j) {
                arr[j] = PrivateKey.generate(entropy).getPrivateKey();
            }
            keyArr[i] = arr;
        }
        return Arrays.asList(keyArr);
    }

    public static SingleKeyring create(String address, String key) {
        return KeyringFactory.createWithSingleKey(address, key);
    }

    public static MultipleKeyring create(String address, String[] keys) {
        return KeyringFactory.createWithMultipleKey(address, keys);
    }

    public static RoleBasedKeyring create(String address, List<String[]> keys) {
        return KeyringFactory.createWithRoleBasedKey(address, keys);
    }

    public static SingleKeyring createFromPrivateKey(String key) {
        if (Utils.isKlaytnWalletKey(key)) {
            return KeyringFactory.createFromKlaytnWalletKey(key);
        }
        PrivateKey privateKey = new PrivateKey(key);
        String address = privateKey.getDerivedAddress();
        return KeyringFactory.createWithSingleKey(address, key);
    }

    public static SingleKeyring createFromKlaytnWalletKey(String klaytnWalletKey) {
        String[] parsedKey = Utils.parseKlaytnWalletKey(klaytnWalletKey);
        String privateKey = parsedKey[0];
        String address = parsedKey[2];
        return KeyringFactory.createWithSingleKey(address, privateKey);
    }

    public static SingleKeyring createWithSingleKey(String address, String key) {
        if (Utils.isKlaytnWalletKey(key)) {
            throw new IllegalArgumentException("Invalid format of parameter. Use 'fromKlaytnWalletKey' to create Keyring from KlaytnWalletKey.");
        }
        PrivateKey privateKey = new PrivateKey(key);
        return new SingleKeyring(address, privateKey);
    }

    public static MultipleKeyring createWithMultipleKey(String address, String[] multipleKey) {
        if (multipleKey.length > 10) {
            throw new IllegalArgumentException("MultipleKey has up to 10.");
        }
        PrivateKey[] keyArr = (PrivateKey[])Arrays.stream(multipleKey).map(PrivateKey::new).toArray(PrivateKey[]::new);
        return new MultipleKeyring(address, keyArr);
    }

    public static RoleBasedKeyring createWithRoleBasedKey(String address, List<String[]> roleBasedKey) {
        if (roleBasedKey.size() > AccountKeyRoleBased.ROLE_GROUP_COUNT) {
            throw new IllegalArgumentException("RoleBasedKey component must have 3.");
        }
        boolean isExceedKeyCount = roleBasedKey.stream().anyMatch(element -> ((String[])element).length > 10);
        if (isExceedKeyCount) {
            throw new IllegalArgumentException("The keys in RoleBasedKey component has up to 10.");
        }
        List privateKeys = roleBasedKey.stream().map(element -> (PrivateKey[])Arrays.stream(element).map(PrivateKey::new).toArray(PrivateKey[]::new)).collect(Collectors.toCollection(ArrayList::new));
        return new RoleBasedKeyring(address, privateKeys);
    }

    public static AbstractKeyring decrypt(String keyStore, String password) throws CipherException, IOException {
        ObjectMapper mapper = new ObjectMapper();
        KeyStore file = (KeyStore)mapper.readValue(keyStore, KeyStore.class);
        return KeyringFactory.decrypt(file, password);
    }

    public static AbstractKeyring decrypt(KeyStore keystore, String password) throws CipherException {
        if (keystore.getVersion() == 3 && keystore.getCrypto() == null) {
            throw new IllegalArgumentException("Invalid keystore V3 format: 'crypto' is not defined.");
        }
        if (keystore.getVersion() == 4 && keystore.getKeyring() == null) {
            throw new IllegalArgumentException("Invalid keystore V4 format: 'keyring' is not defined.");
        }
        if (keystore.getCrypto() != null && keystore.getKeyring() != null) {
            throw new IllegalArgumentException("Invalid key store format: 'crypto' and 'keyring' cannot be defined together.");
        }
        if (keystore.getVersion() == 3) {
            KeyStore.Crypto crypto = keystore.getCrypto();
            String privateKey = KeyStore.Crypto.decryptCrypto(crypto, password);
            return KeyringFactory.create(keystore.getAddress(), privateKey);
        }
        List keyring = keystore.getKeyring();
        ArrayList<String[]> privateKeyList = new ArrayList<String[]>();
        if (keyring.get(0) instanceof KeyStore.Crypto) {
            String[] privateKeyArr = new String[keyring.size()];
            for (int i = 0; i < keyring.size(); ++i) {
                String privateKey;
                KeyStore.Crypto crypto = (KeyStore.Crypto)keyring.get(i);
                privateKeyArr[i] = privateKey = KeyStore.Crypto.decryptCrypto(crypto, password);
            }
            privateKeyList.add(privateKeyArr);
        } else {
            for (List multiKeying : keyring) {
                String[] privateKeyArr = new String[multiKeying.size()];
                for (int i = 0; i < multiKeying.size(); ++i) {
                    String privateKey;
                    KeyStore.Crypto crypto = (KeyStore.Crypto)multiKeying.get(i);
                    privateKeyArr[i] = privateKey = KeyStore.Crypto.decryptCrypto(crypto, password);
                }
                privateKeyList.add(privateKeyArr);
            }
        }
        boolean isRoleBased = privateKeyList.stream().skip(1L).anyMatch(array -> ((String[])array).length > 0);
        if (isRoleBased) {
            return KeyringFactory.createWithRoleBasedKey(keystore.getAddress(), privateKeyList);
        }
        if (((String[])privateKeyList.get(0)).length > 1) {
            return KeyringFactory.createWithMultipleKey(keystore.getAddress(), (String[])privateKeyList.get(0));
        }
        return KeyringFactory.createWithSingleKey(keystore.getAddress(), ((String[])privateKeyList.get(0))[0]);
    }
}

