/*
 * Decompiled with CFR 0.152.
 */
package com.klaytn.caver.wallet.keyring;

import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.klaytn.caver.utils.Utils;
import com.klaytn.caver.wallet.keyring.KeyStoreOption;
import com.klaytn.caver.wallet.keyring.PrivateKey;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.generators.PKCS5S2ParametersGenerator;
import org.bouncycastle.crypto.generators.SCrypt;
import org.bouncycastle.crypto.params.KeyParameter;
import org.web3j.crypto.CipherException;
import org.web3j.crypto.Hash;
import org.web3j.utils.Numeric;

public class KeyStore {
    public static final int KEY_STORE_VERSION_V3 = 3;
    public static final int KEY_STORE_VERSION_V4 = 4;
    private String address;
    private Crypto crypto;
    private List keyRing;
    private String id;
    private int version;

    @JsonSetter(value="keyring")
    @JsonDeserialize(using=KeyRingDeserializer.class)
    public void setKeyring(List keyRing) {
        this.keyRing = keyRing;
    }

    public List getKeyring() {
        return this.keyRing;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public Crypto getCrypto() {
        return this.crypto;
    }

    @JsonSetter(value="crypto")
    public void setCrypto(Crypto crypto) {
        this.crypto = crypto;
    }

    @JsonSetter(value="Crypto")
    public void setCryptoV1(Crypto crypto) {
        this.setCrypto(crypto);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    static class KdfParamsDeserialiser
    extends JsonDeserializer<IKdfParams> {
        KdfParamsDeserialiser() {
        }

        public IKdfParams deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            ObjectMapper objectMapper = (ObjectMapper)jsonParser.getCodec();
            ObjectNode root = (ObjectNode)objectMapper.readTree(jsonParser);
            JsonNode n = root.get("n");
            IKdfParams kdfParams = n == null ? (IKdfParams)objectMapper.convertValue((Object)root, Pbkdf2KdfParams.class) : (IKdfParams)objectMapper.convertValue((Object)root, ScryptKdfParams.class);
            return kdfParams;
        }
    }

    public static class ScryptKdfParams
    implements IKdfParams {
        private static final String NAME = "scrypt";
        private int dklen;
        private int n;
        private int p;
        private int r;
        private String salt;

        public ScryptKdfParams() {
            this.dklen = 32;
            this.n = 4096;
            this.p = 1;
            this.r = 8;
            this.salt = Numeric.toHexStringNoPrefix((byte[])Utils.generateRandomBytes(32));
        }

        public ScryptKdfParams(int dklen, int n, int p, int r, String salt) {
            this.dklen = dklen;
            this.n = n;
            this.p = p;
            this.r = r;
            this.salt = salt;
        }

        public ScryptKdfParams(String salt) {
            this(32, 4096, 1, 8, salt);
        }

        @Override
        public int getDklen() {
            return this.dklen;
        }

        public void setDklen(int dklen) {
            this.dklen = dklen;
        }

        public int getN() {
            return this.n;
        }

        public void setN(int n) {
            this.n = n;
        }

        public int getP() {
            return this.p;
        }

        public void setP(int p) {
            this.p = p;
        }

        public int getR() {
            return this.r;
        }

        public void setR(int r) {
            this.r = r;
        }

        @Override
        public String getSalt() {
            return this.salt;
        }

        public void setSalt(String salt) {
            this.salt = salt;
        }

        public static String getName() {
            return NAME;
        }
    }

    public static class Pbkdf2KdfParams
    implements IKdfParams {
        private static final String NAME = "pbkdf2";
        private int dklen = 32;
        private int c = 262144;
        private String prf = "hmac-sha256";
        private String salt;

        public Pbkdf2KdfParams() {
            this.dklen = 32;
            this.c = 262144;
            this.prf = "hmac-sha256";
            this.salt = Numeric.toHexStringNoPrefix((byte[])Utils.generateRandomBytes(32));
        }

        public Pbkdf2KdfParams(int dklen, int c, String prf, String salt) {
            this.dklen = dklen;
            this.c = c;
            this.prf = prf;
            this.salt = salt;
        }

        public Pbkdf2KdfParams(String salt) {
            this(32, 262144, "hmac-sha256", salt);
        }

        @Override
        public int getDklen() {
            return this.dklen;
        }

        public void setDklen(int dklen) {
            this.dklen = dklen;
        }

        public int getC() {
            return this.c;
        }

        public void setC(int c) {
            this.c = c;
        }

        public String getPrf() {
            return this.prf;
        }

        public void setPrf(String prf) {
            this.prf = prf;
        }

        @Override
        public String getSalt() {
            return this.salt;
        }

        public void setSalt(String salt) {
            this.salt = salt;
        }

        public static String getName() {
            return NAME;
        }
    }

    static interface IKdfParams {
        public int getDklen();

        public String getSalt();
    }

    public static class CipherParams {
        private String iv;

        public CipherParams() {
            this.iv = Numeric.toHexStringNoPrefix((byte[])Utils.generateRandomBytes(16));
        }

        public CipherParams(String iv) {
            this.setIv(iv);
        }

        public String getIv() {
            return this.iv;
        }

        public void setIv(String iv) {
            if (Numeric.hexStringToByteArray((String)iv).length != 16) {
                throw new IllegalArgumentException("AES-128-CTR must have iv length 16.");
            }
            this.iv = iv;
        }
    }

    static class KeyRingDeserializer
    extends JsonDeserializer<List> {
        KeyRingDeserializer() {
        }

        public List deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            ObjectMapper objectMapper = (ObjectMapper)jsonParser.getCodec();
            ArrayNode root = (ArrayNode)objectMapper.readTree(jsonParser);
            if (root.get(0).isArray()) {
                return (List)objectMapper.convertValue((Object)root, (TypeReference)new TypeReference<List<List<Crypto>>>(){});
            }
            return (List)objectMapper.convertValue((Object)root, (TypeReference)new TypeReference<List<Crypto>>(){});
        }
    }

    public static class Crypto {
        private String cipher;
        private String ciphertext;
        private CipherParams cipherparams;
        private String kdf;
        private IKdfParams kdfparams;
        private String mac;

        public static List<Crypto> createCrypto(PrivateKey[] privateKeys, String password, KeyStoreOption option) throws CipherException {
            byte[] iv;
            byte[] salt;
            int PRIVATE_KEY_SIZE = 32;
            String CIPHER_METHOD = "aes-128-ctr";
            ArrayList<Crypto> cryptoList = new ArrayList<Crypto>();
            String kdfName = "";
            byte[] byArray = salt = option.kdfParams.getSalt() != null ? Numeric.hexStringToByteArray((String)option.kdfParams.getSalt()) : Utils.generateRandomBytes(32);
            if (option.cipherParams.getIv() == null) {
                iv = Utils.generateRandomBytes(16);
                option.getCipherParams().setIv(Numeric.toHexStringNoPrefix((byte[])iv));
            } else {
                iv = Numeric.hexStringToByteArray((String)option.cipherParams.getIv());
            }
            for (int i = 0; i < privateKeys.length; ++i) {
                byte[] derivedKey;
                if (option.kdfParams instanceof ScryptKdfParams) {
                    kdfName = ScryptKdfParams.getName();
                    derivedKey = Crypto.generateDerivedScryptKey(password.getBytes(StandardCharsets.UTF_8), salt, ((ScryptKdfParams)option.kdfParams).getN(), ((ScryptKdfParams)option.kdfParams).getR(), ((ScryptKdfParams)option.kdfParams).getP(), option.kdfParams.getDklen());
                    ((ScryptKdfParams)option.kdfParams).setSalt(Numeric.toHexStringNoPrefix((byte[])salt));
                } else if (option.kdfParams instanceof Pbkdf2KdfParams) {
                    kdfName = Pbkdf2KdfParams.getName();
                    derivedKey = Crypto.generatePbkdf2DerivedKey(password.getBytes(StandardCharsets.UTF_8), salt, ((Pbkdf2KdfParams)option.kdfParams).getC(), ((Pbkdf2KdfParams)option.kdfParams).getPrf());
                    ((Pbkdf2KdfParams)option.kdfParams).setSalt(Numeric.toHexStringNoPrefix((byte[])salt));
                } else {
                    throw new RuntimeException("Unsupported KDF");
                }
                byte[] encryptKey = Arrays.copyOfRange(derivedKey, 0, 16);
                byte[] privateKeyBytes = Numeric.toBytesPadded((BigInteger)Numeric.toBigInt((String)privateKeys[i].getPrivateKey()), (int)32);
                byte[] cipherText = Crypto.performCipherOperation(1, iv, encryptKey, privateKeyBytes);
                byte[] mac = Crypto.generateMac(derivedKey, cipherText);
                Crypto crypto = new Crypto();
                crypto.setCipher("aes-128-ctr");
                crypto.setCiphertext(Numeric.toHexStringNoPrefix((byte[])cipherText));
                crypto.setCipherparams(option.getCipherParams());
                crypto.setKdf(kdfName);
                crypto.setKdfparams(option.kdfParams);
                crypto.setMac(Numeric.toHexStringNoPrefix((byte[])mac));
                cryptoList.add(crypto);
            }
            return cryptoList;
        }

        public static String decryptCrypto(Crypto crypto, String password) throws CipherException {
            byte[] derivedKey;
            byte[] mac = Numeric.hexStringToByteArray((String)crypto.getMac());
            byte[] iv = Numeric.hexStringToByteArray((String)crypto.getCipherparams().getIv());
            byte[] cipherText = Numeric.hexStringToByteArray((String)crypto.getCiphertext());
            IKdfParams kdfParams = crypto.getKdfparams();
            if (kdfParams instanceof ScryptKdfParams) {
                ScryptKdfParams scryptKdfParams = (ScryptKdfParams)crypto.getKdfparams();
                int dklen = scryptKdfParams.getDklen();
                int n = scryptKdfParams.getN();
                int p = scryptKdfParams.getP();
                int r = scryptKdfParams.getR();
                byte[] salt = Numeric.hexStringToByteArray((String)scryptKdfParams.getSalt());
                derivedKey = Crypto.generateDerivedScryptKey(password.getBytes(StandardCharsets.UTF_8), salt, n, r, p, dklen);
            } else if (kdfParams instanceof Pbkdf2KdfParams) {
                Pbkdf2KdfParams aes128CtrKdfParams = (Pbkdf2KdfParams)crypto.getKdfparams();
                int c = aes128CtrKdfParams.getC();
                String prf = aes128CtrKdfParams.getPrf();
                byte[] salt = Numeric.hexStringToByteArray((String)aes128CtrKdfParams.getSalt());
                derivedKey = Crypto.generatePbkdf2DerivedKey(password.getBytes(StandardCharsets.UTF_8), salt, c, prf);
            } else {
                throw new CipherException("Unable to deserialize params: " + crypto.getKdf());
            }
            byte[] derivedMac = Crypto.generateMac(derivedKey, cipherText);
            if (!Arrays.equals(derivedMac, mac)) {
                throw new CipherException("Invalid password provided");
            }
            byte[] encryptKey = Arrays.copyOfRange(derivedKey, 0, 16);
            byte[] privateKey = Crypto.performCipherOperation(2, iv, encryptKey, cipherText);
            return Numeric.toHexString((byte[])privateKey);
        }

        private static byte[] generateDerivedScryptKey(byte[] password, byte[] salt, int n, int r, int p, int dkLen) throws CipherException {
            return SCrypt.generate((byte[])password, (byte[])salt, (int)n, (int)r, (int)p, (int)dkLen);
        }

        private static byte[] generatePbkdf2DerivedKey(byte[] password, byte[] salt, int c, String prf) throws CipherException {
            if (!prf.equals("hmac-sha256")) {
                throw new CipherException("Unsupported prf:" + prf);
            }
            PKCS5S2ParametersGenerator gen = new PKCS5S2ParametersGenerator((Digest)new SHA256Digest());
            gen.init(password, salt, c);
            return ((KeyParameter)gen.generateDerivedParameters(256)).getKey();
        }

        private static byte[] performCipherOperation(int mode, byte[] iv, byte[] encryptKey, byte[] text) throws CipherException {
            try {
                IvParameterSpec ivParameterSpec = new IvParameterSpec(iv);
                Cipher cipher = Cipher.getInstance("AES/CTR/NoPadding");
                SecretKeySpec secretKeySpec = new SecretKeySpec(encryptKey, "AES");
                cipher.init(mode, (Key)secretKeySpec, ivParameterSpec);
                return cipher.doFinal(text);
            }
            catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
                throw new CipherException("Error performing cipher operation", (Throwable)e);
            }
        }

        private static byte[] generateMac(byte[] derivedKey, byte[] cipherText) {
            byte[] result = new byte[16 + cipherText.length];
            System.arraycopy(derivedKey, 16, result, 0, 16);
            System.arraycopy(cipherText, 0, result, 16, cipherText.length);
            return Hash.sha3((byte[])result);
        }

        public String getCipher() {
            return this.cipher;
        }

        public void setCipher(String cipher) {
            this.cipher = cipher;
        }

        public String getCiphertext() {
            return this.ciphertext;
        }

        public void setCiphertext(String ciphertext) {
            this.ciphertext = ciphertext;
        }

        public CipherParams getCipherparams() {
            return this.cipherparams;
        }

        public void setCipherparams(CipherParams cipherparams) {
            this.cipherparams = cipherparams;
        }

        public String getKdf() {
            return this.kdf;
        }

        public void setKdf(String kdf) {
            this.kdf = kdf;
        }

        public IKdfParams getKdfparams() {
            return this.kdfparams;
        }

        @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXTERNAL_PROPERTY, property="kdf")
        @JsonSubTypes(value={@JsonSubTypes.Type(value=Pbkdf2KdfParams.class, name="pbkdf2"), @JsonSubTypes.Type(value=ScryptKdfParams.class, name="scrypt")})
        public void setKdfparams(IKdfParams kdfparams) {
            this.kdfparams = kdfparams;
        }

        public String getMac() {
            return this.mac;
        }

        public void setMac(String mac) {
            this.mac = mac;
        }
    }
}

