/*
 * Decompiled with CFR 0.152.
 */
package com.klaytn.caver.wallet.keyring;

import com.klaytn.caver.utils.Utils;
import com.klaytn.caver.wallet.keyring.KeyStore;
import com.klaytn.caver.wallet.keyring.KeyStoreOption;
import com.klaytn.caver.wallet.keyring.MessageSigned;
import com.klaytn.caver.wallet.keyring.SignatureData;
import java.util.List;
import org.web3j.crypto.CipherException;
import org.web3j.utils.Numeric;

public abstract class AbstractKeyring {
    String address;

    public AbstractKeyring(String address) {
        this.address = address;
    }

    public abstract List<SignatureData> sign(String var1, int var2, int var3);

    public abstract SignatureData sign(String var1, int var2, int var3, int var4);

    public abstract MessageSigned signMessage(String var1, int var2);

    public abstract MessageSigned signMessage(String var1, int var2, int var3);

    public abstract KeyStore encrypt(String var1, KeyStoreOption var2) throws CipherException;

    public abstract AbstractKeyring copy();

    public List<SignatureData> sign(String txHash, String chainId, int role) {
        if (!Utils.isNumber(chainId)) {
            throw new IllegalArgumentException("Invalid chainId : " + chainId);
        }
        return this.sign(txHash, Numeric.toBigInt((String)chainId).intValue(), role);
    }

    public SignatureData sign(String txHash, String chainId, int role, int index) {
        if (!Utils.isNumber(chainId)) {
            throw new IllegalArgumentException("Invalid chainId : " + chainId);
        }
        return this.sign(txHash, Numeric.toBigInt((String)chainId).intValue(), role, index);
    }

    public KeyStore encrypt(String password) throws CipherException {
        KeyStoreOption options = KeyStoreOption.getDefaultOptionWithKDF(KeyStore.ScryptKdfParams.getName());
        return this.encrypt(password, options);
    }

    public KeyStore encryptV3(String password, KeyStoreOption options) throws CipherException {
        throw new RuntimeException("Not supported for this class. Use 'encrypt()' function");
    }

    public KeyStore encryptV3(String password) throws CipherException {
        throw new RuntimeException("Not supported for this class. Use 'encrypt()' function");
    }

    public String getKlaytnWalletKey() {
        throw new RuntimeException("Not supported for this class.");
    }

    public boolean isDecoupled() {
        return true;
    }

    boolean validatedIndexWithKeys(int index, int keyLength) {
        if (index < 0) {
            throw new IllegalArgumentException("Invalid index : index cannot be negative");
        }
        if (index >= keyLength) {
            throw new IllegalArgumentException("Invalid index : index must be less than the length of the key.");
        }
        return true;
    }

    public String getAddress() {
        return this.address;
    }
}

