/*
 * Decompiled with CFR 0.152.
 */
package com.klaytn.caver.wallet;

import com.klaytn.caver.crypto.KlayCredentials;
import com.klaytn.caver.utils.SecureRandomUtils;
import com.klaytn.caver.wallet.WalletFile;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.generators.PKCS5S2ParametersGenerator;
import org.bouncycastle.crypto.generators.SCrypt;
import org.bouncycastle.crypto.params.KeyParameter;
import org.web3j.crypto.CipherException;
import org.web3j.crypto.ECKeyPair;
import org.web3j.crypto.Hash;
import org.web3j.crypto.Keys;
import org.web3j.utils.Numeric;

@Deprecated
public class Wallet {
    static final int PRIVATE_KEY_SIZE = 32;
    private static final int N_LIGHT = 4096;
    private static final int P_LIGHT = 6;
    private static final int N_FULL = 262144;
    private static final int P_FULL = 1;
    private static final int R = 8;
    private static final int DKLEN = 32;
    private static final int CURRENT_VERSION = 4;
    private static final int VERSION_3 = 3;
    private static final String CIPHER = "aes-128-ctr";
    static final String AES_128_CTR = "pbkdf2";
    static final String SCRYPT = "scrypt";

    public static WalletFile create(String password, ECKeyPair ecKeyPair, int n, int p, String address) throws CipherException {
        return Wallet.createWalletFile(password, ecKeyPair, n, p, address);
    }

    public static WalletFile create(String password, ECKeyPair ecKeyPair, int n, int p) throws CipherException {
        return Wallet.createWalletFile(password, ecKeyPair, n, p);
    }

    public static WalletFile create(String password, KlayCredentials klayCredentials, int n, int p) throws CipherException {
        return Wallet.createWalletFile(password, klayCredentials, n, p);
    }

    public static WalletFile createFull(String password, ECKeyPair ecKeyPair, String address) throws CipherException {
        return Wallet.create(password, ecKeyPair, 262144, 1, address);
    }

    public static WalletFile createFull(String password, ECKeyPair ecKeyPair) throws CipherException {
        return Wallet.create(password, ecKeyPair, 262144, 1);
    }

    public static WalletFile createFull(String password, KlayCredentials klayCredentials) throws CipherException {
        return Wallet.create(password, klayCredentials, 262144, 1);
    }

    public static WalletFile createStandard(String password, ECKeyPair ecKeyPair, String address) throws CipherException {
        KlayCredentials klayCredentials = KlayCredentials.create(ecKeyPair, address);
        return Wallet.create(password, ecKeyPair, 4096, 6, address);
    }

    public static WalletFile createStandard(String password, KlayCredentials klayCredentials) throws CipherException {
        return Wallet.create(password, klayCredentials, 4096, 6);
    }

    public static WalletFile createStandard(String password, ECKeyPair ecKeyPair) throws CipherException {
        KlayCredentials klayCredentials = KlayCredentials.create(ecKeyPair);
        return Wallet.create(password, klayCredentials, 4096, 6);
    }

    private static WalletFile createWalletFile(String password, ECKeyPair ecKeyPair, int n, int p, String address) throws CipherException {
        WalletFile walletFile = new WalletFile();
        if (!address.isEmpty()) {
            walletFile.setAddress(address);
        } else {
            walletFile.setAddress(Keys.getAddress((ECKeyPair)ecKeyPair));
        }
        ArrayList<WalletFile.Crypto> multisigKeyRing = new ArrayList<WalletFile.Crypto>();
        WalletFile.Crypto crypto = Wallet.generateCrypto(password, n, p, ecKeyPair);
        multisigKeyRing.add(crypto);
        walletFile.setKeyring(multisigKeyRing);
        walletFile.setId(UUID.randomUUID().toString());
        walletFile.setVersion(4);
        return walletFile;
    }

    private static WalletFile createWalletFile(String password, KlayCredentials klayCredentials, int n, int p) throws CipherException {
        WalletFile walletFile = new WalletFile();
        walletFile.setAddress(klayCredentials.getAddress());
        ArrayList cryptosList = new ArrayList();
        List<List<ECKeyPair>> ecKeyPairsList = klayCredentials.getRawEcKeyPairs();
        for (List<ECKeyPair> ecKeyPairs : ecKeyPairsList) {
            ArrayList<WalletFile.Crypto> cryptos = new ArrayList<WalletFile.Crypto>();
            for (ECKeyPair ecKeyPair : ecKeyPairs) {
                WalletFile.Crypto crypto = Wallet.generateCrypto(password, n, p, ecKeyPair);
                cryptos.add(crypto);
            }
            cryptosList.add(cryptos);
        }
        boolean isMultisig = true;
        for (int i = 1; i < cryptosList.size(); ++i) {
            if (((List)cryptosList.get(i)).size() == 0) continue;
            isMultisig = false;
            break;
        }
        ArrayList keyRing = isMultisig ? (List)cryptosList.get(0) : cryptosList;
        walletFile.setKeyring(keyRing);
        walletFile.setId(UUID.randomUUID().toString());
        walletFile.setVersion(4);
        return walletFile;
    }

    private static WalletFile createWalletFile(String password, ECKeyPair ecKeyPair, int n, int p) throws CipherException {
        return Wallet.createWalletFile(password, ecKeyPair, n, p, "");
    }

    private static WalletFile.Crypto generateCrypto(String password, int n, int p, ECKeyPair ecKeyPair) throws CipherException {
        byte[] salt = Wallet.generateRandomBytes(32);
        byte[] derivedKey = Wallet.generateDerivedScryptKey(password.getBytes(StandardCharsets.UTF_8), salt, n, 8, p, 32);
        byte[] encryptKey = Arrays.copyOfRange(derivedKey, 0, 16);
        byte[] iv = Wallet.generateRandomBytes(16);
        byte[] privateKeyBytes = Numeric.toBytesPadded((BigInteger)ecKeyPair.getPrivateKey(), (int)32);
        byte[] cipherText = Wallet.performCipherOperation(1, iv, encryptKey, privateKeyBytes);
        byte[] mac = Wallet.generateMac(derivedKey, cipherText);
        WalletFile.Crypto crypto = new WalletFile.Crypto();
        crypto.setCipher(CIPHER);
        crypto.setCiphertext(Numeric.toHexStringNoPrefix((byte[])cipherText));
        WalletFile.CipherParams cipherParams = new WalletFile.CipherParams();
        cipherParams.setIv(Numeric.toHexStringNoPrefix((byte[])iv));
        crypto.setCipherparams(cipherParams);
        crypto.setKdf(SCRYPT);
        WalletFile.ScryptKdfParams kdfParams = new WalletFile.ScryptKdfParams();
        kdfParams.setDklen(32);
        kdfParams.setN(n);
        kdfParams.setP(p);
        kdfParams.setR(8);
        kdfParams.setSalt(Numeric.toHexStringNoPrefix((byte[])salt));
        crypto.setKdfparams(kdfParams);
        crypto.setMac(Numeric.toHexStringNoPrefix((byte[])mac));
        return crypto;
    }

    private static byte[] generateDerivedScryptKey(byte[] password, byte[] salt, int n, int r, int p, int dkLen) throws CipherException {
        return SCrypt.generate((byte[])password, (byte[])salt, (int)n, (int)r, (int)p, (int)dkLen);
    }

    private static byte[] generateAes128CtrDerivedKey(byte[] password, byte[] salt, int c, String prf) throws CipherException {
        if (!prf.equals("hmac-sha256")) {
            throw new CipherException("Unsupported prf:" + prf);
        }
        PKCS5S2ParametersGenerator gen = new PKCS5S2ParametersGenerator((Digest)new SHA256Digest());
        gen.init(password, salt, c);
        return ((KeyParameter)gen.generateDerivedParameters(256)).getKey();
    }

    private static byte[] performCipherOperation(int mode, byte[] iv, byte[] encryptKey, byte[] text) throws CipherException {
        try {
            IvParameterSpec ivParameterSpec = new IvParameterSpec(iv);
            Cipher cipher = Cipher.getInstance("AES/CTR/NoPadding");
            SecretKeySpec secretKeySpec = new SecretKeySpec(encryptKey, "AES");
            cipher.init(mode, (Key)secretKeySpec, ivParameterSpec);
            return cipher.doFinal(text);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new CipherException("Error performing cipher operation", (Throwable)e);
        }
    }

    private static byte[] generateMac(byte[] derivedKey, byte[] cipherText) {
        byte[] result = new byte[16 + cipherText.length];
        System.arraycopy(derivedKey, 16, result, 0, 16);
        System.arraycopy(cipherText, 0, result, 16, cipherText.length);
        return Hash.sha3((byte[])result);
    }

    public static KlayCredentials decrypt(String password, WalletFile walletFile) throws CipherException {
        Wallet.validate(walletFile);
        if (walletFile.getVersion() == 3) {
            WalletFile.Crypto crypto = walletFile.getCrypto();
            ECKeyPair ecKeyPair = Wallet.getECKeyPair(crypto, password);
            return KlayCredentials.create(ecKeyPair, Numeric.toHexStringWithPrefixZeroPadded((BigInteger)Numeric.toBigInt((String)walletFile.getAddress()), (int)40));
        }
        List keyRing = walletFile.getKeyring();
        ArrayList<List<ECKeyPair>> ecKeyPairForRoleBased = new ArrayList<List<ECKeyPair>>();
        if (keyRing.get(0) instanceof WalletFile.Crypto) {
            ArrayList<ECKeyPair> ecKeyPairs = new ArrayList<ECKeyPair>();
            for (WalletFile.Crypto crypto : keyRing) {
                ECKeyPair ecKeyPair = Wallet.getECKeyPair(crypto, password);
                ecKeyPairs.add(ecKeyPair);
            }
            ecKeyPairForRoleBased.add(ecKeyPairs);
        } else {
            for (List multiKeyRing : keyRing) {
                ArrayList<ECKeyPair> ecKeyPairs = new ArrayList<ECKeyPair>();
                for (WalletFile.Crypto crypto : multiKeyRing) {
                    ECKeyPair ecKeyPair = Wallet.getECKeyPair(crypto, password);
                    ecKeyPairs.add(ecKeyPair);
                }
                ecKeyPairForRoleBased.add(ecKeyPairs);
            }
        }
        return KlayCredentials.createRoleBased(ecKeyPairForRoleBased, Numeric.toHexStringWithPrefixZeroPadded((BigInteger)Numeric.toBigInt((String)walletFile.getAddress()), (int)40));
    }

    static ECKeyPair getECKeyPair(WalletFile.Crypto crypto, String password) throws CipherException {
        byte[] derivedKey;
        byte[] mac = Numeric.hexStringToByteArray((String)crypto.getMac());
        byte[] iv = Numeric.hexStringToByteArray((String)crypto.getCipherparams().getIv());
        byte[] cipherText = Numeric.hexStringToByteArray((String)crypto.getCiphertext());
        WalletFile.KdfParams kdfParams = crypto.getKdfparams();
        if (kdfParams instanceof WalletFile.ScryptKdfParams) {
            WalletFile.ScryptKdfParams scryptKdfParams = (WalletFile.ScryptKdfParams)crypto.getKdfparams();
            int dklen = scryptKdfParams.getDklen();
            int n = scryptKdfParams.getN();
            int p = scryptKdfParams.getP();
            int r = scryptKdfParams.getR();
            byte[] salt = Numeric.hexStringToByteArray((String)scryptKdfParams.getSalt());
            derivedKey = Wallet.generateDerivedScryptKey(password.getBytes(StandardCharsets.UTF_8), salt, n, r, p, dklen);
        } else if (kdfParams instanceof WalletFile.Aes128CtrKdfParams) {
            WalletFile.Aes128CtrKdfParams aes128CtrKdfParams = (WalletFile.Aes128CtrKdfParams)crypto.getKdfparams();
            int c = aes128CtrKdfParams.getC();
            String prf = aes128CtrKdfParams.getPrf();
            byte[] salt = Numeric.hexStringToByteArray((String)aes128CtrKdfParams.getSalt());
            derivedKey = Wallet.generateAes128CtrDerivedKey(password.getBytes(StandardCharsets.UTF_8), salt, c, prf);
        } else {
            throw new CipherException("Unable to deserialize params: " + crypto.getKdf());
        }
        byte[] derivedMac = Wallet.generateMac(derivedKey, cipherText);
        if (!Arrays.equals(derivedMac, mac)) {
            throw new CipherException("Invalid password provided");
        }
        byte[] encryptKey = Arrays.copyOfRange(derivedKey, 0, 16);
        byte[] privateKey = Wallet.performCipherOperation(2, iv, encryptKey, cipherText);
        return ECKeyPair.create((byte[])privateKey);
    }

    static void validate(WalletFile walletFile) throws CipherException {
        if (walletFile.getVersion() != 4 && walletFile.getVersion() != 3) {
            throw new CipherException("Wallet version is not supported");
        }
        if (walletFile.getVersion() == 3) {
            WalletFile.Crypto crypto = walletFile.getCrypto();
            Wallet.validateCrypto(crypto);
            return;
        }
        List keyRing = walletFile.getKeyring();
        if (keyRing.get(0) instanceof WalletFile.Crypto) {
            for (WalletFile.Crypto crypto : keyRing) {
                Wallet.validateCrypto(crypto);
            }
        } else {
            for (Object multiKeyRing : keyRing) {
                for (WalletFile.Crypto crypto : (List)multiKeyRing) {
                    Wallet.validateCrypto(crypto);
                }
            }
        }
    }

    static void validateCrypto(WalletFile.Crypto crypto) throws CipherException {
        if (!crypto.getCipher().equals(CIPHER)) {
            throw new CipherException("Wallet cipher is not supported");
        }
        if (!crypto.getKdf().equals(AES_128_CTR) && !crypto.getKdf().equals(SCRYPT)) {
            throw new CipherException("KDF type is not supported");
        }
    }

    static byte[] generateRandomBytes(int size) {
        byte[] bytes = new byte[size];
        SecureRandomUtils.secureRandom().nextBytes(bytes);
        return bytes;
    }
}

