/*
 * Decompiled with CFR 0.152.
 */
package com.klaytn.caver.wallet;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.klaytn.caver.crypto.KlayCredentials;
import com.klaytn.caver.utils.SecureRandomUtils;
import com.klaytn.caver.wallet.Wallet;
import com.klaytn.caver.wallet.WalletFile;
import java.io.File;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.regex.Pattern;
import org.web3j.crypto.Bip39Wallet;
import org.web3j.crypto.CipherException;
import org.web3j.crypto.ECKeyPair;
import org.web3j.crypto.Hash;
import org.web3j.crypto.Keys;
import org.web3j.crypto.MnemonicUtils;
import org.web3j.utils.Numeric;

public class KlayWalletUtils {
    public static final int ADDRESS_HEX_SIZE = 40;
    private static final int PRIVATE_KEY_HEX_SIZE = 64;
    public static final String CHECKSUM = "0x00";
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private static final SecureRandom secureRandom = SecureRandomUtils.secureRandom();
    private static final Pattern HEX_STRING = Pattern.compile("^[0-9A-Fa-f]+$");

    public static String generateFullNewWalletFile(String address, String password, File destinationDirectory) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidAlgorithmParameterException, CipherException, IOException {
        return KlayWalletUtils.generateNewWalletFile(address, password, destinationDirectory, true);
    }

    public static String generateFullNewWalletFile(String password, File destinationDirectory) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidAlgorithmParameterException, CipherException, IOException {
        return KlayWalletUtils.generateNewWalletFile("", password, destinationDirectory, true);
    }

    public static String generateNewWalletFile(String address, String password, File destinationDirectory) throws CipherException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, NoSuchProviderException, IOException {
        return KlayWalletUtils.generateNewWalletFile(address, password, destinationDirectory, false);
    }

    public static String generateNewWalletFile(String password, File destinationDirectory) throws CipherException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, NoSuchProviderException, IOException {
        return KlayWalletUtils.generateNewWalletFile("", password, destinationDirectory, false);
    }

    public static String generateNewWalletFile(String address, String password, File destinationDirectory, boolean useFullScrypt) throws CipherException, IOException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, NoSuchProviderException {
        ECKeyPair ecKeyPair = Keys.createEcKeyPair();
        return KlayWalletUtils.generateWalletFile(address, password, ecKeyPair, destinationDirectory, useFullScrypt);
    }

    private static String generateWalletFile(String address, String password, ECKeyPair ecKeyPair, File destinationDirectory, boolean useFullScrypt) throws CipherException, IOException {
        WalletFile walletFile = useFullScrypt ? Wallet.createFull(password, ecKeyPair, address) : Wallet.createStandard(password, ecKeyPair, address);
        String fileName = KlayWalletUtils.getWalletFileName(walletFile);
        File destination = new File(destinationDirectory, fileName);
        objectMapper.writeValue(destination, (Object)walletFile);
        return destination.getAbsolutePath();
    }

    public static Bip39Wallet generateBip39Wallet(String address, String password, File destinationDirectory) throws CipherException, IOException {
        byte[] initialEntropy = new byte[16];
        secureRandom.nextBytes(initialEntropy);
        String mnemonic = MnemonicUtils.generateMnemonic((byte[])initialEntropy);
        byte[] seed = MnemonicUtils.generateSeed((String)mnemonic, (String)password);
        ECKeyPair privateKey = ECKeyPair.create((byte[])Hash.sha256((byte[])seed));
        String walletFile = KlayWalletUtils.generateWalletFile(address, password, privateKey, destinationDirectory, false);
        return new Bip39Wallet(walletFile, mnemonic);
    }

    public static KlayCredentials loadCredentials(String password, String source) throws IOException, CipherException {
        return KlayWalletUtils.loadCredentials(password, new File(source));
    }

    public static KlayCredentials loadCredentials(String password, File source) throws IOException, CipherException {
        WalletFile walletFile = (WalletFile)objectMapper.readValue(source, WalletFile.class);
        return Wallet.decrypt(password, walletFile);
    }

    public static KlayCredentials loadCredentials(String klaytnWalletKey) {
        return KlayCredentials.createWithKlaytnWalletKey(klaytnWalletKey);
    }

    public static KlayCredentials loadBip39Credentials(String password, String mnemonic) {
        byte[] seed = MnemonicUtils.generateSeed((String)mnemonic, (String)password);
        ECKeyPair ecKeyPair = ECKeyPair.create((byte[])Hash.sha256((byte[])seed));
        String address = Numeric.prependHexPrefix((String)Keys.getAddress((ECKeyPair)ecKeyPair));
        return KlayCredentials.create(ECKeyPair.create((byte[])Hash.sha256((byte[])seed)), address);
    }

    private static String getWalletFileName(WalletFile walletFile) {
        DateTimeFormatter format = DateTimeFormatter.ofPattern("'UTC--'yyyy-MM-dd'T'HH-mm-ss.nVV'--'");
        ZonedDateTime now = ZonedDateTime.now(ZoneOffset.UTC);
        return now.format(format) + walletFile.getAddress() + ".json";
    }

    public static String getBaobabKeyDirectory() {
        String directory = String.format("%s%sbaobab", KlayWalletUtils.getDefaultKeyDirectory(), File.separator);
        KlayWalletUtils.createDirectoryIfNotPresent(directory);
        return directory;
    }

    public static String getMainnetKeyDirectory() {
        String directory = String.format("%s%smainnet", KlayWalletUtils.getDefaultKeyDirectory(), File.separator);
        KlayWalletUtils.createDirectoryIfNotPresent(directory);
        return directory;
    }

    @Deprecated
    public static boolean isValidPrivateKey(String privateKey) {
        String cleanPrivateKey = Numeric.cleanHexPrefix((String)privateKey);
        return cleanPrivateKey.length() <= 64 && HEX_STRING.matcher(cleanPrivateKey).matches();
    }

    @Deprecated
    public static boolean isValidAddress(String input) {
        String cleanInput = Numeric.cleanHexPrefix((String)input);
        try {
            Numeric.toBigIntNoPrefix((String)cleanInput);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return cleanInput.length() == 40 && HEX_STRING.matcher(cleanInput).matches();
    }

    public static String getDefaultKeyDirectory() {
        String defaultDirectory = KlayWalletUtils.getDefaultKeyDirectory(System.getProperty("os.name"));
        KlayWalletUtils.createDirectoryIfNotPresent(defaultDirectory);
        return KlayWalletUtils.getDefaultKeyDirectory(System.getProperty("os.name"));
    }

    private static void createDirectoryIfNotPresent(String defaultDirectory) {
        File file = new File(defaultDirectory);
        if (!file.exists() && !file.mkdirs()) {
            throw new RuntimeException(String.format("Default key directory is not created", defaultDirectory));
        }
    }

    static String getDefaultKeyDirectory(String osName1) {
        String osName = osName1.toLowerCase();
        if (osName.startsWith("mac")) {
            return String.format("%s%sLibrary%sKlaytn%skeystore", System.getProperty("user.home"), File.separator, File.separator, File.separator);
        }
        if (osName.startsWith("win")) {
            return String.format("%s%sKlaytn%skeystore", System.getenv("APPDATA"), File.separator, File.separator);
        }
        return String.format("%s%s.Klaytn%skeystore", System.getProperty("user.home"), File.separator, File.separator);
    }

    static {
        objectMapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }
}

