/*
 * Decompiled with CFR 0.152.
 */
package com.klaytn.caver.wallet;

import com.klaytn.caver.transaction.AbstractFeeDelegatedTransaction;
import com.klaytn.caver.transaction.AbstractTransaction;
import com.klaytn.caver.transaction.TransactionHasher;
import com.klaytn.caver.utils.Utils;
import com.klaytn.caver.wallet.IWallet;
import com.klaytn.caver.wallet.keyring.AbstractKeyring;
import com.klaytn.caver.wallet.keyring.KeyringFactory;
import com.klaytn.caver.wallet.keyring.MessageSigned;
import com.klaytn.caver.wallet.keyring.MultipleKeyring;
import com.klaytn.caver.wallet.keyring.RoleBasedKeyring;
import com.klaytn.caver.wallet.keyring.SingleKeyring;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class KeyringContainer
implements IWallet {
    Map<String, AbstractKeyring> addressKeyringMap = new HashMap<String, AbstractKeyring>();

    public KeyringContainer() {
    }

    public KeyringContainer(List<AbstractKeyring> keyrings) {
        keyrings.stream().forEach(this::add);
    }

    @Override
    public List<String> generate(int num) {
        return this.generate(num, null);
    }

    public List<String> generate(int num, String entropy) {
        ArrayList<String> addressList = new ArrayList<String>();
        for (int i = 0; i < num; ++i) {
            SingleKeyring keyring = KeyringFactory.generate(entropy);
            addressList.add(keyring.getAddress());
            this.add(keyring);
        }
        return addressList;
    }

    public int length() {
        return this.addressKeyringMap.size();
    }

    public AbstractKeyring newKeyring(String address, String key) {
        SingleKeyring keyring = KeyringFactory.createWithSingleKey(address, key);
        return this.add(keyring);
    }

    public AbstractKeyring newKeyring(String address, String[] keys) {
        MultipleKeyring keyring = KeyringFactory.createWithMultipleKey(address, keys);
        return this.add(keyring);
    }

    public AbstractKeyring newKeyring(String address, List<String[]> keys) {
        RoleBasedKeyring keyring = KeyringFactory.createWithRoleBasedKey(address, keys);
        return this.add(keyring);
    }

    public AbstractKeyring updateKeyring(AbstractKeyring keyring) {
        AbstractKeyring founded = this.getKeyring(keyring.getAddress());
        if (founded == null) {
            throw new IllegalArgumentException("Failed to find keyring to update.");
        }
        this.remove(keyring.getAddress());
        return this.add(keyring);
    }

    public AbstractKeyring getKeyring(String address) {
        if (!Utils.isAddress(address)) {
            throw new IllegalArgumentException("Invalid address. To get keyring from wallet, you need to pass a valid address string as a parameter.");
        }
        AbstractKeyring found = this.addressKeyringMap.get(address.toLowerCase());
        return found;
    }

    public AbstractKeyring add(AbstractKeyring keyring) {
        if (this.getKeyring(keyring.getAddress()) != null) {
            throw new IllegalArgumentException("Duplicated Account. Please use updateKeyring() instead");
        }
        AbstractKeyring added = keyring.copy();
        this.addressKeyringMap.put(keyring.getAddress().toLowerCase(), added);
        return added;
    }

    @Override
    public boolean remove(String address) {
        if (!Utils.isAddress(address)) {
            throw new IllegalArgumentException("To remove keyring, the first parameter should be an address string");
        }
        if (!this.isExisted(address)) {
            return false;
        }
        AbstractKeyring removed = this.addressKeyringMap.remove(address);
        removed = null;
        return true;
    }

    public MessageSigned signMessage(String address, String data) {
        return this.signMessage(address, data, 0, 0);
    }

    public MessageSigned signMessage(String address, String data, int role, int index) {
        if (!this.isExisted(address)) {
            throw new NullPointerException("Failed to find keyring from wallet with address");
        }
        return this.getKeyring(address).signMessage(data, role, index);
    }

    @Override
    public AbstractTransaction sign(String address, AbstractTransaction transaction) throws IOException {
        return this.sign(address, transaction, TransactionHasher::getHashForSignature);
    }

    public AbstractTransaction sign(String address, AbstractTransaction transaction, Function<AbstractTransaction, String> hasher) throws IOException {
        if (!this.isExisted(address)) {
            throw new NullPointerException("Failed to find keyring from wallet with address");
        }
        return transaction.sign(this.getKeyring(address), hasher);
    }

    public AbstractTransaction sign(String address, AbstractTransaction transaction, int index) throws IOException {
        return this.sign(address, transaction, index, TransactionHasher::getHashForSignature);
    }

    public AbstractTransaction sign(String address, AbstractTransaction transaction, int index, Function<AbstractTransaction, String> hasher) throws IOException {
        if (!this.isExisted(address)) {
            throw new NullPointerException("Failed to find keyring from wallet with address");
        }
        return transaction.sign(this.getKeyring(address), index, hasher);
    }

    @Override
    public AbstractFeeDelegatedTransaction signAsFeePayer(String address, AbstractFeeDelegatedTransaction transaction) throws IOException {
        return this.signAsFeePayer(address, transaction, TransactionHasher::getHashForFeePayerSignature);
    }

    public AbstractFeeDelegatedTransaction signAsFeePayer(String address, AbstractFeeDelegatedTransaction transaction, Function<AbstractFeeDelegatedTransaction, String> hasher) throws IOException {
        if (!this.isExisted(address)) {
            throw new NullPointerException("Failed to find keyring from wallet with address");
        }
        return transaction.signAsFeePayer(this.getKeyring(address), hasher);
    }

    public AbstractFeeDelegatedTransaction signAsFeePayer(String address, AbstractFeeDelegatedTransaction transaction, int index) throws IOException {
        return this.signAsFeePayer(address, transaction, index, TransactionHasher::getHashForFeePayerSignature);
    }

    public AbstractFeeDelegatedTransaction signAsFeePayer(String address, AbstractFeeDelegatedTransaction transaction, int index, Function<AbstractFeeDelegatedTransaction, String> hasher) throws IOException {
        if (!this.isExisted(address)) {
            throw new NullPointerException("Failed to find keyring from wallet with address");
        }
        return transaction.signAsFeePayer(this.getKeyring(address), index, hasher);
    }

    @Override
    public boolean isExisted(String address) {
        return this.getKeyring(address) != null;
    }
}

