/*
 * Decompiled with CFR 0.152.
 */
package com.klaytn.caver.tx.manager;

import com.klaytn.caver.Caver;
import com.klaytn.caver.crypto.KlayCredentials;
import com.klaytn.caver.crypto.KlaySignatureData;
import com.klaytn.caver.methods.response.Bytes32;
import com.klaytn.caver.methods.response.KlayTransactionReceipt;
import com.klaytn.caver.tx.exception.EmptyNonceException;
import com.klaytn.caver.tx.exception.PlatformErrorException;
import com.klaytn.caver.tx.exception.UnsupportedTxTypeException;
import com.klaytn.caver.tx.manager.ErrorHandler;
import com.klaytn.caver.tx.manager.GetNonceProcessor;
import com.klaytn.caver.tx.manager.PollingTransactionReceiptProcessor;
import com.klaytn.caver.tx.manager.TransactionReceiptProcessor;
import com.klaytn.caver.tx.model.KlayRawTransaction;
import com.klaytn.caver.tx.model.TransactionTransformer;
import com.klaytn.caver.tx.type.AbstractTxType;
import com.klaytn.caver.utils.ChainId;
import com.klaytn.caver.utils.TransactionDecoder;
import com.klaytn.caver.wallet.WalletManager;
import com.klaytn.caver.wallet.exception.CredentialNotFoundException;
import java.io.IOException;
import java.util.Set;
import org.web3j.protocol.exceptions.TransactionException;

@Deprecated
public class TransactionManager {
    private Caver caver;
    private WalletManager walletManager;
    private int chainId;
    private TransactionReceiptProcessor transactionReceiptProcessor;
    private ErrorHandler errorHandler;
    private GetNonceProcessor getNonceProcessor;

    private TransactionManager(Builder builder) {
        this.caver = builder.caver;
        this.walletManager = builder.walletManager;
        this.chainId = builder.chainId;
        this.transactionReceiptProcessor = builder.transactionReceiptProcessor;
        this.errorHandler = builder.errorHandler;
        this.getNonceProcessor = builder.getNonceProcessor;
    }

    public KlayTransactionReceipt.TransactionReceipt executeTransaction(TransactionTransformer transactionTransformer) {
        KlayTransactionReceipt.TransactionReceipt receipt = null;
        KlayRawTransaction rawTx = this.sign(transactionTransformer);
        try {
            String transactionHash = this.send(rawTx);
            receipt = this.transactionReceiptProcessor.waitForTransactionReceipt(transactionHash);
        }
        catch (PlatformErrorException | IOException | TransactionException e) {
            this.exception((Exception)e);
        }
        return receipt;
    }

    public KlayTransactionReceipt.TransactionReceipt executeTransaction(AbstractTxType txType) {
        KlayTransactionReceipt.TransactionReceipt receipt = null;
        KlayRawTransaction rawTx = this.sign(txType);
        try {
            String transactionHash = this.send(rawTx);
            receipt = this.transactionReceiptProcessor.waitForTransactionReceipt(transactionHash);
        }
        catch (PlatformErrorException | IOException | TransactionException e) {
            this.exception((Exception)e);
        }
        return receipt;
    }

    public KlayTransactionReceipt.TransactionReceipt executeTransaction(String rawTransaction) {
        AbstractTxType txType = TransactionDecoder.decode(rawTransaction);
        return this.executeTransaction(txType);
    }

    public Set<KlaySignatureData> makeSignatureData(AbstractTxType txType) {
        Set<KlaySignatureData> result = null;
        try {
            KlayCredentials credentials = this.walletManager.findByAddress(txType.getFrom());
            result = txType.getSenderSignatureDataSet();
            result.addAll(txType.getNewSenderSignatureDataSet(credentials, this.chainId));
        }
        catch (EmptyNonceException | CredentialNotFoundException e) {
            this.exception(e);
        }
        return result;
    }

    public KlayRawTransaction sign(AbstractTxType txType) {
        KlayRawTransaction result = null;
        try {
            KlayCredentials credentials = this.walletManager.findByAddress(txType.getFrom());
            result = txType.sign(credentials, this.chainId);
        }
        catch (EmptyNonceException | CredentialNotFoundException e) {
            this.exception(e);
        }
        return result;
    }

    public KlayRawTransaction sign(String klayRawTransaction) {
        AbstractTxType txType = TransactionDecoder.decode(klayRawTransaction);
        return this.sign(txType);
    }

    public KlayRawTransaction sign(TransactionTransformer transactionTransformer) {
        KlayRawTransaction result = null;
        try {
            KlayCredentials credentials = this.walletManager.findByAddress(transactionTransformer.getFrom());
            if (transactionTransformer.getNonce() == null) {
                transactionTransformer.nonce(this.getNonceProcessor.getNonce(credentials));
            }
            result = transactionTransformer.build().sign(credentials, this.chainId);
        }
        catch (EmptyNonceException | UnsupportedTxTypeException | CredentialNotFoundException | IOException e) {
            this.exception(e);
        }
        return result;
    }

    public String send(KlayRawTransaction klayRawTransaction) throws IOException, PlatformErrorException {
        Bytes32 transactionHash = (Bytes32)this.caver.klay().sendSignedTransaction(klayRawTransaction.getValueAsString()).send();
        if (transactionHash.hasError()) {
            throw new PlatformErrorException(transactionHash.getError());
        }
        return (String)transactionHash.getResult();
    }

    public String getDefaultAddress() {
        KlayCredentials credentials = null;
        try {
            credentials = this.walletManager.getDefault();
        }
        catch (CredentialNotFoundException e) {
            this.exception(e);
        }
        return credentials.getAddress();
    }

    private void exception(Exception e) {
        if (this.errorHandler != null) {
            this.errorHandler.exception(e);
        }
    }

    public static class Builder {
        private Caver caver;
        private WalletManager walletManager;
        private int chainId = -1;
        private GetNonceProcessor getNonceProcessor;
        private TransactionReceiptProcessor transactionReceiptProcessor;
        private ErrorHandler errorHandler;

        public Builder(Caver caver, WalletManager walletManager) {
            this.caver = caver;
            this.walletManager = walletManager;
        }

        public Builder(Caver caver, KlayCredentials credentials) {
            this.caver = caver;
            WalletManager walletManager = new WalletManager();
            walletManager.add(credentials);
            this.walletManager = walletManager;
        }

        public Builder setChaindId(int chaindId) {
            this.chainId = chaindId;
            return this;
        }

        public Builder setGetNonceProcessor(GetNonceProcessor getNonceProcessor) {
            this.getNonceProcessor = getNonceProcessor;
            return this;
        }

        public Builder setTransactionReceiptProcessor(TransactionReceiptProcessor transactionReceiptProcessor) {
            this.transactionReceiptProcessor = transactionReceiptProcessor;
            return this;
        }

        public Builder setErrorHandler(ErrorHandler errorHandler) {
            this.errorHandler = errorHandler;
            return this;
        }

        public TransactionManager build() {
            if (this.chainId == -1) {
                this.chainId = ChainId.BAOBAB_TESTNET;
            }
            if (this.getNonceProcessor == null) {
                this.getNonceProcessor = new GetNonceProcessor(this.caver);
            }
            if (this.transactionReceiptProcessor == null) {
                this.transactionReceiptProcessor = new PollingTransactionReceiptProcessor(this.caver, 1000L, 15);
            }
            return new TransactionManager(this);
        }
    }
}

