/*
 * Decompiled with CFR 0.152.
 */
package com.klaytn.caver.tx;

import com.klaytn.caver.Caver;
import com.klaytn.caver.crypto.KlayCredentials;
import com.klaytn.caver.methods.request.CallObject;
import com.klaytn.caver.methods.response.Bytes;
import com.klaytn.caver.methods.response.KlayLogs;
import com.klaytn.caver.methods.response.KlayTransactionReceipt;
import com.klaytn.caver.tx.ManagedTransaction;
import com.klaytn.caver.tx.manager.ErrorHandler;
import com.klaytn.caver.tx.manager.TransactionManager;
import com.klaytn.caver.tx.model.SmartContractDeployTransaction;
import com.klaytn.caver.tx.model.SmartContractExecutionTransaction;
import com.klaytn.caver.tx.model.TransactionTransformer;
import com.klaytn.caver.utils.CodeFormat;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.web3j.abi.EventEncoder;
import org.web3j.abi.EventValues;
import org.web3j.abi.FunctionEncoder;
import org.web3j.abi.FunctionReturnDecoder;
import org.web3j.abi.TypeReference;
import org.web3j.abi.datatypes.Address;
import org.web3j.abi.datatypes.Event;
import org.web3j.abi.datatypes.Function;
import org.web3j.abi.datatypes.Type;
import org.web3j.protocol.core.DefaultBlockParameter;
import org.web3j.protocol.core.DefaultBlockParameterName;
import org.web3j.protocol.core.RemoteCall;
import org.web3j.protocol.exceptions.TransactionException;
import org.web3j.tx.exceptions.ContractCallException;
import org.web3j.tx.gas.ContractGasProvider;
import org.web3j.tx.gas.StaticGasProvider;
import org.web3j.utils.Numeric;

@Deprecated
public class SmartContract
extends ManagedTransaction {
    public static final BigInteger GAS_LIMIT = BigInteger.valueOf(4300000L);
    public static final String BIN_NOT_PROVIDED = "Bin file was not provided";
    public static final String FUNC_DEPLOY = "deploy";
    protected String contractBinary;
    protected String contractAddress;
    protected ContractGasProvider gasProvider;
    protected KlayTransactionReceipt.TransactionReceipt transactionReceipt;
    protected Map<String, String> deployedAddresses;
    protected DefaultBlockParameter defaultBlockParameter = DefaultBlockParameterName.LATEST;

    private SmartContract(Caver caver, TransactionManager transactionManager) {
        super(caver, transactionManager);
    }

    protected SmartContract(String contractBinary, String contractAddress, Caver caver, TransactionManager transactionManager, ContractGasProvider gasProvider) {
        super(caver, transactionManager);
        this.contractAddress = contractAddress;
        this.contractBinary = contractBinary;
        this.gasProvider = gasProvider;
    }

    protected SmartContract(String contractBinary, String contractAddress, Caver caver, KlayCredentials credentials, int chainId, ContractGasProvider gasProvider) {
        this(contractBinary, contractAddress, caver, new TransactionManager.Builder(caver, credentials).setChaindId(chainId).build(), gasProvider);
    }

    protected SmartContract(String contractAddress, Caver caver, TransactionManager transactionManager, ContractGasProvider gasProvider) {
        this("", contractAddress, caver, transactionManager, gasProvider);
    }

    protected SmartContract(String contractAddress, Caver caver, KlayCredentials credentials, int chainId, ContractGasProvider gasProvider) {
        this("", contractAddress, caver, new TransactionManager.Builder(caver, credentials).setChaindId(chainId).build(), gasProvider);
    }

    public static SmartContract create(Caver caver, TransactionManager transactionManager) {
        return new SmartContract(caver, transactionManager);
    }

    public static SmartContract create(Caver caver, KlayCredentials klayCredentials, int chainId) {
        TransactionManager transactionManager = new TransactionManager.Builder(caver, klayCredentials).setChaindId(chainId).build();
        return SmartContract.create(caver, transactionManager);
    }

    public RemoteCall<KlayTransactionReceipt.TransactionReceipt> sendDeployTransaction(SmartContractDeployTransaction transaction) {
        return new RemoteCall(() -> this.send(transaction));
    }

    public RemoteCall<KlayTransactionReceipt.TransactionReceipt> sendExecutionTransaction(SmartContractExecutionTransaction transaction) {
        return new RemoteCall(() -> this.send(transaction));
    }

    @Deprecated
    public static RemoteCall<KlayTransactionReceipt.TransactionReceipt> sendDeployTransaction(Caver caver, KlayCredentials credentials, SmartContractDeployTransaction transaction) {
        return SmartContract.sendDeployTransaction(caver, credentials, transaction, null);
    }

    @Deprecated
    public static RemoteCall<KlayTransactionReceipt.TransactionReceipt> sendDeployTransaction(Caver caver, KlayCredentials credentials, SmartContractDeployTransaction transaction, ErrorHandler errorHandler) {
        TransactionManager transactionManager = new TransactionManager.Builder(caver, credentials).setErrorHandler(errorHandler).build();
        return new RemoteCall(() -> new SmartContract(caver, transactionManager).send(transaction));
    }

    @Deprecated
    public static RemoteCall<KlayTransactionReceipt.TransactionReceipt> sendExecutionTransaction(Caver caver, KlayCredentials credentials, SmartContractExecutionTransaction transaction) {
        return SmartContract.sendExecutionTransaction(caver, credentials, transaction, null);
    }

    @Deprecated
    public static RemoteCall<KlayTransactionReceipt.TransactionReceipt> sendExecutionTransaction(Caver caver, KlayCredentials credentials, SmartContractExecutionTransaction transaction, ErrorHandler errorHandler) {
        TransactionManager transactionManager = new TransactionManager.Builder(caver, credentials).setErrorHandler(errorHandler).build();
        return new RemoteCall(() -> new SmartContract(caver, transactionManager).send(transaction));
    }

    public void setContractAddress(String contractAddress) {
        this.contractAddress = contractAddress;
    }

    public String getContractAddress() {
        return this.contractAddress;
    }

    public void setTransactionReceipt(KlayTransactionReceipt.TransactionReceipt transactionReceipt) {
        this.transactionReceipt = transactionReceipt;
    }

    public String getContractBinary() {
        return this.contractBinary;
    }

    public void setGasProvider(ContractGasProvider gasProvider) {
        this.gasProvider = gasProvider;
    }

    public void setGasPrice(BigInteger newPrice) {
        this.gasProvider = new StaticGasProvider(newPrice, this.gasProvider.getGasLimit());
    }

    public BigInteger getGasPrice() {
        return this.gasProvider.getGasPrice();
    }

    public boolean isValid() throws IOException {
        if (this.contractBinary.equals(BIN_NOT_PROVIDED)) {
            throw new UnsupportedOperationException("Contract binary not present in contract wrapper, please generate your wrapper using -abiFile=<file>");
        }
        if (this.contractAddress.equals("")) {
            throw new UnsupportedOperationException("Contract binary not present, you will need to regenerate your smart");
        }
        Bytes klayGetCode = (Bytes)this.caver.klay().getCode(this.contractAddress, (DefaultBlockParameter)DefaultBlockParameterName.LATEST).send();
        if (klayGetCode.hasError()) {
            return false;
        }
        String code = Numeric.cleanHexPrefix((String)((String)klayGetCode.getResult()));
        return !code.isEmpty() && this.contractBinary.contains(code);
    }

    public Optional<KlayTransactionReceipt.TransactionReceipt> getTransactionReceipt() {
        return Optional.ofNullable(this.transactionReceipt);
    }

    public void setDefaultBlockParameter(DefaultBlockParameter defaultBlockParameter) {
        this.defaultBlockParameter = defaultBlockParameter;
    }

    private List<Type> executeCall(Function function) throws IOException {
        String encodedFunction = FunctionEncoder.encode((Function)function);
        Bytes klayCall = (Bytes)this.caver.klay().call(new CallObject(this.transactionManager.getDefaultAddress(), this.contractAddress, null, null, null, encodedFunction), this.defaultBlockParameter).send();
        String value = (String)klayCall.getResult();
        return FunctionReturnDecoder.decode((String)value, (List)function.getOutputParameters());
    }

    protected <T extends Type> T executeCallSingleValueReturn(Function function) throws IOException {
        List<Type> values = this.executeCall(function);
        if (!values.isEmpty()) {
            return (T)values.get(0);
        }
        return null;
    }

    protected <T extends Type, R> R executeCallSingleValueReturn(Function function, Class<R> returnType) throws IOException {
        T result = this.executeCallSingleValueReturn(function);
        if (result == null) {
            throw new ContractCallException("Empty value (0x) returned from contract");
        }
        Object value = result.getValue();
        if (returnType.isAssignableFrom(value.getClass())) {
            return (R)value;
        }
        if (result.getClass().equals(Address.class) && returnType.equals(String.class)) {
            return (R)result.toString();
        }
        throw new ContractCallException("Unable to convert response: " + value + " to expected type: " + returnType.getSimpleName());
    }

    protected List<Type> executeCallMultipleValueReturn(Function function) throws IOException {
        return this.executeCall(function);
    }

    protected KlayTransactionReceipt.TransactionReceipt executeTransaction(Function function) throws TransactionException {
        return this.executeTransaction(function, BigInteger.ZERO);
    }

    private KlayTransactionReceipt.TransactionReceipt executeTransaction(Function function, BigInteger weiValue) throws TransactionException {
        return this.executeTransaction(FunctionEncoder.encode((Function)function), weiValue, function.getName());
    }

    KlayTransactionReceipt.TransactionReceipt executeTransaction(String data, BigInteger pebValue, String funcName) throws TransactionException {
        TransactionTransformer transactionTransformer = FUNC_DEPLOY.equals(funcName) ? SmartContractDeployTransaction.create(this.transactionManager.getDefaultAddress(), pebValue, Numeric.hexStringToByteArray((String)data), this.gasProvider.getGasPrice(funcName), this.gasProvider.getGasLimit(funcName), CodeFormat.EVM) : SmartContractExecutionTransaction.create(this.transactionManager.getDefaultAddress(), this.contractAddress, pebValue, Numeric.hexStringToByteArray((String)data), this.gasProvider.getGasPrice(funcName), this.gasProvider.getGasLimit(funcName));
        KlayTransactionReceipt.TransactionReceipt receipt = this.send(transactionTransformer);
        return receipt;
    }

    protected <T extends Type> RemoteCall<T> executeRemoteCallSingleValueReturn(Function function) {
        return new RemoteCall(() -> this.executeCallSingleValueReturn(function));
    }

    protected <T> RemoteCall<T> executeRemoteCallSingleValueReturn(Function function, Class<T> returnType) {
        return new RemoteCall(() -> this.executeCallSingleValueReturn(function, returnType));
    }

    protected RemoteCall<List<Type>> executeRemoteCallMultipleValueReturn(Function function) {
        return new RemoteCall(() -> this.executeCallMultipleValueReturn(function));
    }

    protected RemoteCall<KlayTransactionReceipt.TransactionReceipt> executeRemoteCallTransaction(Function function) {
        return new RemoteCall(() -> this.executeTransaction(function));
    }

    protected RemoteCall<KlayTransactionReceipt.TransactionReceipt> executeRemoteCallTransaction(Function function, BigInteger weiValue) {
        return new RemoteCall(() -> this.executeTransaction(function, weiValue));
    }

    private static <T extends SmartContract> T create(T contract, String binary, String encodedConstructor, BigInteger value) throws IOException, TransactionException {
        KlayTransactionReceipt.TransactionReceipt transactionReceipt = contract.executeTransaction(binary + encodedConstructor, value, FUNC_DEPLOY);
        String contractAddress = transactionReceipt.getContractAddress();
        if (contractAddress == null) {
            throw new RuntimeException("Empty contract address returned");
        }
        contract.setContractAddress(contractAddress);
        contract.setTransactionReceipt(transactionReceipt);
        return contract;
    }

    protected static <T extends SmartContract> T deploy(Class<T> type, Caver caver, KlayCredentials credentials, int chainId, ContractGasProvider contractGasProvider, String binary, String encodedConstructor, BigInteger value) throws RuntimeException, TransactionException {
        try {
            Constructor<T> constructor = type.getDeclaredConstructor(String.class, Caver.class, KlayCredentials.class, Integer.TYPE, ContractGasProvider.class);
            constructor.setAccessible(true);
            SmartContract contract = (SmartContract)constructor.newInstance(null, caver, credentials, chainId, contractGasProvider);
            return (T)SmartContract.create(contract, binary, encodedConstructor, value);
        }
        catch (TransactionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected static <T extends SmartContract> T deploy(Class<T> type, Caver caver, TransactionManager transactionManager, ContractGasProvider contractGasProvider, String binary, String encodedConstructor, BigInteger value) throws RuntimeException, TransactionException {
        try {
            Constructor<T> constructor = type.getDeclaredConstructor(String.class, Caver.class, TransactionManager.class, ContractGasProvider.class);
            constructor.setAccessible(true);
            SmartContract contract = (SmartContract)constructor.newInstance(null, caver, transactionManager, contractGasProvider);
            return (T)SmartContract.create(contract, binary, encodedConstructor, value);
        }
        catch (TransactionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T extends SmartContract> RemoteCall<T> deployRemoteCall(Class<T> type, Caver caver, KlayCredentials credentials, int chainId, ContractGasProvider contractGasProvider, String binary, String encodedConstructor, BigInteger value) {
        return new RemoteCall(() -> SmartContract.deploy(type, caver, credentials, chainId, contractGasProvider, binary, encodedConstructor, value));
    }

    public static <T extends SmartContract> RemoteCall<T> deployRemoteCall(Class<T> type, Caver caver, KlayCredentials credentials, int chainId, ContractGasProvider contractGasProvider, String binary, String encodedConstructor) {
        return new RemoteCall(() -> SmartContract.deploy(type, caver, credentials, chainId, contractGasProvider, binary, encodedConstructor, BigInteger.ZERO));
    }

    public static <T extends SmartContract> RemoteCall<T> deployRemoteCall(Class<T> type, Caver caver, TransactionManager transactionManager, ContractGasProvider contractGasProvider, String binary, String encodedConstructor, BigInteger value) {
        return new RemoteCall(() -> SmartContract.deploy(type, caver, transactionManager, contractGasProvider, binary, encodedConstructor, value));
    }

    public static <T extends SmartContract> RemoteCall<T> deployRemoteCall(Class<T> type, Caver caver, TransactionManager transactionManager, ContractGasProvider contractGasProvider, String binary, String encodedConstructor) {
        return new RemoteCall(() -> SmartContract.deploy(type, caver, transactionManager, contractGasProvider, binary, encodedConstructor, BigInteger.ZERO));
    }

    public static EventValues staticExtractEventParameters(Event event, KlayLogs.Log log) {
        List<String> topics = log.getTopics();
        String encodedEventSignature = EventEncoder.encode((Event)event);
        if (topics == null || topics.size() == 0 || !topics.get(0).equals(encodedEventSignature)) {
            return null;
        }
        ArrayList<Type> indexedValues = new ArrayList<Type>();
        List nonIndexedValues = FunctionReturnDecoder.decode((String)log.getData(), (List)event.getNonIndexedParameters());
        List indexedParameters = event.getIndexedParameters();
        for (int i = 0; i < indexedParameters.size(); ++i) {
            Type value = FunctionReturnDecoder.decodeIndexedValue((String)topics.get(i + 1), (TypeReference)((TypeReference)indexedParameters.get(i)));
            indexedValues.add(value);
        }
        return new EventValues(indexedValues, nonIndexedValues);
    }

    protected EventValues extractEventParameters(Event event, KlayLogs.Log log) {
        return SmartContract.staticExtractEventParameters(event, log);
    }

    protected List<EventValues> extractEventParameters(Event event, KlayTransactionReceipt.TransactionReceipt transactionReceipt) {
        return transactionReceipt.getLogs().stream().map(log -> this.extractEventParameters(event, (KlayLogs.Log)log)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    protected EventValuesWithLog extractEventParametersWithLog(Event event, KlayLogs.Log log) {
        EventValues eventValues = SmartContract.staticExtractEventParameters(event, log);
        return eventValues == null ? null : new EventValuesWithLog(eventValues, log);
    }

    protected List<EventValuesWithLog> extractEventParametersWithLog(Event event, KlayTransactionReceipt.TransactionReceipt transactionReceipt) {
        return transactionReceipt.getLogs().stream().map(log -> this.extractEventParametersWithLog(event, (KlayLogs.Log)log)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    protected String getStaticDeployedAddress(String networkId) {
        return null;
    }

    public final void setDeployedAddress(String networkId, String address) {
        if (this.deployedAddresses == null) {
            this.deployedAddresses = new HashMap<String, String>();
        }
        this.deployedAddresses.put(networkId, address);
    }

    public final String getDeployedAddress(String networkId) {
        String addr = null;
        if (this.deployedAddresses != null) {
            addr = this.deployedAddresses.get(networkId);
        }
        return addr == null ? this.getStaticDeployedAddress(networkId) : addr;
    }

    protected static <S extends Type, T> List<T> convertToNative(List<S> arr) {
        ArrayList<Object> out = new ArrayList<Object>();
        Iterator<S> it = arr.iterator();
        while (it.hasNext()) {
            out.add(((Type)it.next()).getValue());
        }
        return out;
    }

    public static class EventValuesWithLog {
        private final EventValues eventValues;
        private final KlayLogs.Log log;

        private EventValuesWithLog(EventValues eventValues, KlayLogs.Log log) {
            this.eventValues = eventValues;
            this.log = log;
        }

        public List<Type> getIndexedValues() {
            return this.eventValues.getIndexedValues();
        }

        public List<Type> getNonIndexedValues() {
            return this.eventValues.getNonIndexedValues();
        }

        public KlayLogs.Log getLog() {
            return this.log;
        }
    }
}

