/*
 * Decompiled with CFR 0.152.
 */
package com.klaytn.caver.transaction.type;

import com.klaytn.caver.rpc.Klay;
import com.klaytn.caver.transaction.AbstractTransaction;
import com.klaytn.caver.transaction.type.TransactionType;
import com.klaytn.caver.utils.BytesUtils;
import com.klaytn.caver.utils.CodeFormat;
import com.klaytn.caver.utils.Utils;
import com.klaytn.caver.wallet.keyring.SignatureData;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.web3j.rlp.RlpDecoder;
import org.web3j.rlp.RlpEncoder;
import org.web3j.rlp.RlpList;
import org.web3j.rlp.RlpString;
import org.web3j.rlp.RlpType;
import org.web3j.utils.Numeric;

public class SmartContractDeploy
extends AbstractTransaction {
    String to = "0x";
    String value = "0x00";
    String input;
    boolean humanReadable = false;
    String codeFormat = Numeric.toHexStringWithPrefix((BigInteger)CodeFormat.EVM);

    public SmartContractDeploy(Builder builder) {
        super(builder);
        this.setTo(builder.to);
        this.setValue(builder.value);
        this.setInput(builder.input);
        this.setHumanReadable(builder.humanReadable);
        this.setCodeFormat(builder.codeFormat);
    }

    public SmartContractDeploy(Klay klaytnCall, String from, String nonce, String gas, String gasPrice, String chainId, List<SignatureData> signatures, String to, String value, String input, boolean humanReadable, String codeFormat) {
        super(klaytnCall, TransactionType.TxTypeSmartContractDeploy.toString(), from, nonce, gas, gasPrice, chainId, signatures);
        this.setTo(to);
        this.setValue(value);
        this.setInput(input);
        this.setHumanReadable(humanReadable);
        this.setCodeFormat(codeFormat);
    }

    public static SmartContractDeploy decode(String rlpEncoded) {
        return SmartContractDeploy.decode(Numeric.hexStringToByteArray((String)rlpEncoded));
    }

    public static SmartContractDeploy decode(byte[] rlpEncoded) {
        if (rlpEncoded[0] != (byte)TransactionType.TxTypeSmartContractDeploy.getType()) {
            throw new IllegalArgumentException("Invalid RLP-encoded tag - " + TransactionType.TxTypeSmartContractDeploy.toString());
        }
        byte[] detachedType = Arrays.copyOfRange(rlpEncoded, 1, rlpEncoded.length);
        RlpList rlpList = RlpDecoder.decode((byte[])detachedType);
        List values = ((RlpList)rlpList.getValues().get(0)).getValues();
        BigInteger nonce = ((RlpString)values.get(0)).asPositiveBigInteger();
        BigInteger gasPrice = ((RlpString)values.get(1)).asPositiveBigInteger();
        BigInteger gas = ((RlpString)values.get(2)).asPositiveBigInteger();
        String to = ((RlpString)values.get(3)).asString();
        BigInteger value = ((RlpString)values.get(4)).asPositiveBigInteger();
        String from = ((RlpString)values.get(5)).asString();
        String input = ((RlpString)values.get(6)).asString();
        boolean humanReadable = ((RlpString)values.get(7)).asPositiveBigInteger().compareTo(BigInteger.ZERO) != 0;
        BigInteger codeFormat = ((RlpString)values.get(8)).asPositiveBigInteger();
        List senderSignatures = ((RlpList)values.get(9)).getValues();
        List<SignatureData> signatureDataList = SignatureData.decodeSignatures(senderSignatures);
        SmartContractDeploy smartContractDeploy = ((Builder)((Builder)((Builder)((Builder)((Builder)new Builder().setNonce(nonce)).setGasPrice(gasPrice)).setGas(gas)).setTo(to).setValue(value).setFrom(from)).setInput(input).setHumanReadable(humanReadable).setCodeFormat(codeFormat).setSignatures(signatureDataList)).build();
        return smartContractDeploy;
    }

    @Override
    public String getRLPEncoding() {
        this.validateOptionalValues(false);
        ArrayList<RlpList> signatureRLPList = new ArrayList<RlpList>();
        for (SignatureData signatureData : this.getSignatures()) {
            signatureRLPList.add(signatureData.toRlpList());
        }
        ArrayList<Object> rlpTypeList = new ArrayList<Object>();
        rlpTypeList.add(RlpString.create((BigInteger)Numeric.toBigInt((String)this.getNonce())));
        rlpTypeList.add(RlpString.create((BigInteger)Numeric.toBigInt((String)this.getGasPrice())));
        rlpTypeList.add(RlpString.create((BigInteger)Numeric.toBigInt((String)this.getGas())));
        rlpTypeList.add(RlpString.create((byte[])Numeric.hexStringToByteArray((String)this.getTo())));
        rlpTypeList.add(RlpString.create((BigInteger)Numeric.toBigInt((String)this.getValue())));
        rlpTypeList.add(RlpString.create((byte[])Numeric.hexStringToByteArray((String)this.getFrom())));
        rlpTypeList.add(RlpString.create((byte[])Numeric.hexStringToByteArray((String)this.getInput())));
        rlpTypeList.add(RlpString.create((long)(this.getHumanReadable() ? 1L : 0L)));
        rlpTypeList.add(RlpString.create((BigInteger)Numeric.toBigInt((String)this.getCodeFormat())));
        rlpTypeList.add(new RlpList(signatureRLPList));
        byte[] encodedTransaction = RlpEncoder.encode((RlpType)new RlpList(rlpTypeList));
        byte[] type = new byte[]{(byte)TransactionType.TxTypeSmartContractDeploy.getType()};
        byte[] rawTx = BytesUtils.concat(type, encodedTransaction);
        return Numeric.toHexString((byte[])rawTx);
    }

    @Override
    public String getCommonRLPEncodingForSignature() {
        this.validateOptionalValues(true);
        byte type = (byte)TransactionType.TxTypeSmartContractDeploy.getType();
        ArrayList<RlpString> rlpTypeList = new ArrayList<RlpString>();
        rlpTypeList.add(RlpString.create((byte)type));
        rlpTypeList.add(RlpString.create((BigInteger)Numeric.toBigInt((String)this.getNonce())));
        rlpTypeList.add(RlpString.create((BigInteger)Numeric.toBigInt((String)this.getGasPrice())));
        rlpTypeList.add(RlpString.create((BigInteger)Numeric.toBigInt((String)this.getGas())));
        rlpTypeList.add(RlpString.create((byte[])Numeric.hexStringToByteArray((String)this.getTo())));
        rlpTypeList.add(RlpString.create((BigInteger)Numeric.toBigInt((String)this.getValue())));
        rlpTypeList.add(RlpString.create((byte[])Numeric.hexStringToByteArray((String)this.getFrom())));
        rlpTypeList.add(RlpString.create((byte[])Numeric.hexStringToByteArray((String)this.getInput())));
        rlpTypeList.add(RlpString.create((long)(this.getHumanReadable() ? 1L : 0L)));
        rlpTypeList.add(RlpString.create((BigInteger)Numeric.toBigInt((String)this.getCodeFormat())));
        byte[] encoded = RlpEncoder.encode((RlpType)new RlpList(rlpTypeList));
        String encodedStr = Numeric.toHexString((byte[])encoded);
        return encodedStr;
    }

    @Override
    public boolean compareTxField(AbstractTransaction obj, boolean checkSig) {
        if (!super.compareTxField(obj, checkSig)) {
            return false;
        }
        if (!(obj instanceof SmartContractDeploy)) {
            return false;
        }
        SmartContractDeploy txObj = (SmartContractDeploy)obj;
        if (!this.getTo().toLowerCase().equals(txObj.getTo().toLowerCase())) {
            return false;
        }
        if (!Numeric.toBigInt((String)this.getValue()).equals(Numeric.toBigInt((String)txObj.getValue()))) {
            return false;
        }
        if (!this.getInput().equals(txObj.getInput())) {
            return false;
        }
        if (this.getHumanReadable() != txObj.getHumanReadable()) {
            return false;
        }
        return this.getCodeFormat().equals(txObj.getCodeFormat());
    }

    public String getTo() {
        return this.to;
    }

    public String getValue() {
        return this.value;
    }

    public String getInput() {
        return this.input;
    }

    public boolean getHumanReadable() {
        return this.humanReadable;
    }

    public String getCodeFormat() {
        return this.codeFormat;
    }

    public void setTo(String to) {
        if (to == null || to.isEmpty()) {
            to = "0x";
        }
        if (!to.equals("0x")) {
            throw new IllegalArgumentException("'to' field must be nil('0x') : " + to);
        }
        this.to = "0x";
    }

    public void setValue(String value) {
        if (value == null) {
            throw new IllegalArgumentException("value is missing.");
        }
        if (!Utils.isNumber(value)) {
            throw new IllegalArgumentException("Invalid value : " + value);
        }
        this.value = value;
    }

    public void setValue(BigInteger value) {
        this.setValue(Numeric.toHexStringWithPrefix((BigInteger)value));
    }

    public void setInput(String input) {
        if (input == null) {
            throw new IllegalArgumentException("input is missing.");
        }
        if (!Utils.isHex(input)) {
            throw new IllegalArgumentException("Invalid input : " + input);
        }
        this.input = Numeric.prependHexPrefix((String)input);
    }

    public void setHumanReadable(boolean humanReadable) {
        if (humanReadable) {
            throw new IllegalArgumentException("HumanReadable attribute must set false");
        }
        this.humanReadable = false;
    }

    public void setCodeFormat(String codeFormat) {
        if (codeFormat == null) {
            throw new IllegalArgumentException("codeFormat is missing");
        }
        if (Numeric.toBigInt((String)codeFormat).compareTo(CodeFormat.EVM) != 0) {
            throw new IllegalArgumentException("CodeFormat attribute only support EVM(0)");
        }
        this.codeFormat = codeFormat;
    }

    public static class Builder
    extends AbstractTransaction.Builder<Builder> {
        String to = "0x";
        String value = "0x00";
        String input;
        boolean humanReadable = false;
        String codeFormat = Numeric.toHexStringWithPrefix((BigInteger)CodeFormat.EVM);

        public Builder() {
            super(TransactionType.TxTypeSmartContractDeploy.toString());
        }

        public Builder setTo(String to) {
            this.to = to;
            return this;
        }

        public Builder setValue(String value) {
            this.value = value;
            return this;
        }

        public Builder setValue(BigInteger value) {
            this.value = Numeric.toHexStringWithPrefix((BigInteger)value);
            return this;
        }

        public Builder setInput(String input) {
            this.input = input;
            return this;
        }

        public Builder setHumanReadable(boolean humanReadable) {
            this.humanReadable = humanReadable;
            return this;
        }

        public Builder setCodeFormat(String codeFormat) {
            this.codeFormat = codeFormat;
            return this;
        }

        public Builder setCodeFormat(BigInteger codeFormat) {
            this.codeFormat = Numeric.toHexStringWithPrefix((BigInteger)codeFormat);
            return this;
        }

        public SmartContractDeploy build() {
            return new SmartContractDeploy(this);
        }
    }
}

