/*
 * Decompiled with CFR 0.152.
 */
package com.klaytn.caver.transaction.type;

import com.klaytn.caver.rpc.Klay;
import com.klaytn.caver.transaction.AbstractFeeDelegatedWithRatioTransaction;
import com.klaytn.caver.transaction.type.TransactionType;
import com.klaytn.caver.utils.BytesUtils;
import com.klaytn.caver.utils.Utils;
import com.klaytn.caver.wallet.keyring.SignatureData;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.web3j.crypto.Hash;
import org.web3j.rlp.RlpDecoder;
import org.web3j.rlp.RlpEncoder;
import org.web3j.rlp.RlpList;
import org.web3j.rlp.RlpString;
import org.web3j.rlp.RlpType;
import org.web3j.utils.Numeric;

public class FeeDelegatedValueTransferMemoWithRatio
extends AbstractFeeDelegatedWithRatioTransaction {
    String to;
    String value;
    String input;

    public FeeDelegatedValueTransferMemoWithRatio(Builder builder) {
        super(builder);
        this.setTo(builder.to);
        this.setValue(builder.value);
        this.setInput(builder.input);
    }

    public FeeDelegatedValueTransferMemoWithRatio(Klay klaytnCall, String from, String nonce, String gas, String gasPrice, String chainId, List<SignatureData> signatures, String feePayer, List<SignatureData> feePayerSignatures, String feeRatio, String to, String value, String input) {
        super(klaytnCall, TransactionType.TxTypeFeeDelegatedValueTransferMemo.toString(), from, nonce, gas, gasPrice, chainId, signatures, feePayer, feePayerSignatures, feeRatio);
        this.setTo(to);
        this.setValue(value);
        this.setInput(input);
    }

    public static FeeDelegatedValueTransferMemoWithRatio decode(String rlpEncoded) {
        return FeeDelegatedValueTransferMemoWithRatio.decode(Numeric.hexStringToByteArray((String)rlpEncoded));
    }

    public static FeeDelegatedValueTransferMemoWithRatio decode(byte[] rlpEncoded) {
        if (rlpEncoded[0] != (byte)TransactionType.TxTypeFeeDelegatedValueTransferMemoWithRatio.getType()) {
            throw new IllegalArgumentException("Invalid RLP-encoded tag - " + TransactionType.TxTypeFeeDelegatedValueTransferMemoWithRatio.toString());
        }
        byte[] detachedType = Arrays.copyOfRange(rlpEncoded, 1, rlpEncoded.length);
        RlpList rlpList = RlpDecoder.decode((byte[])detachedType);
        List values = ((RlpList)rlpList.getValues().get(0)).getValues();
        BigInteger nonce = ((RlpString)values.get(0)).asPositiveBigInteger();
        BigInteger gasPrice = ((RlpString)values.get(1)).asPositiveBigInteger();
        BigInteger gas = ((RlpString)values.get(2)).asPositiveBigInteger();
        String to = ((RlpString)values.get(3)).asString();
        BigInteger value = ((RlpString)values.get(4)).asPositiveBigInteger();
        String from = ((RlpString)values.get(5)).asString();
        String input = ((RlpString)values.get(6)).asString();
        BigInteger feeRatio = ((RlpString)values.get(7)).asPositiveBigInteger();
        List senderSignatures = ((RlpList)values.get(8)).getValues();
        List<SignatureData> senderSignList = SignatureData.decodeSignatures(senderSignatures);
        String feePayer = ((RlpString)values.get(9)).asString();
        List feePayerSignatures = ((RlpList)values.get(10)).getValues();
        List<SignatureData> feePayerSignList = SignatureData.decodeSignatures(feePayerSignatures);
        FeeDelegatedValueTransferMemoWithRatio feeDelegatedValueTransferMemoWithRatio = ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)new Builder().setNonce(nonce)).setGasPrice(gasPrice)).setGas(gas)).setTo(to).setValue(value).setFrom(from)).setInput(input).setSignatures(senderSignList)).setFeeRatio(feeRatio)).setFeePayer(feePayer)).setFeePayerSignatures(feePayerSignList)).build();
        return feeDelegatedValueTransferMemoWithRatio;
    }

    @Override
    public String getRLPEncoding() {
        this.validateOptionalValues(false);
        ArrayList<RlpList> senderSignatureRLPList = new ArrayList<RlpList>();
        ArrayList<RlpList> feePayerSignatureRLPList = new ArrayList<RlpList>();
        for (SignatureData signatureData : this.getSignatures()) {
            senderSignatureRLPList.add(signatureData.toRlpList());
        }
        for (SignatureData signatureData : this.getFeePayerSignatures()) {
            feePayerSignatureRLPList.add(signatureData.toRlpList());
        }
        ArrayList<Object> rlpTypeList = new ArrayList<Object>();
        rlpTypeList.add(RlpString.create((BigInteger)Numeric.toBigInt((String)this.getNonce())));
        rlpTypeList.add(RlpString.create((BigInteger)Numeric.toBigInt((String)this.getGasPrice())));
        rlpTypeList.add(RlpString.create((BigInteger)Numeric.toBigInt((String)this.getGas())));
        rlpTypeList.add(RlpString.create((byte[])Numeric.hexStringToByteArray((String)this.getTo())));
        rlpTypeList.add(RlpString.create((BigInteger)Numeric.toBigInt((String)this.getValue())));
        rlpTypeList.add(RlpString.create((byte[])Numeric.hexStringToByteArray((String)this.getFrom())));
        rlpTypeList.add(RlpString.create((byte[])Numeric.hexStringToByteArray((String)this.getInput())));
        rlpTypeList.add(RlpString.create((BigInteger)Numeric.toBigInt((String)this.getFeeRatio())));
        rlpTypeList.add(new RlpList(senderSignatureRLPList));
        rlpTypeList.add(RlpString.create((byte[])Numeric.hexStringToByteArray((String)this.getFeePayer())));
        rlpTypeList.add(new RlpList(feePayerSignatureRLPList));
        byte[] encodedTransaction = RlpEncoder.encode((RlpType)new RlpList(rlpTypeList));
        byte[] type = new byte[]{(byte)TransactionType.TxTypeFeeDelegatedValueTransferMemoWithRatio.getType()};
        byte[] rawTx = BytesUtils.concat(type, encodedTransaction);
        return Numeric.toHexString((byte[])rawTx);
    }

    @Override
    public String getCommonRLPEncodingForSignature() {
        this.validateOptionalValues(true);
        byte type = (byte)TransactionType.TxTypeFeeDelegatedValueTransferMemoWithRatio.getType();
        ArrayList<RlpString> rlpTypeList = new ArrayList<RlpString>();
        rlpTypeList.add(RlpString.create((byte)type));
        rlpTypeList.add(RlpString.create((BigInteger)Numeric.toBigInt((String)this.getNonce())));
        rlpTypeList.add(RlpString.create((BigInteger)Numeric.toBigInt((String)this.getGasPrice())));
        rlpTypeList.add(RlpString.create((BigInteger)Numeric.toBigInt((String)this.getGas())));
        rlpTypeList.add(RlpString.create((byte[])Numeric.hexStringToByteArray((String)this.getTo())));
        rlpTypeList.add(RlpString.create((BigInteger)Numeric.toBigInt((String)this.getValue())));
        rlpTypeList.add(RlpString.create((byte[])Numeric.hexStringToByteArray((String)this.getFrom())));
        rlpTypeList.add(RlpString.create((byte[])Numeric.hexStringToByteArray((String)this.getInput())));
        rlpTypeList.add(RlpString.create((BigInteger)Numeric.toBigInt((String)this.getFeeRatio())));
        byte[] encoded = RlpEncoder.encode((RlpType)new RlpList(rlpTypeList));
        String encodedStr = Numeric.toHexString((byte[])encoded);
        return encodedStr;
    }

    @Override
    public String getSenderTxHash() {
        this.validateOptionalValues(false);
        ArrayList<RlpList> senderSignatureRLPList = new ArrayList<RlpList>();
        for (SignatureData signatureData : this.getSignatures()) {
            senderSignatureRLPList.add(signatureData.toRlpList());
        }
        ArrayList<Object> rlpTypeList = new ArrayList<Object>();
        rlpTypeList.add(RlpString.create((BigInteger)Numeric.toBigInt((String)this.getNonce())));
        rlpTypeList.add(RlpString.create((BigInteger)Numeric.toBigInt((String)this.getGasPrice())));
        rlpTypeList.add(RlpString.create((BigInteger)Numeric.toBigInt((String)this.getGas())));
        rlpTypeList.add(RlpString.create((byte[])Numeric.hexStringToByteArray((String)this.getTo())));
        rlpTypeList.add(RlpString.create((BigInteger)Numeric.toBigInt((String)this.getValue())));
        rlpTypeList.add(RlpString.create((byte[])Numeric.hexStringToByteArray((String)this.getFrom())));
        rlpTypeList.add(RlpString.create((byte[])Numeric.hexStringToByteArray((String)this.getInput())));
        rlpTypeList.add(RlpString.create((BigInteger)Numeric.toBigInt((String)this.getFeeRatio())));
        rlpTypeList.add(new RlpList(senderSignatureRLPList));
        byte[] encodedTransaction = RlpEncoder.encode((RlpType)new RlpList(rlpTypeList));
        byte[] type = new byte[]{(byte)TransactionType.TxTypeFeeDelegatedValueTransferMemoWithRatio.getType()};
        byte[] rawTx = BytesUtils.concat(type, encodedTransaction);
        return Numeric.toHexString((byte[])Hash.sha3((byte[])rawTx));
    }

    @Override
    public boolean compareTxField(AbstractFeeDelegatedWithRatioTransaction txObj, boolean checkSig) {
        if (!super.compareTxField(txObj, checkSig)) {
            return false;
        }
        if (!(txObj instanceof FeeDelegatedValueTransferMemoWithRatio)) {
            return false;
        }
        FeeDelegatedValueTransferMemoWithRatio feeDelegatedValueTransferMemoWithRatio = (FeeDelegatedValueTransferMemoWithRatio)txObj;
        if (!this.getTo().toLowerCase().equals(feeDelegatedValueTransferMemoWithRatio.getTo().toLowerCase())) {
            return false;
        }
        if (!Numeric.toBigInt((String)this.getValue()).equals(Numeric.toBigInt((String)feeDelegatedValueTransferMemoWithRatio.getValue()))) {
            return false;
        }
        return this.getInput().equals(feeDelegatedValueTransferMemoWithRatio.getInput());
    }

    public String getTo() {
        return this.to;
    }

    public String getValue() {
        return this.value;
    }

    public String getInput() {
        return this.input;
    }

    public void setTo(String to) {
        if (to == null) {
            throw new IllegalArgumentException("to is missing.");
        }
        if (!Utils.isAddress(to)) {
            throw new IllegalArgumentException("Invalid address. : " + to);
        }
        this.to = to;
    }

    public void setValue(String value) {
        if (value == null) {
            throw new IllegalArgumentException("value is missing.");
        }
        if (!Utils.isNumber(value)) {
            throw new IllegalArgumentException("Invalid value : " + value);
        }
        this.value = value;
    }

    public void setValue(BigInteger value) {
        this.setValue(Numeric.toHexStringWithPrefix((BigInteger)value));
    }

    public void setInput(String input) {
        if (input == null) {
            throw new IllegalArgumentException("input is missing.");
        }
        if (!Utils.isHex(input)) {
            throw new IllegalArgumentException("Invalid input : " + input);
        }
        this.input = Numeric.prependHexPrefix((String)input);
    }

    public static class Builder
    extends AbstractFeeDelegatedWithRatioTransaction.Builder<Builder> {
        String to;
        String value;
        String input;

        public Builder() {
            super(TransactionType.TxTypeFeeDelegatedValueTransferMemo.toString());
        }

        public Builder setTo(String to) {
            this.to = to;
            return this;
        }

        public Builder setValue(String value) {
            this.value = value;
            return this;
        }

        public Builder setValue(BigInteger value) {
            return this.setValue(Numeric.toHexStringWithPrefix((BigInteger)value));
        }

        public Builder setInput(String input) {
            this.input = input;
            return this;
        }

        public FeeDelegatedValueTransferMemoWithRatio build() {
            return new FeeDelegatedValueTransferMemoWithRatio(this);
        }
    }
}

