/*
 * Decompiled with CFR 0.152.
 */
package com.klaytn.caver.transaction.type;

import com.klaytn.caver.rpc.Klay;
import com.klaytn.caver.transaction.AbstractFeeDelegatedTransaction;
import com.klaytn.caver.transaction.type.TransactionType;
import com.klaytn.caver.utils.BytesUtils;
import com.klaytn.caver.utils.CodeFormat;
import com.klaytn.caver.utils.Utils;
import com.klaytn.caver.wallet.keyring.SignatureData;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.web3j.crypto.Hash;
import org.web3j.rlp.RlpDecoder;
import org.web3j.rlp.RlpEncoder;
import org.web3j.rlp.RlpList;
import org.web3j.rlp.RlpString;
import org.web3j.rlp.RlpType;
import org.web3j.utils.Numeric;

public class FeeDelegatedSmartContractDeploy
extends AbstractFeeDelegatedTransaction {
    String to = "0x";
    String value = "0x00";
    String input;
    boolean humanReadable = false;
    String codeFormat = Numeric.toHexStringWithPrefix((BigInteger)CodeFormat.EVM);

    public FeeDelegatedSmartContractDeploy(Builder builder) {
        super(builder);
        this.setTo(builder.to);
        this.setValue(builder.value);
        this.setInput(builder.input);
        this.setHumanReadable(builder.humanReadable);
        this.setCodeFormat(builder.codeFormat);
    }

    public FeeDelegatedSmartContractDeploy(Klay klaytnCall, String from, String nonce, String gas, String gasPrice, String chainId, List<SignatureData> signatures, String feePayer, List<SignatureData> feePayerSignatures, String to, String value, String input, boolean humanReadable, String codeFormat) {
        super(klaytnCall, TransactionType.TxTypeFeeDelegatedSmartContractDeploy.toString(), from, nonce, gas, gasPrice, chainId, signatures, feePayer, feePayerSignatures);
        this.setTo(to);
        this.setValue(value);
        this.setInput(input);
        this.setHumanReadable(humanReadable);
        this.setCodeFormat(codeFormat);
    }

    public static FeeDelegatedSmartContractDeploy decode(String rlpEncoded) {
        return FeeDelegatedSmartContractDeploy.decode(Numeric.hexStringToByteArray((String)rlpEncoded));
    }

    public static FeeDelegatedSmartContractDeploy decode(byte[] rlpEncoded) {
        if (rlpEncoded[0] != (byte)TransactionType.TxTypeFeeDelegatedSmartContractDeploy.getType()) {
            throw new IllegalArgumentException("Invalid RLP-encoded tag - " + TransactionType.TxTypeFeeDelegatedSmartContractDeploy.toString());
        }
        byte[] detachedType = Arrays.copyOfRange(rlpEncoded, 1, rlpEncoded.length);
        RlpList rlpList = RlpDecoder.decode((byte[])detachedType);
        List values = ((RlpList)rlpList.getValues().get(0)).getValues();
        BigInteger nonce = ((RlpString)values.get(0)).asPositiveBigInteger();
        BigInteger gasPrice = ((RlpString)values.get(1)).asPositiveBigInteger();
        BigInteger gas = ((RlpString)values.get(2)).asPositiveBigInteger();
        String to = ((RlpString)values.get(3)).asString();
        BigInteger value = ((RlpString)values.get(4)).asPositiveBigInteger();
        String from = ((RlpString)values.get(5)).asString();
        String input = ((RlpString)values.get(6)).asString();
        boolean humanReadable = ((RlpString)values.get(7)).asPositiveBigInteger().compareTo(BigInteger.ZERO) != 0;
        BigInteger codeFormat = ((RlpString)values.get(8)).asPositiveBigInteger();
        List senderSignatures = ((RlpList)values.get(9)).getValues();
        List<SignatureData> senderSignList = SignatureData.decodeSignatures(senderSignatures);
        String feePayer = ((RlpString)values.get(10)).asString();
        List feePayerSignatures = ((RlpList)values.get(11)).getValues();
        List<SignatureData> feePayerSignList = SignatureData.decodeSignatures(feePayerSignatures);
        FeeDelegatedSmartContractDeploy feeDelegatedSmartContractDeploy = ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)new Builder().setNonce(nonce)).setGasPrice(gasPrice)).setGas(gas)).setTo(to).setValue(value).setFrom(from)).setInput(input).setHumanReadable(humanReadable).setCodeFormat(codeFormat).setSignatures(senderSignList)).setFeePayer(feePayer)).setFeePayerSignatures(feePayerSignList)).build();
        return feeDelegatedSmartContractDeploy;
    }

    @Override
    public String getRLPEncoding() {
        this.validateOptionalValues(false);
        ArrayList<RlpList> senderSignatureRLPList = new ArrayList<RlpList>();
        ArrayList<RlpList> feePayerSignatureRLPList = new ArrayList<RlpList>();
        for (SignatureData signatureData : this.getSignatures()) {
            senderSignatureRLPList.add(signatureData.toRlpList());
        }
        for (SignatureData signatureData : this.getFeePayerSignatures()) {
            feePayerSignatureRLPList.add(signatureData.toRlpList());
        }
        ArrayList<Object> rlpTypeList = new ArrayList<Object>();
        rlpTypeList.add(RlpString.create((BigInteger)Numeric.toBigInt((String)this.getNonce())));
        rlpTypeList.add(RlpString.create((BigInteger)Numeric.toBigInt((String)this.getGasPrice())));
        rlpTypeList.add(RlpString.create((BigInteger)Numeric.toBigInt((String)this.getGas())));
        rlpTypeList.add(RlpString.create((byte[])Numeric.hexStringToByteArray((String)this.getTo())));
        rlpTypeList.add(RlpString.create((BigInteger)Numeric.toBigInt((String)this.getValue())));
        rlpTypeList.add(RlpString.create((byte[])Numeric.hexStringToByteArray((String)this.getFrom())));
        rlpTypeList.add(RlpString.create((byte[])Numeric.hexStringToByteArray((String)this.getInput())));
        rlpTypeList.add(RlpString.create((long)(this.getHumanReadable() ? 1L : 0L)));
        rlpTypeList.add(RlpString.create((BigInteger)Numeric.toBigInt((String)this.getCodeFormat())));
        rlpTypeList.add(new RlpList(senderSignatureRLPList));
        rlpTypeList.add(RlpString.create((byte[])Numeric.hexStringToByteArray((String)this.getFeePayer())));
        rlpTypeList.add(new RlpList(feePayerSignatureRLPList));
        byte[] encodedTransaction = RlpEncoder.encode((RlpType)new RlpList(rlpTypeList));
        byte[] type = new byte[]{(byte)TransactionType.TxTypeFeeDelegatedSmartContractDeploy.getType()};
        byte[] rawTx = BytesUtils.concat(type, encodedTransaction);
        return Numeric.toHexString((byte[])rawTx);
    }

    @Override
    public String getCommonRLPEncodingForSignature() {
        this.validateOptionalValues(true);
        byte type = (byte)TransactionType.TxTypeFeeDelegatedSmartContractDeploy.getType();
        ArrayList<RlpString> rlpTypeList = new ArrayList<RlpString>();
        rlpTypeList.add(RlpString.create((byte)type));
        rlpTypeList.add(RlpString.create((BigInteger)Numeric.toBigInt((String)this.getNonce())));
        rlpTypeList.add(RlpString.create((BigInteger)Numeric.toBigInt((String)this.getGasPrice())));
        rlpTypeList.add(RlpString.create((BigInteger)Numeric.toBigInt((String)this.getGas())));
        rlpTypeList.add(RlpString.create((byte[])Numeric.hexStringToByteArray((String)this.getTo())));
        rlpTypeList.add(RlpString.create((BigInteger)Numeric.toBigInt((String)this.getValue())));
        rlpTypeList.add(RlpString.create((byte[])Numeric.hexStringToByteArray((String)this.getFrom())));
        rlpTypeList.add(RlpString.create((byte[])Numeric.hexStringToByteArray((String)this.getInput())));
        rlpTypeList.add(RlpString.create((long)(this.getHumanReadable() ? 1L : 0L)));
        rlpTypeList.add(RlpString.create((BigInteger)Numeric.toBigInt((String)this.getCodeFormat())));
        byte[] encoded = RlpEncoder.encode((RlpType)new RlpList(rlpTypeList));
        String encodedStr = Numeric.toHexString((byte[])encoded);
        return encodedStr;
    }

    @Override
    public String getSenderTxHash() {
        this.validateOptionalValues(false);
        ArrayList<RlpList> senderSignatureRLPList = new ArrayList<RlpList>();
        for (SignatureData signatureData : this.getSignatures()) {
            senderSignatureRLPList.add(signatureData.toRlpList());
        }
        ArrayList<Object> rlpTypeList = new ArrayList<Object>();
        rlpTypeList.add(RlpString.create((BigInteger)Numeric.toBigInt((String)this.getNonce())));
        rlpTypeList.add(RlpString.create((BigInteger)Numeric.toBigInt((String)this.getGasPrice())));
        rlpTypeList.add(RlpString.create((BigInteger)Numeric.toBigInt((String)this.getGas())));
        rlpTypeList.add(RlpString.create((byte[])Numeric.hexStringToByteArray((String)this.getTo())));
        rlpTypeList.add(RlpString.create((BigInteger)Numeric.toBigInt((String)this.getValue())));
        rlpTypeList.add(RlpString.create((byte[])Numeric.hexStringToByteArray((String)this.getFrom())));
        rlpTypeList.add(RlpString.create((byte[])Numeric.hexStringToByteArray((String)this.getInput())));
        rlpTypeList.add(RlpString.create((long)(this.getHumanReadable() ? 1L : 0L)));
        rlpTypeList.add(RlpString.create((BigInteger)Numeric.toBigInt((String)this.getCodeFormat())));
        rlpTypeList.add(new RlpList(senderSignatureRLPList));
        byte[] encodedTransaction = RlpEncoder.encode((RlpType)new RlpList(rlpTypeList));
        byte[] type = new byte[]{(byte)TransactionType.TxTypeFeeDelegatedSmartContractDeploy.getType()};
        byte[] rawTx = BytesUtils.concat(type, encodedTransaction);
        return Numeric.toHexString((byte[])Hash.sha3((byte[])rawTx));
    }

    @Override
    public boolean compareTxField(AbstractFeeDelegatedTransaction txObj, boolean checkSig) {
        if (!super.compareTxField(txObj, checkSig)) {
            return false;
        }
        if (!(txObj instanceof FeeDelegatedSmartContractDeploy)) {
            return false;
        }
        FeeDelegatedSmartContractDeploy feeDelegatedSmartContractDeploy = (FeeDelegatedSmartContractDeploy)txObj;
        if (!this.getTo().toLowerCase().equals(feeDelegatedSmartContractDeploy.getTo().toLowerCase())) {
            return false;
        }
        if (!Numeric.toBigInt((String)this.getValue()).equals(Numeric.toBigInt((String)feeDelegatedSmartContractDeploy.getValue()))) {
            return false;
        }
        if (!this.getInput().equals(feeDelegatedSmartContractDeploy.getInput())) {
            return false;
        }
        if (this.getHumanReadable() != feeDelegatedSmartContractDeploy.getHumanReadable()) {
            return false;
        }
        return this.getCodeFormat().equals(feeDelegatedSmartContractDeploy.getCodeFormat());
    }

    public String getTo() {
        return this.to;
    }

    public String getValue() {
        return this.value;
    }

    public String getInput() {
        return this.input;
    }

    public boolean getHumanReadable() {
        return this.humanReadable;
    }

    public String getCodeFormat() {
        return this.codeFormat;
    }

    public void setTo(String to) {
        if (to == null || to.isEmpty()) {
            to = "0x";
        }
        if (!to.equals("0x")) {
            throw new IllegalArgumentException("'to' field must be nil('0x') : " + to);
        }
        this.to = "0x";
    }

    public void setValue(String value) {
        if (value == null) {
            throw new IllegalArgumentException("value is missing.");
        }
        if (!Utils.isNumber(value)) {
            throw new IllegalArgumentException("Invalid value : " + value);
        }
        this.value = value;
    }

    public void setValue(BigInteger value) {
        this.setValue(Numeric.toHexStringWithPrefix((BigInteger)value));
    }

    public void setInput(String input) {
        if (input == null) {
            throw new IllegalArgumentException("input is missing.");
        }
        if (!Utils.isHex(input)) {
            throw new IllegalArgumentException("Invalid input : " + input);
        }
        this.input = Numeric.prependHexPrefix((String)input);
    }

    public void setHumanReadable(boolean humanReadable) {
        if (humanReadable) {
            throw new IllegalArgumentException("HumanReadable attribute must set false");
        }
        this.humanReadable = false;
    }

    public void setCodeFormat(String codeFormat) {
        if (codeFormat == null) {
            throw new IllegalArgumentException("codeFormat is missing");
        }
        if (Numeric.toBigInt((String)codeFormat).compareTo(CodeFormat.EVM) != 0) {
            throw new IllegalArgumentException("CodeFormat attribute only support EVM(0)");
        }
        this.codeFormat = codeFormat;
    }

    public static class Builder
    extends AbstractFeeDelegatedTransaction.Builder<Builder> {
        String to = "0x";
        String value = "0x00";
        String input;
        boolean humanReadable = false;
        String codeFormat = Numeric.toHexStringWithPrefix((BigInteger)CodeFormat.EVM);

        public Builder() {
            super(TransactionType.TxTypeSmartContractDeploy.toString());
        }

        public Builder setTo(String to) {
            this.to = to;
            return this;
        }

        public Builder setValue(String value) {
            this.value = value;
            return this;
        }

        public Builder setValue(BigInteger value) {
            this.value = Numeric.toHexStringWithPrefix((BigInteger)value);
            return this;
        }

        public Builder setInput(String input) {
            this.input = input;
            return this;
        }

        public Builder setHumanReadable(boolean humanReadable) {
            this.humanReadable = humanReadable;
            return this;
        }

        public Builder setCodeFormat(String codeFormat) {
            this.codeFormat = codeFormat;
            return this;
        }

        public Builder setCodeFormat(BigInteger codeFormat) {
            this.codeFormat = Numeric.toHexStringWithPrefix((BigInteger)codeFormat);
            return this;
        }

        public FeeDelegatedSmartContractDeploy build() {
            return new FeeDelegatedSmartContractDeploy(this);
        }
    }
}

