/*
 * Decompiled with CFR 0.152.
 */
package com.klaytn.caver.transaction.type;

import com.klaytn.caver.rpc.Klay;
import com.klaytn.caver.transaction.AbstractFeeDelegatedWithRatioTransaction;
import com.klaytn.caver.transaction.type.TransactionType;
import com.klaytn.caver.utils.BytesUtils;
import com.klaytn.caver.utils.Utils;
import com.klaytn.caver.wallet.keyring.SignatureData;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.web3j.crypto.Hash;
import org.web3j.rlp.RlpDecoder;
import org.web3j.rlp.RlpEncoder;
import org.web3j.rlp.RlpList;
import org.web3j.rlp.RlpString;
import org.web3j.rlp.RlpType;
import org.web3j.utils.Numeric;

public class FeeDelegatedChainDataAnchoringWithRatio
extends AbstractFeeDelegatedWithRatioTransaction {
    String input;

    public FeeDelegatedChainDataAnchoringWithRatio(Builder builder) {
        super(builder);
        this.setInput(builder.input);
    }

    public FeeDelegatedChainDataAnchoringWithRatio(Klay klaytnCall, String from, String nonce, String gas, String gasPrice, String chainId, List<SignatureData> signatures, String feePayer, List<SignatureData> feePayerSignatures, String feeRatio, String input) {
        super(klaytnCall, TransactionType.TxTypeFeeDelegatedChainDataAnchoringWithRatio.toString(), from, nonce, gas, gasPrice, chainId, signatures, feePayer, feePayerSignatures, feeRatio);
        this.setInput(input);
    }

    public static FeeDelegatedChainDataAnchoringWithRatio decode(String rlpEncoded) {
        return FeeDelegatedChainDataAnchoringWithRatio.decode(Numeric.hexStringToByteArray((String)rlpEncoded));
    }

    public static FeeDelegatedChainDataAnchoringWithRatio decode(byte[] rlpEncoded) {
        if (rlpEncoded[0] != (byte)TransactionType.TxTypeFeeDelegatedChainDataAnchoringWithRatio.getType()) {
            throw new IllegalArgumentException("Invalid RLP-encoded tag - " + TransactionType.TxTypeFeeDelegatedChainDataAnchoringWithRatio.toString());
        }
        byte[] detachedType = Arrays.copyOfRange(rlpEncoded, 1, rlpEncoded.length);
        RlpList rlpList = RlpDecoder.decode((byte[])detachedType);
        List values = ((RlpList)rlpList.getValues().get(0)).getValues();
        BigInteger nonce = ((RlpString)values.get(0)).asPositiveBigInteger();
        BigInteger gasPrice = ((RlpString)values.get(1)).asPositiveBigInteger();
        BigInteger gas = ((RlpString)values.get(2)).asPositiveBigInteger();
        String from = ((RlpString)values.get(3)).asString();
        String input = ((RlpString)values.get(4)).asString();
        BigInteger feeRatio = ((RlpString)values.get(5)).asPositiveBigInteger();
        List senderSignatures = ((RlpList)values.get(6)).getValues();
        List<SignatureData> senderSignList = SignatureData.decodeSignatures(senderSignatures);
        String feePayer = ((RlpString)values.get(7)).asString();
        List feePayerSignatures = ((RlpList)values.get(8)).getValues();
        List<SignatureData> feePayerSignList = SignatureData.decodeSignatures(feePayerSignatures);
        FeeDelegatedChainDataAnchoringWithRatio feeDelegatedChainDataAnchoringWithRatio = ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)new Builder().setNonce(nonce)).setGasPrice(gasPrice)).setGas(gas)).setFrom(from)).setInput(input).setSignatures(senderSignList)).setFeePayer(feePayer)).setFeeRatio(feeRatio)).setFeePayerSignatures(feePayerSignList)).build();
        return feeDelegatedChainDataAnchoringWithRatio;
    }

    @Override
    public String getRLPEncoding() {
        this.validateOptionalValues(false);
        ArrayList<RlpList> senderSignatureRLPList = new ArrayList<RlpList>();
        ArrayList<RlpList> feePayerSignatureRLPList = new ArrayList<RlpList>();
        for (SignatureData signatureData : this.getSignatures()) {
            senderSignatureRLPList.add(signatureData.toRlpList());
        }
        for (SignatureData signatureData : this.getFeePayerSignatures()) {
            feePayerSignatureRLPList.add(signatureData.toRlpList());
        }
        ArrayList<Object> rlpTypeList = new ArrayList<Object>();
        rlpTypeList.add(RlpString.create((BigInteger)Numeric.toBigInt((String)this.getNonce())));
        rlpTypeList.add(RlpString.create((BigInteger)Numeric.toBigInt((String)this.getGasPrice())));
        rlpTypeList.add(RlpString.create((BigInteger)Numeric.toBigInt((String)this.getGas())));
        rlpTypeList.add(RlpString.create((byte[])Numeric.hexStringToByteArray((String)this.getFrom())));
        rlpTypeList.add(RlpString.create((byte[])Numeric.hexStringToByteArray((String)this.getInput())));
        rlpTypeList.add(RlpString.create((BigInteger)Numeric.toBigInt((String)this.getFeeRatio())));
        rlpTypeList.add(new RlpList(senderSignatureRLPList));
        rlpTypeList.add(RlpString.create((byte[])Numeric.hexStringToByteArray((String)this.getFeePayer())));
        rlpTypeList.add(new RlpList(feePayerSignatureRLPList));
        byte[] encodedTransaction = RlpEncoder.encode((RlpType)new RlpList(rlpTypeList));
        byte[] type = new byte[]{(byte)TransactionType.TxTypeFeeDelegatedChainDataAnchoringWithRatio.getType()};
        byte[] rawTx = BytesUtils.concat(type, encodedTransaction);
        return Numeric.toHexString((byte[])rawTx);
    }

    @Override
    public String getCommonRLPEncodingForSignature() {
        this.validateOptionalValues(true);
        byte type = (byte)TransactionType.TxTypeFeeDelegatedChainDataAnchoringWithRatio.getType();
        ArrayList<RlpString> rlpTypeList = new ArrayList<RlpString>();
        rlpTypeList.add(RlpString.create((byte)type));
        rlpTypeList.add(RlpString.create((BigInteger)Numeric.toBigInt((String)this.getNonce())));
        rlpTypeList.add(RlpString.create((BigInteger)Numeric.toBigInt((String)this.getGasPrice())));
        rlpTypeList.add(RlpString.create((BigInteger)Numeric.toBigInt((String)this.getGas())));
        rlpTypeList.add(RlpString.create((byte[])Numeric.hexStringToByteArray((String)this.getFrom())));
        rlpTypeList.add(RlpString.create((byte[])Numeric.hexStringToByteArray((String)this.getInput())));
        rlpTypeList.add(RlpString.create((BigInteger)Numeric.toBigInt((String)this.getFeeRatio())));
        byte[] encoded = RlpEncoder.encode((RlpType)new RlpList(rlpTypeList));
        String encodedStr = Numeric.toHexString((byte[])encoded);
        return encodedStr;
    }

    @Override
    public String getSenderTxHash() {
        this.validateOptionalValues(false);
        ArrayList<RlpList> senderSignatureRLPList = new ArrayList<RlpList>();
        for (SignatureData signatureData : this.getSignatures()) {
            senderSignatureRLPList.add(signatureData.toRlpList());
        }
        ArrayList<Object> rlpTypeList = new ArrayList<Object>();
        rlpTypeList.add(RlpString.create((BigInteger)Numeric.toBigInt((String)this.getNonce())));
        rlpTypeList.add(RlpString.create((BigInteger)Numeric.toBigInt((String)this.getGasPrice())));
        rlpTypeList.add(RlpString.create((BigInteger)Numeric.toBigInt((String)this.getGas())));
        rlpTypeList.add(RlpString.create((byte[])Numeric.hexStringToByteArray((String)this.getFrom())));
        rlpTypeList.add(RlpString.create((byte[])Numeric.hexStringToByteArray((String)this.getInput())));
        rlpTypeList.add(RlpString.create((BigInteger)Numeric.toBigInt((String)this.getFeeRatio())));
        rlpTypeList.add(new RlpList(senderSignatureRLPList));
        byte[] encodedTransaction = RlpEncoder.encode((RlpType)new RlpList(rlpTypeList));
        byte[] type = new byte[]{(byte)TransactionType.TxTypeFeeDelegatedChainDataAnchoringWithRatio.getType()};
        byte[] rawTx = BytesUtils.concat(type, encodedTransaction);
        return Numeric.toHexString((byte[])Hash.sha3((byte[])rawTx));
    }

    @Override
    public boolean compareTxField(AbstractFeeDelegatedWithRatioTransaction txObj, boolean checkSig) {
        if (!super.compareTxField(txObj, checkSig)) {
            return false;
        }
        if (!(txObj instanceof FeeDelegatedChainDataAnchoringWithRatio)) {
            return false;
        }
        FeeDelegatedChainDataAnchoringWithRatio feeDelegatedChainDataAnchoringWithRatio = (FeeDelegatedChainDataAnchoringWithRatio)txObj;
        return this.getInput().equals(feeDelegatedChainDataAnchoringWithRatio.getInput());
    }

    public String getInput() {
        return this.input;
    }

    public void setInput(String input) {
        if (input == null) {
            throw new IllegalArgumentException("input is missing.");
        }
        if (!Utils.isHex(input)) {
            throw new IllegalArgumentException("Invalid input : " + input);
        }
        this.input = Numeric.prependHexPrefix((String)input);
    }

    public static class Builder
    extends AbstractFeeDelegatedWithRatioTransaction.Builder<Builder> {
        String input;

        public Builder() {
            super(TransactionType.TxTypeFeeDelegatedChainDataAnchoringWithRatio.toString());
        }

        public Builder setInput(String input) {
            this.input = input;
            return this;
        }

        public FeeDelegatedChainDataAnchoringWithRatio build() {
            return new FeeDelegatedChainDataAnchoringWithRatio(this);
        }
    }
}

