/*
 * Decompiled with CFR 0.152.
 */
package com.klaytn.caver.transaction.type;

import com.klaytn.caver.rpc.Klay;
import com.klaytn.caver.transaction.AbstractTransaction;
import com.klaytn.caver.transaction.type.TransactionType;
import com.klaytn.caver.utils.BytesUtils;
import com.klaytn.caver.utils.Utils;
import com.klaytn.caver.wallet.keyring.SignatureData;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.web3j.rlp.RlpDecoder;
import org.web3j.rlp.RlpEncoder;
import org.web3j.rlp.RlpList;
import org.web3j.rlp.RlpString;
import org.web3j.rlp.RlpType;
import org.web3j.utils.Numeric;

public class ChainDataAnchoring
extends AbstractTransaction {
    String input;

    public ChainDataAnchoring(Builder builder) {
        super(builder);
        this.setInput(builder.input);
    }

    public ChainDataAnchoring(Klay klaytnCall, String from, String nonce, String gas, String gasPrice, String chainId, List<SignatureData> signatures, String input) {
        super(klaytnCall, TransactionType.TxTypeChainDataAnchoring.toString(), from, nonce, gas, gasPrice, chainId, signatures);
        this.setInput(input);
    }

    public static ChainDataAnchoring decode(String rlpEncoded) {
        return ChainDataAnchoring.decode(Numeric.hexStringToByteArray((String)rlpEncoded));
    }

    public static ChainDataAnchoring decode(byte[] rlpEncoded) {
        if (rlpEncoded[0] != (byte)TransactionType.TxTypeChainDataAnchoring.getType()) {
            throw new IllegalArgumentException("Invalid RLP-encoded tag - " + TransactionType.TxTypeChainDataAnchoring.toString());
        }
        byte[] detachedType = Arrays.copyOfRange(rlpEncoded, 1, rlpEncoded.length);
        RlpList rlpList = RlpDecoder.decode((byte[])detachedType);
        List values = ((RlpList)rlpList.getValues().get(0)).getValues();
        BigInteger nonce = ((RlpString)values.get(0)).asPositiveBigInteger();
        BigInteger gasPrice = ((RlpString)values.get(1)).asPositiveBigInteger();
        BigInteger gas = ((RlpString)values.get(2)).asPositiveBigInteger();
        String from = ((RlpString)values.get(3)).asString();
        String input = ((RlpString)values.get(4)).asString();
        List senderSignatures = ((RlpList)values.get(5)).getValues();
        List<SignatureData> signatureDataList = SignatureData.decodeSignatures(senderSignatures);
        ChainDataAnchoring chainDataAnchoring = ((Builder)((Builder)((Builder)((Builder)((Builder)new Builder().setNonce(nonce)).setGasPrice(gasPrice)).setGas(gas)).setFrom(from)).setInput(input).setSignatures(signatureDataList)).build();
        return chainDataAnchoring;
    }

    @Override
    public String getRLPEncoding() {
        this.validateOptionalValues(false);
        ArrayList<RlpList> signatureRLPList = new ArrayList<RlpList>();
        for (SignatureData signatureData : this.getSignatures()) {
            signatureRLPList.add(signatureData.toRlpList());
        }
        ArrayList<Object> rlpTypeList = new ArrayList<Object>();
        rlpTypeList.add(RlpString.create((BigInteger)Numeric.toBigInt((String)this.getNonce())));
        rlpTypeList.add(RlpString.create((BigInteger)Numeric.toBigInt((String)this.getGasPrice())));
        rlpTypeList.add(RlpString.create((BigInteger)Numeric.toBigInt((String)this.getGas())));
        rlpTypeList.add(RlpString.create((byte[])Numeric.hexStringToByteArray((String)this.getFrom())));
        rlpTypeList.add(RlpString.create((byte[])Numeric.hexStringToByteArray((String)this.getInput())));
        rlpTypeList.add(new RlpList(signatureRLPList));
        byte[] encodedTransaction = RlpEncoder.encode((RlpType)new RlpList(rlpTypeList));
        byte[] type = new byte[]{(byte)TransactionType.TxTypeChainDataAnchoring.getType()};
        byte[] rawTx = BytesUtils.concat(type, encodedTransaction);
        return Numeric.toHexString((byte[])rawTx);
    }

    @Override
    public String getCommonRLPEncodingForSignature() {
        this.validateOptionalValues(true);
        byte type = (byte)TransactionType.TxTypeChainDataAnchoring.getType();
        ArrayList<RlpString> rlpTypeList = new ArrayList<RlpString>();
        rlpTypeList.add(RlpString.create((byte)type));
        rlpTypeList.add(RlpString.create((BigInteger)Numeric.toBigInt((String)this.getNonce())));
        rlpTypeList.add(RlpString.create((BigInteger)Numeric.toBigInt((String)this.getGasPrice())));
        rlpTypeList.add(RlpString.create((BigInteger)Numeric.toBigInt((String)this.getGas())));
        rlpTypeList.add(RlpString.create((byte[])Numeric.hexStringToByteArray((String)this.getFrom())));
        rlpTypeList.add(RlpString.create((byte[])Numeric.hexStringToByteArray((String)this.getInput())));
        byte[] encoded = RlpEncoder.encode((RlpType)new RlpList(rlpTypeList));
        String encodedStr = Numeric.toHexString((byte[])encoded);
        return encodedStr;
    }

    @Override
    public boolean compareTxField(AbstractTransaction obj, boolean checkSig) {
        if (!super.compareTxField(obj, checkSig)) {
            return false;
        }
        if (!(obj instanceof ChainDataAnchoring)) {
            return false;
        }
        ChainDataAnchoring txObj = (ChainDataAnchoring)obj;
        return this.getInput().equals(txObj.getInput());
    }

    public String getInput() {
        return this.input;
    }

    public void setInput(String input) {
        if (input == null) {
            throw new IllegalArgumentException("input is missing.");
        }
        if (!Utils.isHex(input)) {
            throw new IllegalArgumentException("Invalid input : " + input);
        }
        this.input = Numeric.prependHexPrefix((String)input);
    }

    public static class Builder
    extends AbstractTransaction.Builder<Builder> {
        String input;

        public Builder() {
            super(TransactionType.TxTypeChainDataAnchoring.toString());
        }

        public Builder setInput(String input) {
            this.input = input;
            return this;
        }

        public ChainDataAnchoring build() {
            return new ChainDataAnchoring(this);
        }
    }
}

