/*
 * Decompiled with CFR 0.152.
 */
package com.klaytn.caver.transaction.response;

import com.klaytn.caver.Caver;
import com.klaytn.caver.methods.response.Callback;
import com.klaytn.caver.methods.response.TransactionReceipt;
import com.klaytn.caver.transaction.response.TransactionReceiptProcessor;
import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.web3j.protocol.exceptions.TransactionException;
import org.web3j.utils.Async;

public class QueuingTransactionReceiptProcessor
extends TransactionReceiptProcessor {
    public static final int DEFAULT_POLLING_ATTEMPTS_PER_TX_HASH = 15;
    public static final long DEFAULT_POLLING_FREQUENCY = 1000L;
    private final int pollingAttemptsPerTxHash;
    private final ScheduledExecutorService scheduledExecutorService = Async.defaultExecutorService();
    private final Callback<TransactionReceipt.TransactionReceiptData> callback;
    private final BlockingQueue<RequestWrapper> pendingTransactions;

    public QueuingTransactionReceiptProcessor(Caver caver, Callback callback, int pollingAttemptsPerTxHash, long pollingFrequency) {
        super(caver);
        this.callback = callback;
        this.pendingTransactions = new LinkedBlockingQueue<RequestWrapper>();
        this.pollingAttemptsPerTxHash = pollingAttemptsPerTxHash;
        this.scheduledExecutorService.scheduleAtFixedRate(this::sendTransactionReceiptRequests, pollingFrequency, pollingFrequency, TimeUnit.MILLISECONDS);
    }

    public QueuingTransactionReceiptProcessor(Caver caver, Callback callback) {
        this(caver, callback, 15, 1000L);
    }

    @Override
    public TransactionReceipt.TransactionReceiptData waitForTransactionReceipt(String transactionHash) throws IOException, TransactionException {
        this.pendingTransactions.add(new RequestWrapper(transactionHash));
        TransactionReceipt.TransactionReceiptData transactionReceiptData = new TransactionReceipt.TransactionReceiptData();
        transactionReceiptData.setTransactionHash(transactionHash);
        return transactionReceiptData;
    }

    private void sendTransactionReceiptRequests() {
        for (RequestWrapper requestWrapper : this.pendingTransactions) {
            try {
                String transactionHash = requestWrapper.getTransactionHash();
                Optional<TransactionReceipt.TransactionReceiptData> transactionReceipt = this.sendTransactionReceiptRequest(transactionHash);
                if (transactionReceipt.isPresent()) {
                    this.callback.accept(transactionReceipt.get());
                    this.pendingTransactions.remove(requestWrapper);
                    continue;
                }
                if (requestWrapper.getCount() == this.pollingAttemptsPerTxHash) {
                    throw new TransactionException("No transaction receipt for txHash: " + transactionHash + "received after " + this.pollingAttemptsPerTxHash + " attempts", transactionHash);
                }
                requestWrapper.incrementCount();
            }
            catch (IOException | TransactionException e) {
                this.pendingTransactions.remove(requestWrapper);
                this.callback.exception((Exception)e);
            }
        }
    }

    private static class RequestWrapper {
        private final String transactionHash;
        private int count;

        RequestWrapper(String transactionHash) {
            this.transactionHash = transactionHash;
            this.count = 0;
        }

        String getTransactionHash() {
            return this.transactionHash;
        }

        int getCount() {
            return this.count;
        }

        void incrementCount() {
            ++this.count;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RequestWrapper that = (RequestWrapper)o;
            return this.transactionHash.equals(that.transactionHash);
        }

        public int hashCode() {
            return this.transactionHash.hashCode();
        }
    }
}

