/*
 * Decompiled with CFR 0.152.
 */
package com.klaytn.caver.transaction.response;

import com.klaytn.caver.Caver;
import com.klaytn.caver.methods.response.TransactionReceipt;
import com.klaytn.caver.transaction.response.TransactionReceiptProcessor;
import java.io.IOException;
import java.util.Optional;
import org.web3j.protocol.exceptions.TransactionException;

public class PollingTransactionReceiptProcessor
extends TransactionReceiptProcessor {
    private final long sleepDuration;
    private final int attempts;

    public PollingTransactionReceiptProcessor(Caver caver, long sleepDuration, int attempts) {
        super(caver);
        this.sleepDuration = sleepDuration;
        this.attempts = attempts;
    }

    @Override
    public TransactionReceipt.TransactionReceiptData waitForTransactionReceipt(String transactionHash) throws IOException, TransactionException {
        return this.getTransactionReceipt(transactionHash, this.sleepDuration, this.attempts);
    }

    private TransactionReceipt.TransactionReceiptData getTransactionReceipt(String transactionHash, long sleepDuration, int attempts) throws IOException, TransactionException {
        Optional<TransactionReceipt.TransactionReceiptData> receiptOptional = this.sendTransactionReceiptRequest(transactionHash);
        for (int i = 0; i < attempts; ++i) {
            if (!receiptOptional.isPresent()) {
                try {
                    Thread.sleep(sleepDuration);
                }
                catch (InterruptedException e) {
                    throw new TransactionException((Throwable)e);
                }
            } else {
                return receiptOptional.get();
            }
            receiptOptional = this.sendTransactionReceiptRequest(transactionHash);
        }
        throw new TransactionException("Transaction receipt was not generated after " + sleepDuration * (long)attempts / 1000L + " seconds for transaction: " + transactionHash, transactionHash);
    }
}

