/*
 * Decompiled with CFR 0.152.
 */
package com.klaytn.caver.transaction;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.klaytn.caver.rpc.Klay;
import com.klaytn.caver.transaction.AbstractFeeDelegatedTransaction;
import com.klaytn.caver.utils.Utils;
import com.klaytn.caver.wallet.keyring.SignatureData;
import java.math.BigInteger;
import java.util.List;
import org.web3j.utils.Numeric;

public abstract class AbstractFeeDelegatedWithRatioTransaction
extends AbstractFeeDelegatedTransaction {
    String feeRatio;

    public AbstractFeeDelegatedWithRatioTransaction(Builder builder) {
        super(builder);
        this.setFeeRatio(builder.feeRatio);
    }

    public AbstractFeeDelegatedWithRatioTransaction(Klay klaytnCall, String type, String from, String nonce, String gas, String gasPrice, String chainId, List<SignatureData> signatures, String feePayer, List<SignatureData> feePayerSignatures, String feeRatio) {
        super(klaytnCall, type, from, nonce, gas, gasPrice, chainId, signatures, feePayer, feePayerSignatures);
        this.setFeeRatio(feeRatio);
    }

    public boolean compareTxField(AbstractFeeDelegatedWithRatioTransaction txObj, boolean checkSig) {
        if (!super.compareTxField(txObj, checkSig)) {
            return false;
        }
        return Numeric.toBigInt((String)this.getFeeRatio()).equals(Numeric.toBigInt((String)txObj.getFeeRatio()));
    }

    @JsonIgnore
    public String getFeeRatio() {
        return this.feeRatio;
    }

    @JsonProperty(value="feeRatio")
    public BigInteger getFeeRatioInteger() {
        return Numeric.toBigInt((String)this.feeRatio);
    }

    public void setFeeRatio(String feeRatio) {
        if (feeRatio == null) {
            throw new IllegalArgumentException("feeRatio is missing.");
        }
        if (!Utils.isNumber(feeRatio) && !Utils.isHex(feeRatio)) {
            throw new IllegalArgumentException("Invalid type of feeRatio: feeRatio should be number type or hex number string");
        }
        int feeRatioVal = Numeric.toBigInt((String)feeRatio).intValue();
        if (feeRatioVal <= 0 || feeRatioVal >= 100) {
            throw new IllegalArgumentException("Invalid feeRatio: feeRatio is out of range. [1,99]");
        }
        this.feeRatio = feeRatio;
    }

    public void setFeeRatio(BigInteger feeRatio) {
        if (feeRatio == null) {
            throw new IllegalArgumentException("feeRatio is missing.");
        }
        this.setFeeRatio(Numeric.toHexStringWithPrefix((BigInteger)feeRatio));
    }

    public static class Builder<B extends Builder>
    extends AbstractFeeDelegatedTransaction.Builder<B> {
        String feeRatio;

        public Builder(String type) {
            super(type);
        }

        public B setFeeRatio(String feeRatio) {
            this.feeRatio = feeRatio;
            return (B)this;
        }

        public B setFeeRatio(BigInteger feeRatio) {
            return this.setFeeRatio(Numeric.toHexStringWithPrefix((BigInteger)feeRatio));
        }
    }
}

