/*
 * Decompiled with CFR 0.152.
 */
package com.klaytn.caver.methods.response;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.klaytn.caver.crypto.KlaySignatureData;
import com.klaytn.caver.methods.response.KlayLogs;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.web3j.protocol.core.Response;
import org.web3j.utils.Numeric;

@Deprecated
public class KlayTransactionReceipt
extends Response<TransactionReceipt> {
    public Optional<TransactionReceipt> getTransactionReceipt() {
        return Optional.ofNullable(this.getResult());
    }

    public static class KlayTransactionReceiptDeserializer
    extends JsonDeserializer<List<KlaySignatureData>> {
        public List<KlaySignatureData> deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            Iterator iterator = node.iterator();
            ArrayList<KlaySignatureData> klaySignatureData = new ArrayList<KlaySignatureData>();
            while (iterator.hasNext()) {
                JsonNode innerNode = (JsonNode)iterator.next();
                byte[] v = Numeric.hexStringToByteArray((String)innerNode.get("V").asText());
                byte[] r = Numeric.hexStringToByteArray((String)innerNode.get("R").asText());
                byte[] s = Numeric.hexStringToByteArray((String)innerNode.get("S").asText());
                klaySignatureData.add(new KlaySignatureData(v, r, s));
            }
            return klaySignatureData;
        }
    }

    public static class TransactionReceipt {
        private String blockHash;
        private String blockNumber;
        private String contractAddress;
        private String feePayer;
        private List<KlaySignatureData> feePayerSignatures;
        private String feeRatio;
        private String from;
        private String gas;
        private String gasPrice;
        private String gasUsed;
        private String input;
        private List<KlayLogs.Log> logs;
        private String logsBloom;
        private String nonce;
        private String senderTxHash;
        private List<KlaySignatureData> signatures;
        private String status;
        private String to;
        private String transactionIndex;
        private String transactionHash;
        private String txError;
        private String type;
        private String typeInt;
        private String value;

        public TransactionReceipt() {
        }

        public TransactionReceipt(String blockHash, String blockNumber, String contractAddress, String feePayer, List<KlaySignatureData> feePayerSignatures, String feeRatio, String from, String gas, String gasPrice, String gasUsed, String input, List<KlayLogs.Log> logs, String logsBloom, String nonce, String senderTxHash, List<KlaySignatureData> signatures, String status, String to, String transactionIndex, String transactionHash, String txError, String type, String typeInt, String value) {
            this.blockHash = blockHash;
            this.blockNumber = blockNumber;
            this.contractAddress = contractAddress;
            this.feePayer = feePayer;
            this.feePayerSignatures = feePayerSignatures;
            this.feeRatio = feeRatio;
            this.from = from;
            this.gas = gas;
            this.gasPrice = gasPrice;
            this.gasUsed = gasUsed;
            this.input = input;
            this.logs = logs;
            this.logsBloom = logsBloom;
            this.nonce = nonce;
            this.senderTxHash = senderTxHash;
            this.signatures = signatures;
            this.status = status;
            this.to = to;
            this.transactionIndex = transactionIndex;
            this.transactionHash = transactionHash;
            this.txError = txError;
            this.type = type;
            this.typeInt = typeInt;
            this.value = value;
        }

        public String getBlockHash() {
            return this.blockHash;
        }

        public String getBlockNumber() {
            return this.blockNumber;
        }

        public String getContractAddress() {
            return this.contractAddress;
        }

        public String getFeePayer() {
            return this.feePayer;
        }

        @JsonDeserialize(using=KlayTransactionReceiptDeserializer.class)
        public void setFeePayerSignatures(List<KlaySignatureData> feePayerSignatures) {
            this.feePayerSignatures = feePayerSignatures;
        }

        public List<KlaySignatureData> getFeePayerSignatures() {
            return this.feePayerSignatures;
        }

        public String getFeeRatio() {
            return this.feeRatio;
        }

        public String getFrom() {
            return this.from;
        }

        public String getGas() {
            return this.gas;
        }

        public String getGasPrice() {
            return this.gasPrice;
        }

        public String getGasUsed() {
            return this.gasUsed;
        }

        public String getInput() {
            return this.input;
        }

        public List<KlayLogs.Log> getLogs() {
            return this.logs;
        }

        public String getLogsBloom() {
            return this.logsBloom;
        }

        public String getNonce() {
            return this.nonce;
        }

        public String getSenderTxHash() {
            return this.senderTxHash;
        }

        public List<KlaySignatureData> getSignatures() {
            return this.signatures;
        }

        @JsonDeserialize(using=KlayTransactionReceiptDeserializer.class)
        public void setSignatures(List<KlaySignatureData> signatures) {
            this.signatures = signatures;
        }

        public String getStatus() {
            return this.status;
        }

        public String getTo() {
            return this.to;
        }

        public String getTransactionIndex() {
            return this.transactionIndex;
        }

        public String getTransactionHash() {
            return this.transactionHash;
        }

        public void setTransactionHash(String transactionHash) {
            this.transactionHash = transactionHash;
        }

        public String getTxError() {
            return this.txError;
        }

        public String getErrorMessage() {
            return TxError.getErrorMessage(this.txError);
        }

        public String getType() {
            return this.type;
        }

        public String getTypeInt() {
            return this.typeInt;
        }

        public String getValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof TransactionReceipt)) {
                return false;
            }
            TransactionReceipt that = (TransactionReceipt)o;
            if (this.getBlockHash() != null ? !this.getBlockHash().equals(that.getBlockHash()) : that.getBlockHash() != null) {
                return false;
            }
            if (this.getBlockNumber() != null ? !this.getBlockNumber().equals(that.getBlockNumber()) : that.getBlockNumber() != null) {
                return false;
            }
            if (this.getContractAddress() != null ? !this.getContractAddress().equals(that.getContractAddress()) : that.getContractAddress() != null) {
                return false;
            }
            if (this.getFeePayer() != null ? !this.getFeePayer().equals(that.getFeePayer()) : that.getFeePayer() != null) {
                return false;
            }
            if (this.getFeePayerSignatures() != null ? !this.getFeePayerSignatures().equals(that.getFeePayerSignatures()) : that.getFeePayerSignatures() != null) {
                return false;
            }
            if (this.getFeeRatio() != null ? !this.getFeeRatio().equals(that.getFeeRatio()) : that.getFeeRatio() != null) {
                return false;
            }
            if (this.getFrom() != null ? !this.getFrom().equals(that.getFrom()) : that.getFrom() != null) {
                return false;
            }
            if (this.getGas() != null ? !this.getGas().equals(that.getGas()) : that.getGas() != null) {
                return false;
            }
            if (this.getGasPrice() != null ? !this.getGasPrice().equals(that.getGasPrice()) : that.getGasPrice() != null) {
                return false;
            }
            if (this.getGasUsed() != null ? !this.getGasUsed().equals(that.getGasUsed()) : that.getGasUsed() != null) {
                return false;
            }
            if (this.getInput() != null ? !this.getInput().equals(that.getInput()) : that.getInput() != null) {
                return false;
            }
            if (this.getLogs() != null ? !this.getLogs().equals(that.getLogs()) : that.getLogs() != null) {
                return false;
            }
            if (this.getNonce() != null ? !this.getNonce().equals(that.getNonce()) : that.getNonce() != null) {
                return false;
            }
            if (this.getSenderTxHash() != null ? !this.getSenderTxHash().equals(that.getSenderTxHash()) : that.getSenderTxHash() != null) {
                return false;
            }
            if (this.getSignatures() != null ? !this.getSignatures().equals(that.getSignatures()) : that.getSignatures() != null) {
                return false;
            }
            if (this.getStatus() != null ? !this.getStatus().equals(that.getStatus()) : that.getStatus() != null) {
                return false;
            }
            if (this.getTo() != null ? !this.getTo().equals(that.getTo()) : that.getTo() != null) {
                return false;
            }
            if (this.getTransactionHash() != null ? !this.getTransactionHash().equals(that.getTransactionHash()) : that.getTransactionHash() != null) {
                return false;
            }
            if (this.getTransactionIndex() != null ? !this.getTransactionIndex().equals(that.getTransactionIndex()) : that.getTransactionIndex() != null) {
                return false;
            }
            if (this.getType() != null ? !this.getType().equals(that.getType()) : that.getType() != null) {
                return false;
            }
            if (this.getTypeInt() != null ? !this.getTypeInt().equals(that.getTypeInt()) : that.getTypeInt() != null) {
                return false;
            }
            if (this.getValue() != null ? !this.getValue().equals(that.getValue()) : that.getValue() != null) {
                return false;
            }
            return this.getLogsBloom() != null ? this.getLogsBloom().equals(that.getLogsBloom()) : that.getLogsBloom() == null;
        }

        public int hashCode() {
            int result = this.getTransactionHash() != null ? this.getTransactionHash().hashCode() : 0;
            result = 31 * result + (this.getBlockHash() != null ? this.getBlockHash().hashCode() : 0);
            result = 31 * result + (this.getBlockNumber() != null ? this.getBlockNumber().hashCode() : 0);
            result = 31 * result + (this.getContractAddress() != null ? this.getContractAddress().hashCode() : 0);
            result = 31 * result + (this.getFeePayer() != null ? this.getFeePayer().hashCode() : 0);
            result = 31 * result + (this.getFeePayerSignatures() != null ? this.getFeePayerSignatures().hashCode() : 0);
            result = 31 * result + (this.getFeeRatio() != null ? this.getFeeRatio().hashCode() : 0);
            result = 31 * result + (this.getFrom() != null ? this.getFrom().hashCode() : 0);
            result = 31 * result + (this.getGas() != null ? this.getGas().hashCode() : 0);
            result = 31 * result + (this.getGasPrice() != null ? this.getGasPrice().hashCode() : 0);
            result = 31 * result + (this.getGasUsed() != null ? this.getGasUsed().hashCode() : 0);
            result = 31 * result + (this.getInput() != null ? this.getInput().hashCode() : 0);
            result = 31 * result + (this.getLogs() != null ? this.getLogs().hashCode() : 0);
            result = 31 * result + (this.getLogsBloom() != null ? this.getLogsBloom().hashCode() : 0);
            result = 31 * result + (this.getNonce() != null ? this.getNonce().hashCode() : 0);
            result = 31 * result + (this.getSenderTxHash() != null ? this.getSenderTxHash().hashCode() : 0);
            result = 31 * result + (this.getSignatures() != null ? this.getSignatures().hashCode() : 0);
            result = 31 * result + (this.getStatus() != null ? this.getStatus().hashCode() : 0);
            result = 31 * result + (this.getTo() != null ? this.getTo().hashCode() : 0);
            result = 31 * result + (this.getTransactionIndex() != null ? this.getTransactionIndex().hashCode() : 0);
            result = 31 * result + (this.getType() != null ? this.getType().hashCode() : 0);
            result = 31 * result + (this.getTypeInt() != null ? this.getTypeInt().hashCode() : 0);
            result = 31 * result + (this.getValue() != null ? this.getValue().hashCode() : 0);
            return result;
        }
    }

    static enum TxError {
        RUNTIME_ERROR("0x2", "runtime error occurred in interpreter"),
        MAX_CALL_EXCEED("0x3", "max call depth exceeded"),
        CONTRACT_ADDRESS_COLLISION("0x4", "contract address collision"),
        CONTRACT_OUT_OF_GAS("0x5", "contract creation code storage out of gas"),
        MAX_CODE_SIZE_EXCEED("0x6", "evm: max code size exceeded"),
        OUT_OF_GAS("0x7", "out of gas"),
        WRITE_PROTECTION("0x8", "evm: write protection"),
        EXECUTION_REVERTED("0x9", "evm: execution reverted"),
        OPCODE_COUNT_LIMIT("0xa", "reached the opcode count limit"),
        ACCOUNT_EXIST("0xb", "account already exists"),
        NOT_PROGRAM_ACCOUNT("0xc", "not a program account (e.g., an account having code and storage)"),
        NOT_HUMAN_READABLE_ACCOUNT("0xd", "not a human readable address"),
        FEE_RATIO_OUT_OF_RANGE("0xe", "fee ratio is out of range [1, 99]"),
        ACCOUNTKEYFAIL_NOT_UPDATABLE("0xf", "AccountKeyFail is not updatable"),
        DIFFERENT_ACCOUNTKEY_TYPE("0x10", "different account key type"),
        ACCOUNTKEYNIL_CANNOT_INITIALIZED("0x11", "AccountKeyNil cannot be initialized to an account"),
        PUBLICKEY_NOT_ON_CURVE("0x12", "public key is not on curve"),
        KEY_WEIGHT_ZERO("0x13", "key weight is zero"),
        KEY_NOT_SERIALIZABLE("0x14", "key is not serializable"),
        KEY_DUPLICATED("0x15", "duplicated key"),
        WEIGHTED_SUM_OVERFLOW("0x16", "weighted sum overflow"),
        UNSATISFIABLE_THRESHOLD("0x17", "unsatisfiable threshold. Weighted sum of keys is less than the threshold"),
        ZERO_LENGTH("0x18", "length is zero"),
        TOO_LONG_LENGTH("0x19", "length too long"),
        NESTED_ROLE_BASE_KEY("0x1a", "nested role-based key");

        private String value;
        private String errorMessage;

        private TxError(String value, String errorMessage) {
            this.value = value;
            this.errorMessage = errorMessage;
        }

        public static String getErrorMessage(String value) {
            for (TxError type : TxError.values()) {
                if (!type.value.equals(value)) continue;
                return type.errorMessage;
            }
            return null;
        }
    }
}

