/*
 * Decompiled with CFR 0.152.
 */
package com.klaytn.caver.methods.response;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.klaytn.caver.crypto.KlaySignatureData;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.web3j.protocol.core.Response;
import org.web3j.utils.Numeric;

@Deprecated
public class KlayTransaction
extends Response<Transaction> {
    public Optional<Transaction> getTransaction() {
        return Optional.ofNullable(this.getResult());
    }

    public static class KlayTransactionDeserializer
    extends JsonDeserializer<List<KlaySignatureData>> {
        public List<KlaySignatureData> deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            Iterator iterator = node.iterator();
            ArrayList<KlaySignatureData> klaySignatureData = new ArrayList<KlaySignatureData>();
            while (iterator.hasNext()) {
                JsonNode innerNode = (JsonNode)iterator.next();
                byte[] v = Numeric.hexStringToByteArray((String)innerNode.get("V").toString());
                byte[] r = Numeric.hexStringToByteArray((String)innerNode.get("R").toString());
                byte[] s = Numeric.hexStringToByteArray((String)innerNode.get("S").toString());
                klaySignatureData.add(new KlaySignatureData(v, r, s));
            }
            return klaySignatureData;
        }
    }

    public static class Transaction {
        private String blockHash;
        private String blockNumber;
        private String from;
        private String gas;
        private String gasPrice;
        private String hash;
        private String input;
        private String nonce;
        private String senderTxHash;
        private List<KlaySignatureData> signatures;
        private String to;
        private String transactionIndex;
        private String type;
        private String typeInt;
        private String value;

        public Transaction() {
        }

        public Transaction(String blockHash, String blockNumber, String from, String gas, String gasPrice, String hash, String input, String nonce, String senderTxHash, List<KlaySignatureData> signatures, String to, String transactionIndex, String type, String typeInt, String value) {
            this.blockHash = blockHash;
            this.blockNumber = blockNumber;
            this.from = from;
            this.gas = gas;
            this.gasPrice = gasPrice;
            this.hash = hash;
            this.input = input;
            this.nonce = nonce;
            this.senderTxHash = senderTxHash;
            this.signatures = signatures;
            this.to = to;
            this.transactionIndex = transactionIndex;
            this.type = type;
            this.typeInt = typeInt;
            this.value = value;
        }

        public String getBlockHash() {
            return this.blockHash;
        }

        public String getBlockNumber() {
            return this.blockNumber;
        }

        public String getFrom() {
            return this.from;
        }

        public String getGas() {
            return this.gas;
        }

        public String getGasPrice() {
            return this.gasPrice;
        }

        public String getHash() {
            return this.hash;
        }

        public String getInput() {
            return this.input;
        }

        public String getNonce() {
            return this.nonce;
        }

        public String getSenderTxHash() {
            return this.senderTxHash;
        }

        public List<KlaySignatureData> getSignatures() {
            return this.signatures;
        }

        @JsonDeserialize(using=KlayTransactionDeserializer.class)
        public void setSignatures(List<KlaySignatureData> signatures) {
            this.signatures = signatures;
        }

        public String getTo() {
            return this.to;
        }

        public String getTransactionIndex() {
            return this.transactionIndex;
        }

        public String getType() {
            return this.type;
        }

        public String getTypeInt() {
            return this.typeInt;
        }

        public String getValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Transaction)) {
                return false;
            }
            Transaction that = (Transaction)o;
            if (this.getBlockHash() != null ? !this.getBlockHash().equals(that.getBlockHash()) : that.getBlockHash() != null) {
                return false;
            }
            if (this.getBlockNumber() != null ? !this.getBlockNumber().equals(that.getBlockNumber()) : that.getBlockNumber() != null) {
                return false;
            }
            if (this.getFrom() != null ? !this.getFrom().equals(that.getFrom()) : that.getFrom() != null) {
                return false;
            }
            if (this.getGas() != null ? !this.getGas().equals(that.getGas()) : that.getGas() != null) {
                return false;
            }
            if (this.getGasPrice() != null ? !this.getGasPrice().equals(that.getGasPrice()) : that.getGasPrice() != null) {
                return false;
            }
            if (this.getHash() != null ? !this.getHash().equals(that.getHash()) : that.getHash() != null) {
                return false;
            }
            if (this.getInput() != null ? !this.getInput().equals(that.getInput()) : that.getInput() != null) {
                return false;
            }
            if (this.getNonce() != null ? !this.getNonce().equals(that.getNonce()) : that.getNonce() != null) {
                return false;
            }
            if (this.getSenderTxHash() != null ? !this.getSenderTxHash().equals(that.getSenderTxHash()) : that.getSenderTxHash() != null) {
                return false;
            }
            if (this.getSignatures() != null ? !this.getSignatures().equals(that.getSignatures()) : that.getSignatures() != null) {
                return false;
            }
            if (this.getTo() != null ? !this.getTo().equals(that.getTo()) : that.getTo() != null) {
                return false;
            }
            if (this.getTransactionIndex() != null ? !this.getTransactionIndex().equals(that.getTransactionIndex()) : that.getTransactionIndex() != null) {
                return false;
            }
            if (this.getType() != null ? !this.getType().equals(that.getType()) : that.getType() != null) {
                return false;
            }
            if (this.getTypeInt() != null ? !this.getTypeInt().equals(that.getTypeInt()) : that.getTypeInt() != null) {
                return false;
            }
            return this.getValue() != null ? this.getValue().equals(that.getValue()) : that.getValue() == null;
        }

        public int hashCode() {
            int result = this.getBlockHash() != null ? this.getBlockHash().hashCode() : 0;
            result = 31 * result + (this.getBlockNumber() != null ? this.getBlockNumber().hashCode() : 0);
            result = 31 * result + (this.getFrom() != null ? this.getFrom().hashCode() : 0);
            result = 31 * result + (this.getGas() != null ? this.getGas().hashCode() : 0);
            result = 31 * result + (this.getGasPrice() != null ? this.getGasPrice().hashCode() : 0);
            result = 31 * result + (this.getHash() != null ? this.getHash().hashCode() : 0);
            result = 31 * result + (this.getInput() != null ? this.getInput().hashCode() : 0);
            result = 31 * result + (this.getNonce() != null ? this.getNonce().hashCode() : 0);
            result = 31 * result + (this.getSenderTxHash() != null ? this.getSenderTxHash().hashCode() : 0);
            result = 31 * result + (this.getSignatures() != null ? this.getSignatures().hashCode() : 0);
            result = 31 * result + (this.getTo() != null ? this.getTo().hashCode() : 0);
            result = 31 * result + (this.getTransactionIndex() != null ? this.getTransactionIndex().hashCode() : 0);
            result = 31 * result + (this.getType() != null ? this.getType().hashCode() : 0);
            result = 31 * result + (this.getTypeInt() != null ? this.getTypeInt().hashCode() : 0);
            result = 31 * result + (this.getValue() != null ? this.getValue().hashCode() : 0);
            return result;
        }
    }
}

