/*
 * Decompiled with CFR 0.152.
 */
package com.klaytn.caver.methods.response;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.web3j.protocol.ObjectMapperFactory;
import org.web3j.protocol.core.Response;
import org.web3j.utils.Numeric;

public class KlayLogs
extends Response<List<LogResult>> {
    @JsonDeserialize(using=LogResultDeserialiser.class)
    public void setResult(List<LogResult> result) {
        super.setResult(result);
    }

    public List<LogResult> getLogs() {
        return (List)this.getResult();
    }

    public static class LogResultDeserialiser
    extends JsonDeserializer<List<LogResult>> {
        private ObjectReader objectReader = ObjectMapperFactory.getObjectReader();

        public List<LogResult> deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            ArrayList<LogResult> logResults;
            block3: {
                JsonToken nextToken;
                block2: {
                    logResults = new ArrayList<LogResult>();
                    nextToken = jsonParser.nextToken();
                    if (nextToken != JsonToken.START_OBJECT) break block2;
                    Iterator logObjectIterator = this.objectReader.readValues(jsonParser, LogObject.class);
                    while (logObjectIterator.hasNext()) {
                        logResults.add((LogResult)logObjectIterator.next());
                    }
                    break block3;
                }
                if (nextToken != JsonToken.VALUE_STRING) break block3;
                jsonParser.getValueAsString();
                Iterator transactionHashIterator = this.objectReader.readValues(jsonParser, Hash.class);
                while (transactionHashIterator.hasNext()) {
                    logResults.add((LogResult)transactionHashIterator.next());
                }
            }
            return logResults;
        }
    }

    public static class Log {
        private String logIndex;
        private String transactionIndex;
        private String transactionHash;
        private String blockHash;
        private String blockNumber;
        private String address;
        private String data;
        private List<String> topics;

        public Log() {
        }

        public Log(String logIndex, String transactionIndex, String transactionHash, String blockHash, String blockNumber, String address, String data, List<String> topics) {
            this.logIndex = logIndex;
            this.transactionIndex = transactionIndex;
            this.transactionHash = transactionHash;
            this.blockHash = blockHash;
            this.blockNumber = blockNumber;
            this.address = address;
            this.data = data;
            this.topics = topics;
        }

        public BigInteger getLogIndex() {
            return this.convert(this.logIndex);
        }

        public String getLogIndexRaw() {
            return this.logIndex;
        }

        public void setLogIndex(String logIndex) {
            this.logIndex = logIndex;
        }

        public BigInteger getTransactionIndex() {
            return this.convert(this.transactionIndex);
        }

        public String getTransactionIndexRaw() {
            return this.transactionIndex;
        }

        public void setTransactionIndex(String transactionIndex) {
            this.transactionIndex = transactionIndex;
        }

        public String getTransactionHash() {
            return this.transactionHash;
        }

        public void setTransactionHash(String transactionHash) {
            this.transactionHash = transactionHash;
        }

        public String getBlockHash() {
            return this.blockHash;
        }

        public void setBlockHash(String blockHash) {
            this.blockHash = blockHash;
        }

        public BigInteger getBlockNumber() {
            return this.convert(this.blockNumber);
        }

        public String getBlockNumberRaw() {
            return this.blockNumber;
        }

        public void setBlockNumber(String blockNumber) {
            this.blockNumber = blockNumber;
        }

        public String getAddress() {
            return this.address;
        }

        public void setAddress(String address) {
            this.address = address;
        }

        public String getData() {
            return this.data;
        }

        public void setData(String data) {
            this.data = data;
        }

        public List<String> getTopics() {
            return this.topics;
        }

        public void setTopics(List<String> topics) {
            this.topics = topics;
        }

        private BigInteger convert(String value) {
            if (value != null) {
                return Numeric.decodeQuantity((String)value);
            }
            return null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Log)) {
                return false;
            }
            Log that = (Log)o;
            if (this.getLogIndexRaw() != null ? !this.getLogIndexRaw().equals(that.getLogIndexRaw()) : that.getLogIndexRaw() != null) {
                return false;
            }
            if (this.getTransactionIndexRaw() != null ? !this.getTransactionIndexRaw().equals(that.getTransactionIndexRaw()) : that.getTransactionIndexRaw() != null) {
                return false;
            }
            if (this.getTransactionHash() != null ? !this.getTransactionHash().equals(that.getTransactionHash()) : that.getTransactionHash() != null) {
                return false;
            }
            if (this.getBlockHash() != null ? !this.getBlockHash().equals(that.getBlockHash()) : that.getBlockHash() != null) {
                return false;
            }
            if (this.getBlockNumberRaw() != null ? !this.getBlockNumberRaw().equals(that.getBlockNumberRaw()) : that.getBlockNumberRaw() != null) {
                return false;
            }
            if (this.getAddress() != null ? !this.getAddress().equals(that.getAddress()) : that.getAddress() != null) {
                return false;
            }
            if (this.getData() != null ? !this.getData().equals(that.getData()) : that.getData() != null) {
                return false;
            }
            return this.getTopics() != null ? this.getTopics().equals(that.getTopics()) : that.getTopics() == null;
        }

        public int hashCode() {
            int result = this.getLogIndexRaw() != null ? this.getLogIndexRaw().hashCode() : 0;
            result = 31 * result + (this.getTransactionIndexRaw() != null ? this.getTransactionIndexRaw().hashCode() : 0);
            result = 31 * result + (this.getTransactionHash() != null ? this.getTransactionHash().hashCode() : 0);
            result = 31 * result + (this.getBlockHash() != null ? this.getBlockHash().hashCode() : 0);
            result = 31 * result + (this.getBlockNumberRaw() != null ? this.getBlockNumberRaw().hashCode() : 0);
            result = 31 * result + (this.getAddress() != null ? this.getAddress().hashCode() : 0);
            result = 31 * result + (this.getData() != null ? this.getData().hashCode() : 0);
            result = 31 * result + (this.getTopics() != null ? this.getTopics().hashCode() : 0);
            return result;
        }
    }

    public static class Hash
    implements LogResult<String> {
        private String value;

        public Hash() {
        }

        public Hash(String value) {
            this.value = value;
        }

        @Override
        public String get() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Hash)) {
                return false;
            }
            Hash hash = (Hash)o;
            return this.value != null ? this.value.equals(hash.value) : hash.value == null;
        }

        public int hashCode() {
            return this.value != null ? this.value.hashCode() : 0;
        }
    }

    public static class LogObject
    extends Log
    implements LogResult<Log> {
        public LogObject() {
        }

        public LogObject(String logIndex, String transactionIndex, String transactionHash, String blockHash, String blockNumber, String address, String data, List<String> topics) {
            super(logIndex, transactionIndex, transactionHash, blockHash, blockNumber, address, data, topics);
        }

        @Override
        public Log get() {
            return this;
        }
    }

    public static interface LogResult<T> {
        public T get();
    }
}

