/*
 * Decompiled with CFR 0.152.
 */
package com.klaytn.caver.methods.response;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.klaytn.caver.account.AccountKeyFail;
import com.klaytn.caver.account.AccountKeyLegacy;
import com.klaytn.caver.account.AccountKeyNil;
import com.klaytn.caver.account.AccountKeyPublic;
import com.klaytn.caver.account.AccountKeyRoleBased;
import com.klaytn.caver.account.AccountKeyWeightedMultiSig;
import com.klaytn.caver.account.IAccountKey;
import java.io.IOException;
import java.math.BigInteger;
import org.web3j.protocol.ObjectMapperFactory;
import org.web3j.protocol.core.Response;
import org.web3j.utils.Numeric;

public class AccountKey
extends Response<AccountKeyData> {

    public static class AccountKeyDeserializer
    extends JsonDeserializer<AccountKeyData> {
        private static ObjectMapper objectMapper = ObjectMapperFactory.getObjectMapper();

        public static IAccountKey decode(JsonNode keyJson, String type) throws IOException {
            if (type.equals(AccountKeyLegacy.getType())) {
                return new AccountKeyLegacy();
            }
            if (type.equals(AccountKeyPublic.getType())) {
                return (IAccountKey)objectMapper.readValue(keyJson.toString(), AccountKeyPublic.class);
            }
            if (type.equals(AccountKeyWeightedMultiSig.getType())) {
                return (IAccountKey)objectMapper.readValue(keyJson.toString(), AccountKeyWeightedMultiSig.class);
            }
            if (type.equals(AccountKeyRoleBased.getType())) {
                return (IAccountKey)objectMapper.readValue(keyJson.toString(), AccountKeyRoleBased.class);
            }
            if (type.equals(AccountKeyFail.getType())) {
                return new AccountKeyFail();
            }
            return new AccountKeyNil();
        }

        public AccountKeyData deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            JsonNode root = (JsonNode)p.getCodec().readTree(p);
            String type = Numeric.toHexStringWithPrefixZeroPadded((BigInteger)root.get("keyType").bigIntegerValue(), (int)2);
            IAccountKey accountKey = AccountKeyDeserializer.decode(root, type);
            return new AccountKeyData(type, accountKey);
        }
    }

    @JsonDeserialize(using=AccountKeyDeserializer.class)
    public static class AccountKeyData {
        private String type;
        private IAccountKey accountKey;

        public AccountKeyData(String type, IAccountKey accountKey) {
            this.type = type;
            this.accountKey = accountKey;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public IAccountKey getAccountKey() {
            return this.accountKey;
        }

        public void setAccountKey(IAccountKey accountKey) {
            this.accountKey = accountKey;
        }
    }
}

