/*
 * Decompiled with CFR 0.152.
 */
package com.klaytn.caver.methods.request;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.math.BigInteger;
import org.web3j.utils.Numeric;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class CallObject {
    private String from;
    private String to;
    private BigInteger gasLimit;
    private BigInteger gasPrice;
    private BigInteger value;
    private String data;

    public CallObject(String from, String to, BigInteger gasLimit, BigInteger gasPrice, BigInteger value, String data) {
        this.from = from;
        this.to = to;
        this.gasLimit = gasLimit;
        this.gasPrice = gasPrice;
        this.value = value;
        this.data = data;
    }

    public static CallObject createCallObject(String from, String to, BigInteger gas, BigInteger gasPrice, BigInteger value, String data) {
        return new CallObject(from, to, gas, gasPrice, value, data);
    }

    public static CallObject createCallObject(String from, String to, BigInteger gas, BigInteger gasPrice, BigInteger value) {
        return CallObject.createCallObject(from, to, gas, gasPrice, value, null);
    }

    public static CallObject createCallObject(String from) {
        return CallObject.createCallObject(from, null, null, null, null, null);
    }

    public static CallObject createCallObject() {
        return CallObject.createCallObject(null, null, null, null, null, null);
    }

    public String getFrom() {
        return this.from;
    }

    public String getTo() {
        return this.to;
    }

    public String getGasLimit() {
        return CallObject.convert(this.gasLimit);
    }

    public String getGasPrice() {
        return CallObject.convert(this.gasPrice);
    }

    public String getValue() {
        return CallObject.convert(this.value);
    }

    public String getData() {
        return this.data;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public void setTo(String to) {
        this.to = to;
    }

    public void setGasLimit(BigInteger gasLimit) {
        this.gasLimit = gasLimit;
    }

    public void setGasPrice(BigInteger gasPrice) {
        this.gasPrice = gasPrice;
    }

    public void setValue(BigInteger value) {
        this.value = value;
    }

    public void setData(String data) {
        this.data = data;
    }

    private static String convert(BigInteger value) {
        if (value != null) {
            return Numeric.encodeQuantity((BigInteger)value);
        }
        return null;
    }
}

