/*
 * Decompiled with CFR 0.152.
 */
package com.klaytn.caver.kct;

import com.klaytn.caver.Caver;
import com.klaytn.caver.crypto.KlayCredentials;
import com.klaytn.caver.methods.response.KlayLogs;
import com.klaytn.caver.methods.response.KlayTransactionReceipt;
import com.klaytn.caver.tx.SmartContract;
import com.klaytn.caver.tx.manager.TransactionManager;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.web3j.abi.FunctionEncoder;
import org.web3j.abi.TypeReference;
import org.web3j.abi.datatypes.Address;
import org.web3j.abi.datatypes.Bool;
import org.web3j.abi.datatypes.DynamicBytes;
import org.web3j.abi.datatypes.Event;
import org.web3j.abi.datatypes.Function;
import org.web3j.abi.datatypes.Type;
import org.web3j.abi.datatypes.Utf8String;
import org.web3j.abi.datatypes.generated.Bytes4;
import org.web3j.abi.datatypes.generated.Uint256;
import org.web3j.abi.datatypes.generated.Uint8;
import org.web3j.protocol.core.RemoteCall;
import org.web3j.tx.gas.ContractGasProvider;

@Deprecated
public class KIP7
extends SmartContract {
    private static final String BINARY = "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";
    public static final String FUNC_ADDMINTER = "addMinter";
    public static final String FUNC_ADDPAUSER = "addPauser";
    public static final String FUNC_ALLOWANCE = "allowance";
    public static final String FUNC_APPROVE = "approve";
    public static final String FUNC_BALANCEOF = "balanceOf";
    public static final String FUNC_BURN = "burn";
    public static final String FUNC_BURNFROM = "burnFrom";
    public static final String FUNC_DECIMALS = "decimals";
    public static final String FUNC_ISMINTER = "isMinter";
    public static final String FUNC_ISPAUSER = "isPauser";
    public static final String FUNC_MINT = "mint";
    public static final String FUNC_NAME = "name";
    public static final String FUNC_PAUSE = "pause";
    public static final String FUNC_PAUSED = "paused";
    public static final String FUNC_RENOUNCEMINTER = "renounceMinter";
    public static final String FUNC_RENOUNCEPAUSER = "renouncePauser";
    public static final String FUNC_SAFETRANSFER = "safeTransfer";
    public static final String FUNC_SAFETRANSFERFROM = "safeTransferFrom";
    public static final String FUNC_SUPPORTSINTERFACE = "supportsInterface";
    public static final String FUNC_SYMBOL = "symbol";
    public static final String FUNC_TOTALSUPPLY = "totalSupply";
    public static final String FUNC_TRANSFER = "transfer";
    public static final String FUNC_TRANSFERFROM = "transferFrom";
    public static final String FUNC_UNPAUSE = "unpause";
    public static final Event APPROVAL_EVENT = new Event("Approval", Arrays.asList(new TypeReference<Address>(true){}, new TypeReference<Address>(true){}, new TypeReference<Uint256>(){}));
    public static final Event MINTERADDED_EVENT = new Event("MinterAdded", Arrays.asList(new TypeReference<Address>(true){}));
    public static final Event MINTERREMOVED_EVENT = new Event("MinterRemoved", Arrays.asList(new TypeReference<Address>(true){}));
    public static final Event PAUSED_EVENT = new Event("Paused", Arrays.asList(new TypeReference<Address>(){}));
    public static final Event PAUSERADDED_EVENT = new Event("PauserAdded", Arrays.asList(new TypeReference<Address>(true){}));
    public static final Event PAUSERREMOVED_EVENT = new Event("PauserRemoved", Arrays.asList(new TypeReference<Address>(true){}));
    public static final Event TRANSFER_EVENT = new Event("Transfer", Arrays.asList(new TypeReference<Address>(true){}, new TypeReference<Address>(true){}, new TypeReference<Uint256>(){}));
    public static final Event UNPAUSED_EVENT = new Event("Unpaused", Arrays.asList(new TypeReference<Address>(){}));
    protected static final HashMap<String, String> _addresses = new HashMap();

    protected KIP7(String contractAddress, Caver caver, KlayCredentials credentials, int chainId, ContractGasProvider contractGasProvider) {
        super(BINARY, contractAddress, caver, credentials, chainId, contractGasProvider);
    }

    protected KIP7(String contractAddress, Caver caver, TransactionManager transactionManager, ContractGasProvider contractGasProvider) {
        super(BINARY, contractAddress, caver, transactionManager, contractGasProvider);
    }

    public List<ApprovalEventResponse> getApprovalEvents(KlayTransactionReceipt.TransactionReceipt transactionReceipt) {
        List<SmartContract.EventValuesWithLog> valueList = this.extractEventParametersWithLog(APPROVAL_EVENT, transactionReceipt);
        ArrayList<ApprovalEventResponse> responses = new ArrayList<ApprovalEventResponse>(valueList.size());
        for (SmartContract.EventValuesWithLog eventValues : valueList) {
            ApprovalEventResponse typedResponse = new ApprovalEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.owner = (String)eventValues.getIndexedValues().get(0).getValue();
            typedResponse.spender = (String)eventValues.getIndexedValues().get(1).getValue();
            typedResponse.value = (BigInteger)eventValues.getNonIndexedValues().get(0).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public List<MinterAddedEventResponse> getMinterAddedEvents(KlayTransactionReceipt.TransactionReceipt transactionReceipt) {
        List<SmartContract.EventValuesWithLog> valueList = this.extractEventParametersWithLog(MINTERADDED_EVENT, transactionReceipt);
        ArrayList<MinterAddedEventResponse> responses = new ArrayList<MinterAddedEventResponse>(valueList.size());
        for (SmartContract.EventValuesWithLog eventValues : valueList) {
            MinterAddedEventResponse typedResponse = new MinterAddedEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.account = (String)eventValues.getIndexedValues().get(0).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public List<MinterRemovedEventResponse> getMinterRemovedEvents(KlayTransactionReceipt.TransactionReceipt transactionReceipt) {
        List<SmartContract.EventValuesWithLog> valueList = this.extractEventParametersWithLog(MINTERREMOVED_EVENT, transactionReceipt);
        ArrayList<MinterRemovedEventResponse> responses = new ArrayList<MinterRemovedEventResponse>(valueList.size());
        for (SmartContract.EventValuesWithLog eventValues : valueList) {
            MinterRemovedEventResponse typedResponse = new MinterRemovedEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.account = (String)eventValues.getIndexedValues().get(0).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public List<PausedEventResponse> getPausedEvents(KlayTransactionReceipt.TransactionReceipt transactionReceipt) {
        List<SmartContract.EventValuesWithLog> valueList = this.extractEventParametersWithLog(PAUSED_EVENT, transactionReceipt);
        ArrayList<PausedEventResponse> responses = new ArrayList<PausedEventResponse>(valueList.size());
        for (SmartContract.EventValuesWithLog eventValues : valueList) {
            PausedEventResponse typedResponse = new PausedEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.account = (String)eventValues.getNonIndexedValues().get(0).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public List<PauserAddedEventResponse> getPauserAddedEvents(KlayTransactionReceipt.TransactionReceipt transactionReceipt) {
        List<SmartContract.EventValuesWithLog> valueList = this.extractEventParametersWithLog(PAUSERADDED_EVENT, transactionReceipt);
        ArrayList<PauserAddedEventResponse> responses = new ArrayList<PauserAddedEventResponse>(valueList.size());
        for (SmartContract.EventValuesWithLog eventValues : valueList) {
            PauserAddedEventResponse typedResponse = new PauserAddedEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.account = (String)eventValues.getIndexedValues().get(0).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public List<PauserRemovedEventResponse> getPauserRemovedEvents(KlayTransactionReceipt.TransactionReceipt transactionReceipt) {
        List<SmartContract.EventValuesWithLog> valueList = this.extractEventParametersWithLog(PAUSERREMOVED_EVENT, transactionReceipt);
        ArrayList<PauserRemovedEventResponse> responses = new ArrayList<PauserRemovedEventResponse>(valueList.size());
        for (SmartContract.EventValuesWithLog eventValues : valueList) {
            PauserRemovedEventResponse typedResponse = new PauserRemovedEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.account = (String)eventValues.getIndexedValues().get(0).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public List<TransferEventResponse> getTransferEvents(KlayTransactionReceipt.TransactionReceipt transactionReceipt) {
        List<SmartContract.EventValuesWithLog> valueList = this.extractEventParametersWithLog(TRANSFER_EVENT, transactionReceipt);
        ArrayList<TransferEventResponse> responses = new ArrayList<TransferEventResponse>(valueList.size());
        for (SmartContract.EventValuesWithLog eventValues : valueList) {
            TransferEventResponse typedResponse = new TransferEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.from = (String)eventValues.getIndexedValues().get(0).getValue();
            typedResponse.to = (String)eventValues.getIndexedValues().get(1).getValue();
            typedResponse.value = (BigInteger)eventValues.getNonIndexedValues().get(0).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public List<UnpausedEventResponse> getUnpausedEvents(KlayTransactionReceipt.TransactionReceipt transactionReceipt) {
        List<SmartContract.EventValuesWithLog> valueList = this.extractEventParametersWithLog(UNPAUSED_EVENT, transactionReceipt);
        ArrayList<UnpausedEventResponse> responses = new ArrayList<UnpausedEventResponse>(valueList.size());
        for (SmartContract.EventValuesWithLog eventValues : valueList) {
            UnpausedEventResponse typedResponse = new UnpausedEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.account = (String)eventValues.getNonIndexedValues().get(0).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public RemoteCall<KlayTransactionReceipt.TransactionReceipt> addMinter(String account) {
        Function function = new Function(FUNC_ADDMINTER, Arrays.asList(new Address(account)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteCall<KlayTransactionReceipt.TransactionReceipt> addPauser(String account) {
        Function function = new Function(FUNC_ADDPAUSER, Arrays.asList(new Address(account)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteCall<BigInteger> allowance(String owner, String spender) {
        Function function = new Function(FUNC_ALLOWANCE, Arrays.asList(new Address(owner), new Address(spender)), Arrays.asList(new TypeReference<Uint256>(){}));
        return this.executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteCall<KlayTransactionReceipt.TransactionReceipt> approve(String spender, BigInteger value) {
        Function function = new Function(FUNC_APPROVE, Arrays.asList(new Address(spender), new Uint256(value)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteCall<BigInteger> balanceOf(String account) {
        Function function = new Function(FUNC_BALANCEOF, Arrays.asList(new Address(account)), Arrays.asList(new TypeReference<Uint256>(){}));
        return this.executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteCall<KlayTransactionReceipt.TransactionReceipt> burn(BigInteger amount) {
        Function function = new Function(FUNC_BURN, Arrays.asList(new Uint256(amount)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteCall<KlayTransactionReceipt.TransactionReceipt> burnFrom(String account, BigInteger amount) {
        Function function = new Function(FUNC_BURNFROM, Arrays.asList(new Address(account), new Uint256(amount)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteCall<BigInteger> decimals() {
        Function function = new Function(FUNC_DECIMALS, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Uint8>(){}));
        return this.executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteCall<Boolean> isMinter(String account) {
        Function function = new Function(FUNC_ISMINTER, Arrays.asList(new Address(account)), Arrays.asList(new TypeReference<Bool>(){}));
        return this.executeRemoteCallSingleValueReturn(function, Boolean.class);
    }

    public RemoteCall<Boolean> isPauser(String account) {
        Function function = new Function(FUNC_ISPAUSER, Arrays.asList(new Address(account)), Arrays.asList(new TypeReference<Bool>(){}));
        return this.executeRemoteCallSingleValueReturn(function, Boolean.class);
    }

    public RemoteCall<KlayTransactionReceipt.TransactionReceipt> mint(String account, BigInteger amount) {
        Function function = new Function(FUNC_MINT, Arrays.asList(new Address(account), new Uint256(amount)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteCall<String> name() {
        Function function = new Function(FUNC_NAME, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Utf8String>(){}));
        return this.executeRemoteCallSingleValueReturn(function, String.class);
    }

    public RemoteCall<KlayTransactionReceipt.TransactionReceipt> pause() {
        Function function = new Function(FUNC_PAUSE, Arrays.asList(new Type[0]), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteCall<Boolean> paused() {
        Function function = new Function(FUNC_PAUSED, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Bool>(){}));
        return this.executeRemoteCallSingleValueReturn(function, Boolean.class);
    }

    public RemoteCall<KlayTransactionReceipt.TransactionReceipt> renounceMinter() {
        Function function = new Function(FUNC_RENOUNCEMINTER, Arrays.asList(new Type[0]), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteCall<KlayTransactionReceipt.TransactionReceipt> renouncePauser() {
        Function function = new Function(FUNC_RENOUNCEPAUSER, Arrays.asList(new Type[0]), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteCall<KlayTransactionReceipt.TransactionReceipt> safeTransfer(String recipient, BigInteger amount) {
        Function function = new Function(FUNC_SAFETRANSFER, Arrays.asList(new Address(recipient), new Uint256(amount)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteCall<KlayTransactionReceipt.TransactionReceipt> safeTransfer(String recipient, BigInteger amount, byte[] data) {
        Function function = new Function(FUNC_SAFETRANSFER, Arrays.asList(new Address(recipient), new Uint256(amount), new DynamicBytes(data)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteCall<KlayTransactionReceipt.TransactionReceipt> safeTransferFrom(String sender, String recipient, BigInteger amount) {
        Function function = new Function(FUNC_SAFETRANSFERFROM, Arrays.asList(new Address(sender), new Address(recipient), new Uint256(amount)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteCall<KlayTransactionReceipt.TransactionReceipt> safeTransferFrom(String sender, String recipient, BigInteger amount, byte[] data) {
        Function function = new Function(FUNC_SAFETRANSFERFROM, Arrays.asList(new Address(sender), new Address(recipient), new Uint256(amount), new DynamicBytes(data)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteCall<Boolean> supportsInterface(byte[] interfaceId) {
        Function function = new Function(FUNC_SUPPORTSINTERFACE, Arrays.asList(new Bytes4(interfaceId)), Arrays.asList(new TypeReference<Bool>(){}));
        return this.executeRemoteCallSingleValueReturn(function, Boolean.class);
    }

    public RemoteCall<String> symbol() {
        Function function = new Function(FUNC_SYMBOL, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Utf8String>(){}));
        return this.executeRemoteCallSingleValueReturn(function, String.class);
    }

    public RemoteCall<BigInteger> totalSupply() {
        Function function = new Function(FUNC_TOTALSUPPLY, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Uint256>(){}));
        return this.executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteCall<KlayTransactionReceipt.TransactionReceipt> transfer(String to, BigInteger value) {
        Function function = new Function(FUNC_TRANSFER, Arrays.asList(new Address(to), new Uint256(value)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteCall<KlayTransactionReceipt.TransactionReceipt> transferFrom(String from, String to, BigInteger value) {
        Function function = new Function(FUNC_TRANSFERFROM, Arrays.asList(new Address(from), new Address(to), new Uint256(value)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteCall<KlayTransactionReceipt.TransactionReceipt> unpause() {
        Function function = new Function(FUNC_UNPAUSE, Arrays.asList(new Type[0]), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public static KIP7 load(String contractAddress, Caver caver, KlayCredentials credentials, int chainId, ContractGasProvider contractGasProvider) {
        return new KIP7(contractAddress, caver, credentials, chainId, contractGasProvider);
    }

    public static KIP7 load(String contractAddress, Caver caver, TransactionManager transactionManager, ContractGasProvider contractGasProvider) {
        return new KIP7(contractAddress, caver, transactionManager, contractGasProvider);
    }

    public static RemoteCall<KIP7> deploy(Caver caver, KlayCredentials credentials, int chainId, ContractGasProvider contractGasProvider, String name, String symbol, BigInteger decimals, BigInteger initialSupply) {
        String encodedConstructor = FunctionEncoder.encodeConstructor(Arrays.asList(new Utf8String(name), new Utf8String(symbol), new Uint8(decimals), new Uint256(initialSupply)));
        return KIP7.deployRemoteCall(KIP7.class, caver, credentials, chainId, contractGasProvider, BINARY, encodedConstructor);
    }

    public static RemoteCall<KIP7> deploy(Caver caver, TransactionManager transactionManager, ContractGasProvider contractGasProvider, String name, String symbol, BigInteger decimals, BigInteger initialSupply) {
        String encodedConstructor = FunctionEncoder.encodeConstructor(Arrays.asList(new Utf8String(name), new Utf8String(symbol), new Uint8(decimals), new Uint256(initialSupply)));
        return KIP7.deployRemoteCall(KIP7.class, caver, transactionManager, contractGasProvider, BINARY, encodedConstructor);
    }

    @Override
    protected String getStaticDeployedAddress(String networkId) {
        return _addresses.get(networkId);
    }

    public static String getPreviouslyDeployedAddress(String networkId) {
        return _addresses.get(networkId);
    }

    public static class UnpausedEventResponse {
        public KlayLogs.Log log;
        public String account;
    }

    public static class TransferEventResponse {
        public KlayLogs.Log log;
        public String from;
        public String to;
        public BigInteger value;
    }

    public static class PauserRemovedEventResponse {
        public KlayLogs.Log log;
        public String account;
    }

    public static class PauserAddedEventResponse {
        public KlayLogs.Log log;
        public String account;
    }

    public static class PausedEventResponse {
        public KlayLogs.Log log;
        public String account;
    }

    public static class MinterRemovedEventResponse {
        public KlayLogs.Log log;
        public String account;
    }

    public static class MinterAddedEventResponse {
        public KlayLogs.Log log;
        public String account;
    }

    public static class ApprovalEventResponse {
        public KlayLogs.Log log;
        public String owner;
        public String spender;
        public BigInteger value;
    }
}

