/*
 * Decompiled with CFR 0.152.
 */
package com.klaytn.caver.fee;

import com.klaytn.caver.tx.type.TxType;
import com.klaytn.caver.tx.type.TxTypeFeeDelegate;
import com.klaytn.caver.tx.type.TxTypeFeeDelegatedAccountUpdate;
import com.klaytn.caver.tx.type.TxTypeFeeDelegatedAccountUpdateWithRatio;
import com.klaytn.caver.tx.type.TxTypeFeeDelegatedCancel;
import com.klaytn.caver.tx.type.TxTypeFeeDelegatedCancelWithRatio;
import com.klaytn.caver.tx.type.TxTypeFeeDelegatedSmartContractDeploy;
import com.klaytn.caver.tx.type.TxTypeFeeDelegatedSmartContractDeployWithRatio;
import com.klaytn.caver.tx.type.TxTypeFeeDelegatedSmartContractExecution;
import com.klaytn.caver.tx.type.TxTypeFeeDelegatedSmartContractExecutionWithRatio;
import com.klaytn.caver.tx.type.TxTypeFeeDelegatedValueTransfer;
import com.klaytn.caver.tx.type.TxTypeFeeDelegatedValueTransferMemo;
import com.klaytn.caver.tx.type.TxTypeFeeDelegatedValueTransferMemoWithRatio;
import com.klaytn.caver.tx.type.TxTypeFeeDelegatedValueTransferWithRatio;
import com.klaytn.caver.utils.KlayTransactionUtils;
import java.util.HashMap;
import java.util.function.Function;
import org.web3j.utils.Numeric;

public class FeePayerTransactionDecoder {
    private static HashMap<TxType.Type, Function<byte[], TxTypeFeeDelegate>> typeMap = new HashMap<TxType.Type, Function<byte[], TxTypeFeeDelegate>>(){
        {
            this.put(TxType.Type.FEE_DELEGATED_ACCOUNT_UPDATE, TxTypeFeeDelegatedAccountUpdate::decodeFromRawTransaction);
            this.put(TxType.Type.FEE_DELEGATED_ACCOUNT_UPDATE_WITH_RATIO, TxTypeFeeDelegatedAccountUpdateWithRatio::decodeFromRawTransaction);
            this.put(TxType.Type.FEE_DELEGATED_CANCEL, TxTypeFeeDelegatedCancel::decodeFromRawTransaction);
            this.put(TxType.Type.FEE_DELEGATED_CANCEL_WITH_RATIO, TxTypeFeeDelegatedCancelWithRatio::decodeFromRawTransaction);
            this.put(TxType.Type.FEE_DELEGATED_SMART_CONTRACT_DEPLOY, TxTypeFeeDelegatedSmartContractDeploy::decodeFromRawTransaction);
            this.put(TxType.Type.FEE_DELEGATED_SMART_CONTRACT_DEPLOY_WITH_RATIO, TxTypeFeeDelegatedSmartContractDeployWithRatio::decodeFromRawTransaction);
            this.put(TxType.Type.FEE_DELEGATED_SMART_CONTRACT_EXECUTION, TxTypeFeeDelegatedSmartContractExecution::decodeFromRawTransaction);
            this.put(TxType.Type.FEE_DELEGATED_SMART_CONTRACT_EXECUTION_WITH_RATIO, TxTypeFeeDelegatedSmartContractExecutionWithRatio::decodeFromRawTransaction);
            this.put(TxType.Type.FEE_DELEGATED_VALUE_TRANSFER, TxTypeFeeDelegatedValueTransfer::decodeFromRawTransaction);
            this.put(TxType.Type.FEE_DELEGATED_VALUE_TRANSFER_MEMO, TxTypeFeeDelegatedValueTransferMemo::decodeFromRawTransaction);
            this.put(TxType.Type.FEE_DELEGATED_VALUE_TRANSFER_MEMO_WITH_RATIO, TxTypeFeeDelegatedValueTransferMemoWithRatio::decodeFromRawTransaction);
            this.put(TxType.Type.FEE_DELEGATED_VALUE_TRANSFER_WITH_RATIO, TxTypeFeeDelegatedValueTransferWithRatio::decodeFromRawTransaction);
        }
    };

    public static TxTypeFeeDelegate decode(String rawTransaction) {
        TxType.Type type = KlayTransactionUtils.getType(rawTransaction);
        return typeMap.get((Object)type).apply(Numeric.hexStringToByteArray((String)rawTransaction));
    }
}

