/*
 * Decompiled with CFR 0.152.
 */
package com.klaytn.caver.fee;

import com.klaytn.caver.Caver;
import com.klaytn.caver.crypto.KlayCredentials;
import com.klaytn.caver.fee.FeePayer;
import com.klaytn.caver.fee.FeePayerTransactionDecoder;
import com.klaytn.caver.methods.response.Bytes32;
import com.klaytn.caver.methods.response.Callback;
import com.klaytn.caver.methods.response.KlayTransactionReceipt;
import com.klaytn.caver.tx.exception.PlatformErrorException;
import com.klaytn.caver.tx.manager.ErrorHandler;
import com.klaytn.caver.tx.manager.PollingTransactionReceiptProcessor;
import com.klaytn.caver.tx.manager.TransactionReceiptProcessor;
import com.klaytn.caver.tx.model.KlayRawTransaction;
import com.klaytn.caver.tx.type.TxTypeFeeDelegate;
import com.klaytn.caver.utils.ChainId;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import org.web3j.protocol.exceptions.TransactionException;

public class FeePayerManager {
    private Caver caver;
    private FeePayer signer;
    private TransactionReceiptProcessor transactionReceiptProcessor;
    private ErrorHandler errorHandler;

    private FeePayerManager(Builder builder) {
        this.caver = builder.caver;
        this.signer = new FeePayer(builder.credentials, builder.chainId);
        this.transactionReceiptProcessor = builder.transactionReceiptProcessor;
        this.errorHandler = builder.errorHandler;
    }

    private TxTypeFeeDelegate decode(String rawTransaction) {
        return FeePayerTransactionDecoder.decode(rawTransaction);
    }

    public KlayTransactionReceipt.TransactionReceipt executeTransaction(String rawTransaction) {
        KlayTransactionReceipt.TransactionReceipt transactionReceipt = null;
        try {
            KlayRawTransaction rawTx = this.sign(rawTransaction);
            String transactionHash = this.send(rawTx);
            transactionReceipt = this.transactionReceiptProcessor.waitForTransactionReceipt(transactionHash);
        }
        catch (PlatformErrorException | IOException | TransactionException e) {
            this.exception((Exception)e);
        }
        return transactionReceipt;
    }

    public KlayRawTransaction sign(String rawTransaction) {
        TxTypeFeeDelegate txTypeFeeDelegate = this.decode(rawTransaction);
        return this.signer.sign(txTypeFeeDelegate);
    }

    public String send(KlayRawTransaction klayRawTransaction) throws IOException, PlatformErrorException {
        Bytes32 transactionHash = (Bytes32)this.caver.klay().sendSignedTransaction(klayRawTransaction.getValueAsString()).send();
        if (transactionHash.hasError()) {
            throw new PlatformErrorException(transactionHash.getError());
        }
        return (String)transactionHash.getResult();
    }

    public void sendAsync(KlayRawTransaction klayRawTransaction, Callback<String> callback) {
        ((CompletableFuture)this.caver.klay().sendSignedTransaction(klayRawTransaction.getValueAsString()).sendAsync().thenAcceptAsync(response -> {
            if (response.hasError()) {
                this.exception(new PlatformErrorException(response.getError()));
                callback.exception(new PlatformErrorException(response.getError()));
            }
            callback.accept((String)response.getResult());
        })).exceptionally(throwable -> {
            this.exception(new Exception((Throwable)throwable));
            return null;
        });
    }

    private void exception(Exception e) {
        if (this.errorHandler != null) {
            this.errorHandler.exception(e);
        }
    }

    public static class Builder {
        private Caver caver;
        private KlayCredentials credentials;
        private int chainId = -1;
        private TransactionReceiptProcessor transactionReceiptProcessor;
        private ErrorHandler errorHandler;

        public Builder(Caver caver, KlayCredentials credentials) {
            this.credentials = credentials;
            this.caver = caver;
        }

        public Builder setChainId(int chainId) {
            this.chainId = chainId;
            return this;
        }

        public Builder setTransactionReceiptProcessor(TransactionReceiptProcessor transactionReceiptProcessor) {
            this.transactionReceiptProcessor = transactionReceiptProcessor;
            return this;
        }

        public Builder setErrorHandler(ErrorHandler errorHandler) {
            this.errorHandler = errorHandler;
            return this;
        }

        public FeePayerManager build() {
            if (this.chainId == -1) {
                this.chainId = ChainId.BAOBAB_TESTNET;
            }
            if (this.transactionReceiptProcessor == null) {
                this.transactionReceiptProcessor = new PollingTransactionReceiptProcessor(this.caver, 1000L, 15);
            }
            return new FeePayerManager(this);
        }
    }
}

