/*
 * Decompiled with CFR 0.152.
 */
package com.klaytn.caver.fee;

import com.klaytn.caver.crypto.KlayCredentials;
import com.klaytn.caver.crypto.KlaySignatureData;
import com.klaytn.caver.tx.model.KlayRawTransaction;
import com.klaytn.caver.tx.type.AbstractTxType;
import com.klaytn.caver.tx.type.TxTypeFeeDelegate;
import com.klaytn.caver.utils.BytesUtils;
import com.klaytn.caver.utils.KlaySignatureDataUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.web3j.crypto.ECKeyPair;
import org.web3j.crypto.Sign;
import org.web3j.rlp.RlpEncoder;
import org.web3j.rlp.RlpList;
import org.web3j.rlp.RlpString;
import org.web3j.rlp.RlpType;
import org.web3j.utils.Numeric;

@Deprecated
public class FeePayer {
    static final String EMPTY_FEE_PAYER_ADDRESS = "0x";
    private KlayCredentials credentials;
    private int chainId;

    public FeePayer(KlayCredentials credentials, int chainId) {
        this.credentials = credentials;
        this.chainId = chainId;
    }

    public KlayRawTransaction sign(TxTypeFeeDelegate txType) {
        Set<KlaySignatureData> feePayerSignatureDataSet = this.getFeePayerSignatureData(txType);
        ArrayList<RlpType> rlpTypeList = new ArrayList<RlpType>(txType.rlpValues());
        ArrayList<RlpList> senderSignatureList = new ArrayList<RlpList>();
        for (KlaySignatureData senderSignature : txType.getSenderSignatureDataSet()) {
            senderSignatureList.add(senderSignature.toRlpList());
        }
        rlpTypeList.add((RlpType)new RlpList(senderSignatureList));
        rlpTypeList.add((RlpType)RlpString.create((byte[])Numeric.hexStringToByteArray((String)this.credentials.getAddress())));
        ArrayList<RlpList> feePayerSignatureList = new ArrayList<RlpList>();
        String feePayer = txType.getFeePayer();
        if (!feePayer.equals(EMPTY_FEE_PAYER_ADDRESS)) {
            for (KlaySignatureData feePayerSignatureData : txType.getFeePayerSignatureData()) {
                feePayerSignatureList.add(feePayerSignatureData.toRlpList());
            }
        }
        for (KlaySignatureData feePayerSignatureData : feePayerSignatureDataSet) {
            feePayerSignatureList.add(feePayerSignatureData.toRlpList());
        }
        rlpTypeList.add((RlpType)new RlpList(feePayerSignatureList));
        byte[] encodedTransaction = RlpEncoder.encode((RlpType)new RlpList(rlpTypeList));
        byte[] type = new byte[]{txType.getType().get()};
        byte[] rawTx = BytesUtils.concat(type, encodedTransaction);
        return new KlayRawTransaction(rawTx, feePayerSignatureDataSet);
    }

    @Deprecated
    public KlaySignatureData getSignatureData(AbstractTxType txType) {
        KlaySignatureData signatureData = KlaySignatureData.createKlaySignatureDataFromChainId(this.chainId);
        byte[] encodedTransaction = txType.getEncodedTransactionNoSig();
        ArrayList<RlpString> rlpTypeList = new ArrayList<RlpString>();
        rlpTypeList.add(RlpString.create((byte[])encodedTransaction));
        rlpTypeList.add(RlpString.create((byte[])Numeric.hexStringToByteArray((String)this.credentials.getAddress())));
        rlpTypeList.addAll(signatureData.toRlpList().getValues());
        byte[] encodedTransaction2 = RlpEncoder.encode((RlpType)new RlpList(rlpTypeList));
        Sign.SignatureData signedSignatureData = Sign.signMessage((byte[])encodedTransaction2, (ECKeyPair)this.credentials.getEcKeyPair());
        return KlaySignatureDataUtils.createEip155KlaySignatureData(signedSignatureData, this.chainId);
    }

    private Set<KlaySignatureData> getFeePayerSignatureData(AbstractTxType txType) {
        KlaySignatureData signatureData = KlaySignatureData.createKlaySignatureDataFromChainId(this.chainId);
        HashSet<KlaySignatureData> feePayerSignatureDataSet = new HashSet<KlaySignatureData>();
        byte[] encodedTransactionNoSig = txType.getEncodedTransactionNoSig();
        ArrayList<RlpString> rlpTypeList = new ArrayList<RlpString>();
        rlpTypeList.add(RlpString.create((byte[])encodedTransactionNoSig));
        rlpTypeList.add(RlpString.create((byte[])Numeric.hexStringToByteArray((String)this.credentials.getAddress())));
        rlpTypeList.addAll(signatureData.toRlpList().getValues());
        byte[] encodedTransaction = RlpEncoder.encode((RlpType)new RlpList(rlpTypeList));
        for (ECKeyPair ecKeyPair : this.credentials.getEcKeyPairsForFeePayerList()) {
            Sign.SignatureData signedSignatureData = Sign.signMessage((byte[])encodedTransaction, (ECKeyPair)ecKeyPair);
            feePayerSignatureDataSet.add(KlaySignatureDataUtils.createEip155KlaySignatureData(signedSignatureData, this.chainId));
        }
        return feePayerSignatureDataSet;
    }
}

