/*
 * Decompiled with CFR 0.152.
 */
package com.klaytn.caver.contract;

import com.klaytn.caver.utils.Utils;
import java.math.BigInteger;
import org.web3j.utils.Numeric;

public class SendOptions {
    String from;
    String gas;
    String value = "0x0";

    public SendOptions() {
    }

    public SendOptions(String from) {
        this(from, (String)null);
    }

    public SendOptions(String from, String gas) {
        this(from, gas, "0x0");
    }

    public SendOptions(String from, BigInteger gas) {
        this(from, gas, BigInteger.ZERO);
    }

    public SendOptions(String from, String gas, String value) {
        this.setFrom(from);
        this.setGas(gas);
        this.setValue(value);
    }

    public SendOptions(String from, BigInteger gas, BigInteger value) {
        this.setFrom(from);
        this.setGas(gas);
        this.setValue(value);
    }

    public String getFrom() {
        return this.from;
    }

    public String getGas() {
        return this.gas;
    }

    public String getValue() {
        return this.value;
    }

    public void setFrom(String from) {
        if (from != null) {
            if (!Utils.isAddress(from)) {
                throw new IllegalArgumentException("Invalid address. : " + from);
            }
            this.from = from;
        }
    }

    public void setGas(String gas) {
        if (gas != null) {
            if (!Utils.isNumber(gas)) {
                throw new IllegalArgumentException("Invalid gas. : " + gas);
            }
            this.gas = gas;
        }
    }

    public void setGas(BigInteger gas) {
        if (gas != null) {
            this.setGas(Numeric.toHexStringWithPrefix((BigInteger)gas));
        }
    }

    public void setValue(String value) {
        if (value != null) {
            if (!Utils.isNumber(value)) {
                throw new IllegalArgumentException("Invalid value : " + value);
            }
            this.value = Numeric.prependHexPrefix((String)value);
        } else {
            this.value = "0x0";
        }
    }

    public void setValue(BigInteger value) {
        if (value != null) {
            this.setValue(Numeric.toHexStringWithPrefix((BigInteger)value));
        } else {
            this.value = "0x0";
        }
    }
}

