/*
 * Decompiled with CFR 0.152.
 */
package com.klaytn.caver.contract;

import com.klaytn.caver.Caver;
import com.klaytn.caver.abi.ABI;
import com.klaytn.caver.abi.datatypes.Type;
import com.klaytn.caver.contract.ContractIOType;
import com.klaytn.caver.contract.SendOptions;
import com.klaytn.caver.methods.request.CallObject;
import com.klaytn.caver.methods.response.Bytes;
import com.klaytn.caver.methods.response.Bytes32;
import com.klaytn.caver.methods.response.Quantity;
import com.klaytn.caver.methods.response.TransactionReceipt;
import com.klaytn.caver.transaction.response.PollingTransactionReceiptProcessor;
import com.klaytn.caver.transaction.response.TransactionReceiptProcessor;
import com.klaytn.caver.transaction.type.SmartContractExecution;
import com.klaytn.caver.utils.Utils;
import com.klaytn.caver.wallet.IWallet;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.web3j.protocol.exceptions.TransactionException;

public class ContractMethod {
    Caver caver;
    String type;
    String name;
    List<ContractIOType> inputs;
    List<ContractIOType> outputs;
    String signature;
    String contractAddress;
    SendOptions defaultSendOptions;
    IWallet wallet;
    List<ContractMethod> nextContractMethods = new ArrayList<ContractMethod>();
    private static final Logger LOGGER = LoggerFactory.getLogger(ContractMethod.class);

    public ContractMethod() {
    }

    public ContractMethod(Caver caver, String type, String name, List<ContractIOType> inputs, List<ContractIOType> outputs, String signature, String contractAddress) {
        this.caver = caver;
        this.type = type;
        this.name = name;
        this.inputs = inputs;
        this.outputs = outputs;
        this.signature = signature;
        this.contractAddress = contractAddress;
    }

    public List<Type> call(List<Object> arguments) throws IOException, ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        return this.call(arguments, CallObject.createCallObject());
    }

    public List<Type> call(List<Object> arguments, CallObject callObject) throws IOException, ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        ArrayList<Object> functionParams = new ArrayList<Object>();
        if (arguments != null) {
            functionParams.addAll(arguments);
        }
        ContractMethod matchedMethod = this.findMatchedInstance(functionParams);
        String encodedFunction = ABI.encodeFunctionCall(matchedMethod, functionParams);
        return this.callFunction(matchedMethod, encodedFunction, callObject);
    }

    public List<Type> callWithSolidityWrapper(List<Type> arguments) throws IOException, ClassNotFoundException {
        return this.callWithSolidityWrapper(arguments, CallObject.createCallObject());
    }

    public List<Type> callWithSolidityWrapper(List<Type> arguments, CallObject callObject) throws IOException, ClassNotFoundException {
        ArrayList<Type> functionParams = new ArrayList<Type>();
        if (arguments != null) {
            functionParams.addAll(arguments);
        }
        ContractMethod matchedMethod = this.findMatchedInstanceWithSolidityWrapper(functionParams);
        String encodedFunction = ABI.encodeFunctionCallWithSolidityWrapper(matchedMethod, functionParams);
        return this.callFunction(matchedMethod, encodedFunction, callObject);
    }

    public TransactionReceipt.TransactionReceiptData send(List<Object> arguments) throws IOException, TransactionException, ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        return this.send(arguments, null, new PollingTransactionReceiptProcessor(this.caver, 1000L, 15));
    }

    public TransactionReceipt.TransactionReceiptData send(List<Object> arguments, SendOptions options) throws IOException, TransactionException, ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        return this.send(arguments, options, new PollingTransactionReceiptProcessor(this.caver, 1000L, 15));
    }

    public TransactionReceipt.TransactionReceiptData send(List<Object> arguments, SendOptions options, TransactionReceiptProcessor processor) throws IOException, TransactionException, ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        ArrayList<Object> functionParams = new ArrayList<Object>();
        if (arguments != null) {
            functionParams.addAll(arguments);
        }
        ContractMethod matchedMethod = this.findMatchedInstance(functionParams);
        String encodedFunction = ABI.encodeFunctionCall(matchedMethod, functionParams);
        return this.sendTransaction(matchedMethod, options, encodedFunction, processor);
    }

    public TransactionReceipt.TransactionReceiptData sendWithSolidityWrapper(List<Type> wrapperArguments) throws IOException, TransactionException {
        return this.sendWithSolidityWrapper(wrapperArguments, null, new PollingTransactionReceiptProcessor(this.caver, 1000L, 15));
    }

    public TransactionReceipt.TransactionReceiptData sendWithSolidityWrapper(List<Type> wrapperArguments, SendOptions options) throws IOException, TransactionException {
        return this.sendWithSolidityWrapper(wrapperArguments, options, new PollingTransactionReceiptProcessor(this.caver, 1000L, 15));
    }

    public TransactionReceipt.TransactionReceiptData sendWithSolidityWrapper(List<Type> wrapperArguments, SendOptions options, TransactionReceiptProcessor processor) throws IOException, TransactionException {
        ArrayList<Type> functionParams = new ArrayList<Type>();
        if (wrapperArguments != null) {
            functionParams.addAll(wrapperArguments);
        }
        ContractMethod matchedMethod = this.findMatchedInstanceWithSolidityWrapper(functionParams);
        String encodedFunction = ABI.encodeFunctionCallWithSolidityWrapper(matchedMethod, functionParams);
        return this.sendTransaction(matchedMethod, options, encodedFunction, processor);
    }

    public String encodeABI(List<Object> arguments) throws ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        ArrayList<Object> functionParams = new ArrayList<Object>();
        if (arguments != null) {
            functionParams.addAll(arguments);
        }
        ContractMethod matchedMethod = this.findMatchedInstance(functionParams);
        return ABI.encodeFunctionCall(matchedMethod, arguments);
    }

    public String encodeABIWithSolidityWrapper(List<Type> wrapperArguments) {
        ArrayList<Type> functionParams = new ArrayList<Type>();
        if (wrapperArguments != null) {
            functionParams.addAll(wrapperArguments);
        }
        ContractMethod matchedMethod = this.findMatchedInstanceWithSolidityWrapper(functionParams);
        return ABI.encodeFunctionCallWithSolidityWrapper(matchedMethod, functionParams);
    }

    public String estimateGas(List<Object> arguments, CallObject callObject) throws IOException, ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        String encodedFunctionCall = this.encodeABI(arguments);
        return this.estimateGas(encodedFunctionCall, callObject);
    }

    public String estimateGasWithSolidityWrapper(List<Type> arguments, CallObject callObject) throws IOException {
        String encodedFunctionCall = this.encodeABIWithSolidityWrapper(arguments);
        return this.estimateGas(encodedFunctionCall, callObject);
    }

    public void checkTypeValid(List<Object> types) {
        if (types.size() != this.inputs.size()) {
            throw new IllegalArgumentException("Not matched passed parameter count.");
        }
    }

    public Caver getCaver() {
        return this.caver;
    }

    public String getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public List<ContractIOType> getInputs() {
        return this.inputs;
    }

    public List<ContractIOType> getOutputs() {
        return this.outputs;
    }

    public String getSignature() {
        return this.signature;
    }

    public String getContractAddress() {
        return this.contractAddress;
    }

    public SendOptions getDefaultSendOptions() {
        return this.defaultSendOptions;
    }

    public List<ContractMethod> getNextContractMethods() {
        return this.nextContractMethods;
    }

    void setCaver(Caver caver) {
        this.caver = caver;
    }

    void setType(String type) {
        this.type = type;
    }

    void setName(String name) {
        this.name = name;
    }

    void setInputs(List<ContractIOType> inputs) {
        this.inputs = inputs;
    }

    void setOutputs(List<ContractIOType> outputs) {
        this.outputs = outputs;
    }

    void setSignature(String signature) {
        this.signature = signature;
    }

    void setContractAddress(String contractAddress) {
        this.contractAddress = contractAddress;
        if (this.getNextContractMethods() != null && this.getNextContractMethods().size() != 0) {
            this.getNextContractMethods().stream().forEach(contractMethod -> {
                contractMethod.contractAddress = contractAddress;
            });
        }
    }

    void setDefaultSendOptions(SendOptions defaultSendOptions) {
        this.defaultSendOptions = defaultSendOptions;
    }

    public void setWallet(IWallet wallet) {
        this.wallet = wallet;
    }

    void setNextContractMethods(List<ContractMethod> nextContractMethods) {
        this.nextContractMethods = nextContractMethods;
    }

    public SendOptions makeSendOption(SendOptions sendOption) {
        SendOptions defaultSendOption = this.getDefaultSendOptions();
        String from = defaultSendOption.getFrom();
        String gas = defaultSendOption.getGas();
        String value = defaultSendOption.getValue();
        if (sendOption != null) {
            if (sendOption.getFrom() != null) {
                from = sendOption.getFrom();
            }
            if (sendOption.getGas() != null) {
                gas = sendOption.getGas();
            }
            if (!sendOption.getValue().equals("0x0")) {
                value = sendOption.getValue();
            }
        }
        return new SendOptions(from, gas, value);
    }

    private void checkSendOption(SendOptions options) {
        if (options.getFrom() == null || !Utils.isAddress(options.getFrom())) {
            throw new IllegalArgumentException("Invalid 'from' parameter : " + options.getFrom());
        }
        if (options.getGas() == null || !Utils.isNumber(options.getGas())) {
            throw new IllegalArgumentException("Invalid 'gas' parameter : " + options.getGas());
        }
        if (options.getValue() == null || !Utils.isNumber(options.getValue())) {
            throw new IllegalArgumentException("Invalid 'value' parameter : " + options.getValue());
        }
    }

    private ContractMethod findMatchedInstance(List arguments) {
        ArrayList<ContractMethod> matchedMethod = new ArrayList<ContractMethod>();
        if (this.getInputs().size() != arguments.size()) {
            for (ContractMethod method : this.getNextContractMethods()) {
                if (method.getInputs().size() != arguments.size()) continue;
                matchedMethod.add(method);
            }
        } else {
            matchedMethod.add(this);
        }
        if (matchedMethod.size() == 0) {
            throw new IllegalArgumentException("Cannot find method with passed parameters.");
        }
        if (matchedMethod.size() != 1) {
            LOGGER.warn("It found a two or more overloaded function that has same parameter counts. It may be abnormally executed. Please use *withSolidityWrapper().");
        }
        return (ContractMethod)matchedMethod.get(0);
    }

    private ContractMethod findMatchedInstanceWithSolidityWrapper(List<Type> arguments) {
        ContractMethod matchedMethod = null;
        if (this.checkParamsTypeMatched(arguments)) {
            matchedMethod = this;
        } else {
            for (ContractMethod method : this.getNextContractMethods()) {
                if (!method.checkParamsTypeMatched(arguments)) continue;
                matchedMethod = method;
            }
        }
        if (matchedMethod == null) {
            throw new IllegalArgumentException("Cannot find method with passed parameters.");
        }
        return matchedMethod;
    }

    private boolean checkParamsTypeMatched(List<Type> arguments) {
        if (this.getInputs().size() != arguments.size()) {
            return false;
        }
        for (int i = 0; i < this.getInputs().size(); ++i) {
            ContractIOType ioType = this.getInputs().get(i);
            if (ioType.getTypeAsString().equals(arguments.get(i).getTypeAsString())) continue;
            return false;
        }
        return true;
    }

    private TransactionReceipt.TransactionReceiptData sendTransaction(ContractMethod method, SendOptions options, String encodedInput, TransactionReceiptProcessor processor) throws IOException, TransactionException {
        SendOptions sendOptions = this.makeSendOption(options);
        this.checkSendOption(sendOptions);
        SmartContractExecution smartContractExecution = ((SmartContractExecution.Builder)((SmartContractExecution.Builder)((SmartContractExecution.Builder)new SmartContractExecution.Builder().setKlaytnCall(this.caver.rpc.klay)).setFrom(sendOptions.getFrom())).setTo(method.getContractAddress()).setInput(encodedInput).setGas(sendOptions.getGas())).setValue(sendOptions.getValue()).build();
        this.wallet.sign(sendOptions.getFrom(), smartContractExecution);
        Bytes32 response = (Bytes32)this.caver.rpc.klay.sendRawTransaction(smartContractExecution).send();
        if (response.hasError()) {
            throw new IOException(response.getError().getMessage());
        }
        TransactionReceipt.TransactionReceiptData receipt = processor.waitForTransactionReceipt((String)response.getResult());
        return receipt;
    }

    private List<Type> callFunction(ContractMethod method, String encodedInput, CallObject callObject) throws IOException, ClassNotFoundException {
        if (callObject.getData() != null || callObject.getTo() != null) {
            LOGGER.warn("'to' and 'data' field in CallObject will overwrite.");
        }
        callObject.setData(encodedInput);
        callObject.setTo(method.getContractAddress());
        Bytes response = (Bytes)this.caver.rpc.klay.call(callObject).send();
        if (response.hasError()) {
            throw new IOException(response.getError().getMessage());
        }
        String encodedResult = (String)response.getResult();
        return ABI.decodeParameters(method, encodedResult);
    }

    private String estimateGas(String encodedFunctionCall, CallObject callObject) throws IOException {
        if (callObject.getData() != null || callObject.getTo() != null) {
            LOGGER.warn("The 'to' and 'data' fields of the CallObject will be overwritten.");
        }
        callObject.setData(encodedFunctionCall);
        callObject.setTo(this.getContractAddress());
        Quantity estimateGas = (Quantity)this.caver.rpc.klay.estimateGas(callObject).send();
        if (estimateGas.hasError()) {
            throw new IOException(estimateGas.getError().getMessage());
        }
        return (String)estimateGas.getResult();
    }
}

