/*
 * Decompiled with CFR 0.152.
 */
package com.klaytn.caver.account;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

public class WeightedMultiSigOptions {
    public static final int MAX_COUNT_WEIGHTED_PUBLIC_KEY = 10;
    private BigInteger threshold;
    private List<BigInteger> weights;

    public WeightedMultiSigOptions() {
    }

    public WeightedMultiSigOptions(BigInteger threshold, List<BigInteger> weights) {
        if (!this.isValidateOptions(threshold, weights)) {
            throw new IllegalArgumentException("Invalid argument in passing params.");
        }
        this.threshold = threshold;
        this.weights = weights;
    }

    public static WeightedMultiSigOptions getDefaultOptionsForWeightedMultiSig(String[] publicKeyArr) {
        BigInteger threshold = BigInteger.ONE;
        ArrayList<BigInteger> weights = new ArrayList<BigInteger>();
        for (int i = 0; i < publicKeyArr.length; ++i) {
            weights.add(BigInteger.ONE);
        }
        return new WeightedMultiSigOptions(threshold, weights);
    }

    public static List<WeightedMultiSigOptions> getDefaultOptionsForRoleBased(List<String[]> roleBasedPublicKeys) {
        ArrayList<WeightedMultiSigOptions> optionList = new ArrayList<WeightedMultiSigOptions>();
        for (int i = 0; i < roleBasedPublicKeys.size(); ++i) {
            WeightedMultiSigOptions option = roleBasedPublicKeys.get(i).length == 1 ? new WeightedMultiSigOptions() : WeightedMultiSigOptions.getDefaultOptionsForWeightedMultiSig(roleBasedPublicKeys.get(i));
            optionList.add(option);
        }
        return optionList;
    }

    public boolean isValidateOptions(BigInteger threshold, List<BigInteger> weights) {
        BigInteger sumOfWeights = BigInteger.ZERO;
        if (threshold.compareTo(BigInteger.ZERO) <= 0) {
            return false;
        }
        if (weights.size() > 10) {
            return false;
        }
        for (BigInteger weight : weights) {
            sumOfWeights = sumOfWeights.add(weight);
        }
        return threshold.compareTo(sumOfWeights) <= 0;
    }

    public boolean isEmpty() {
        return this.getWeights() == null && this.threshold == null;
    }

    public BigInteger getThreshold() {
        return this.threshold;
    }

    public List<BigInteger> getWeights() {
        return this.weights;
    }
}

