/*
 * Decompiled with CFR 0.152.
 */
package com.klaytn.caver.account;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.klaytn.caver.account.AccountKeyDecoder;
import com.klaytn.caver.account.AccountKeyFail;
import com.klaytn.caver.account.AccountKeyLegacy;
import com.klaytn.caver.account.AccountKeyNil;
import com.klaytn.caver.account.AccountKeyPublic;
import com.klaytn.caver.account.AccountKeyWeightedMultiSig;
import com.klaytn.caver.account.IAccountKey;
import com.klaytn.caver.account.WeightedMultiSigOptions;
import com.klaytn.caver.utils.BytesUtils;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.web3j.protocol.ObjectMapperFactory;
import org.web3j.rlp.RlpDecoder;
import org.web3j.rlp.RlpEncoder;
import org.web3j.rlp.RlpList;
import org.web3j.rlp.RlpString;
import org.web3j.rlp.RlpType;
import org.web3j.utils.Numeric;

@JsonDeserialize(using=AccountKeyRoleBasedDeserializer.class)
@JsonSerialize(using=AccountKeyRoleBasedSerializer.class)
public class AccountKeyRoleBased
implements IAccountKey {
    private static final String TYPE = "0x05";
    public static final int ROLE_GROUP_COUNT = RoleGroup.values().length;
    private List<IAccountKey> accountKeys;

    public AccountKeyRoleBased(List<IAccountKey> accountKeys) {
        this.setAccountKeys(accountKeys);
    }

    public static AccountKeyRoleBased decode(String rlpEncodedKey) {
        return AccountKeyRoleBased.decode(Numeric.hexStringToByteArray((String)rlpEncodedKey));
    }

    public static AccountKeyRoleBased decode(byte[] rlpEncodedKey) {
        byte type = Numeric.hexStringToByteArray((String)AccountKeyRoleBased.getType())[0];
        if (rlpEncodedKey[0] != type) {
            throw new IllegalArgumentException("Invalid RLP-encoded AccountKeyRoleBased Tag");
        }
        ArrayList<IAccountKey> accountKeys = new ArrayList<IAccountKey>();
        byte[] encodedKey = Arrays.copyOfRange(rlpEncodedKey, 1, rlpEncodedKey.length);
        RlpList rlpList = RlpDecoder.decode((byte[])encodedKey);
        List values = ((RlpList)rlpList.getValues().get(0)).getValues();
        for (RlpType value : values) {
            accountKeys.add(AccountKeyDecoder.decode(((RlpString)value).asString()));
        }
        return new AccountKeyRoleBased(accountKeys);
    }

    public static AccountKeyRoleBased fromRoleBasedPublicKeysAndOptions(List<String[]> pubArray, List<WeightedMultiSigOptions> options) {
        ArrayList<IAccountKey> accountKeys = new ArrayList<IAccountKey>();
        if (pubArray.size() > ROLE_GROUP_COUNT) {
            throw new IllegalArgumentException("pubArray must have up to three items");
        }
        if (options.size() != pubArray.size()) {
            throw new IllegalArgumentException("pubArray and options must have the same number of items.");
        }
        for (int i = 0; i < pubArray.size(); ++i) {
            String[] publicKeyArr = pubArray.get(i);
            WeightedMultiSigOptions weightedMultiSigOption = options.get(i);
            if (publicKeyArr == null) {
                throw new RuntimeException("Invalid publicKey format");
            }
            if (publicKeyArr.length == 0) {
                if (!weightedMultiSigOption.isEmpty()) {
                    throw new RuntimeException("Invalid options: AccountKeyNil cannot have options.");
                }
                accountKeys.add(new AccountKeyNil());
                continue;
            }
            if (publicKeyArr.length == 1 && weightedMultiSigOption.isEmpty()) {
                if (publicKeyArr[0].equals("legacy")) {
                    accountKeys.add(new AccountKeyLegacy());
                    continue;
                }
                if (publicKeyArr[0].equals("fail")) {
                    accountKeys.add(new AccountKeyFail());
                    continue;
                }
                accountKeys.add(AccountKeyPublic.fromPublicKey(publicKeyArr[0]));
                continue;
            }
            if (weightedMultiSigOption.isEmpty()) {
                throw new RuntimeException("Invalid options : AccountKeyWeightedMultiSig must have options");
            }
            accountKeys.add(AccountKeyWeightedMultiSig.fromPublicKeysAndOptions(publicKeyArr, weightedMultiSigOption));
        }
        return new AccountKeyRoleBased(accountKeys);
    }

    public List<IAccountKey> getAccountKeys() {
        return this.accountKeys;
    }

    public void setAccountKeys(List<IAccountKey> accountKeys) {
        if (accountKeys.size() > ROLE_GROUP_COUNT) {
            throw new RuntimeException("It exceeds maximum role based key count.");
        }
        this.accountKeys = accountKeys;
    }

    @Override
    public String getRLPEncoding() {
        ArrayList<RlpString> rlpTypeList = new ArrayList<RlpString>();
        for (IAccountKey accountKey : this.accountKeys) {
            byte[] encodedData = Numeric.hexStringToByteArray((String)accountKey.getRLPEncoding());
            rlpTypeList.add(RlpString.create((byte[])encodedData));
        }
        byte[] encodedRoleBasedKey = RlpEncoder.encode((RlpType)new RlpList(rlpTypeList));
        byte[] type = Numeric.hexStringToByteArray((String)AccountKeyRoleBased.getType());
        return Numeric.toHexString((byte[])BytesUtils.concat(type, encodedRoleBasedKey));
    }

    public static String getType() {
        return TYPE;
    }

    public IAccountKey getRoleTransactionKey() {
        return this.getAccountKeys().get(RoleGroup.TRANSACTION.getIndex());
    }

    public IAccountKey getRoleAccountUpdateKey() {
        return this.getAccountKeys().get(RoleGroup.ACCOUNT_UPDATE.getIndex());
    }

    public IAccountKey getRoleFeePayerKey() {
        return this.getAccountKeys().get(RoleGroup.FEE_PAYER.getIndex());
    }

    public static class AccountKeyRoleBasedDeserializer
    extends JsonDeserializer<AccountKeyRoleBased> {
        private static ObjectMapper objectMapper = ObjectMapperFactory.getObjectMapper();

        public static IAccountKey decode(JsonNode accountKeyJson) throws IOException {
            String type = Numeric.toHexStringWithPrefixZeroPadded((BigInteger)accountKeyJson.get("keyType").bigIntegerValue(), (int)2);
            IAccountKey accountKey = null;
            accountKey = type.equals(AccountKeyPublic.getType()) ? (IAccountKey)objectMapper.readValue(accountKeyJson.toString(), AccountKeyPublic.class) : (type.equals(AccountKeyWeightedMultiSig.getType()) ? (IAccountKey)objectMapper.readValue(accountKeyJson.toString(), AccountKeyWeightedMultiSig.class) : (type.equals(AccountKeyLegacy.getType()) ? new AccountKeyLegacy() : (type.equals(AccountKeyFail.getType()) ? new AccountKeyFail() : new AccountKeyNil())));
            return accountKey;
        }

        public AccountKeyRoleBased deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            JsonNode root = (JsonNode)p.getCodec().readTree(p);
            String type = Numeric.toHexStringWithPrefixZeroPadded((BigInteger)root.get("keyType").bigIntegerValue(), (int)2);
            JsonNode key = root.get("key");
            Iterator iterator = key.iterator();
            ArrayList<IAccountKey> accountKeyList = new ArrayList<IAccountKey>();
            while (iterator.hasNext()) {
                JsonNode node = (JsonNode)iterator.next();
                IAccountKey accountKey = AccountKeyRoleBasedDeserializer.decode(node);
                accountKeyList.add(accountKey);
            }
            return new AccountKeyRoleBased(accountKeyList);
        }
    }

    public static class AccountKeyRoleBasedSerializer
    extends JsonSerializer<AccountKeyRoleBased> {
        public void serialize(AccountKeyRoleBased accountKeyRoleBased, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonProcessingException {
            jsonGenerator.writeStartObject();
            jsonGenerator.writeFieldName("keyType");
            jsonGenerator.writeNumber(Numeric.toBigInt((String)AccountKeyRoleBased.getType()));
            jsonGenerator.writeArrayFieldStart("key");
            for (IAccountKey accountKey : accountKeyRoleBased.getAccountKeys()) {
                jsonGenerator.writeObject((Object)accountKey);
            }
            jsonGenerator.writeEndArray();
            jsonGenerator.writeEndObject();
        }
    }

    public static enum RoleGroup {
        TRANSACTION(0),
        ACCOUNT_UPDATE(1),
        FEE_PAYER(2);

        private int groupIndex;

        private RoleGroup(int groupIndex) {
            this.groupIndex = groupIndex;
        }

        public int getIndex() {
            return this.groupIndex;
        }
    }
}

