/*
 * Decompiled with CFR 0.152.
 */
package com.klaytn.caver.account;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.klaytn.caver.account.IAccountKey;
import com.klaytn.caver.utils.AccountKeyPublicUtils;
import com.klaytn.caver.utils.BytesUtils;
import com.klaytn.caver.utils.Utils;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Arrays;
import org.web3j.rlp.RlpDecoder;
import org.web3j.rlp.RlpEncoder;
import org.web3j.rlp.RlpList;
import org.web3j.rlp.RlpString;
import org.web3j.rlp.RlpType;
import org.web3j.utils.Numeric;

@JsonDeserialize(using=AccountKeyPublicDeserializer.class)
@JsonSerialize(using=AccountKeyPublicSerializer.class)
public class AccountKeyPublic
implements IAccountKey {
    private static final String TYPE = "0x02";
    private String publicKey;
    public static final int OFFSET_X_POINT = 0;
    public static final int OFFSET_Y_POINT = 1;

    public AccountKeyPublic(String publicKey) {
        this.setPublicKey(publicKey);
    }

    public static AccountKeyPublic fromXYPoint(String x, String y) {
        String xPoint_padded = Numeric.toHexStringWithPrefixZeroPadded((BigInteger)Numeric.toBigInt((String)x), (int)64);
        String yPoint_padded = Numeric.toHexStringWithPrefixZeroPadded((BigInteger)Numeric.toBigInt((String)y), (int)64);
        String publicKey = Numeric.prependHexPrefix((String)xPoint_padded) + Numeric.cleanHexPrefix((String)yPoint_padded);
        return new AccountKeyPublic(publicKey);
    }

    public static AccountKeyPublic fromPublicKey(String publicKey) {
        return new AccountKeyPublic(publicKey);
    }

    public static AccountKeyPublic decode(String rlpEncodedKey) {
        return AccountKeyPublic.decode(Numeric.hexStringToByteArray((String)rlpEncodedKey));
    }

    public static AccountKeyPublic decode(byte[] rlpEncodedKey) {
        byte type = Numeric.hexStringToByteArray((String)AccountKeyPublic.getType())[0];
        if (rlpEncodedKey[0] != type) {
            throw new IllegalArgumentException("Invalid RLP-encoded AccountKeyPublic Tag");
        }
        byte[] encodedPublicKey = Arrays.copyOfRange(rlpEncodedKey, 1, rlpEncodedKey.length);
        RlpList rlpList = RlpDecoder.decode((byte[])encodedPublicKey);
        String compressedPubKey = ((RlpString)rlpList.getValues().get(0)).asString();
        try {
            String publicKey = Utils.decompressPublicKey(compressedPubKey);
            return new AccountKeyPublic(publicKey);
        }
        catch (Exception e) {
            throw new RuntimeException("There is an error while decoding process.");
        }
    }

    @Override
    public String getRLPEncoding() {
        String compressedKey = Utils.compressPublicKey(this.publicKey);
        byte[] encodedPubKey = RlpEncoder.encode((RlpType)RlpString.create((byte[])Numeric.hexStringToByteArray((String)compressedKey)));
        byte[] type = Numeric.hexStringToByteArray((String)AccountKeyPublic.getType());
        return Numeric.toHexString((byte[])BytesUtils.concat(type, encodedPubKey));
    }

    public String[] getXYPoint() {
        String key = this.getPublicKey();
        if (AccountKeyPublicUtils.isCompressedPublicKey(this.getPublicKey())) {
            key = Utils.decompressPublicKey(this.getPublicKey());
        }
        String noPrefixKeyStr = Numeric.cleanHexPrefix((String)key);
        String[] arr = new String[]{noPrefixKeyStr.substring(0, 64), noPrefixKeyStr.substring(64)};
        return arr;
    }

    public String getPublicKey() {
        return this.publicKey;
    }

    public static String getType() {
        return TYPE;
    }

    public void setPublicKey(String publicKey) {
        if (!Utils.isValidPublicKey(publicKey)) {
            throw new RuntimeException("Invalid Public Key format");
        }
        this.publicKey = publicKey;
    }

    public static class AccountKeyPublicDeserializer
    extends JsonDeserializer<AccountKeyPublic> {
        public AccountKeyPublic deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            JsonNode node = (JsonNode)p.getCodec().readTree(p);
            byte type = (byte)node.get("keyType").intValue();
            JsonNode key = node.get("key");
            String x = key.get("x").asText();
            String y = key.get("y").asText();
            return AccountKeyPublic.fromXYPoint(x, y);
        }
    }

    public static class AccountKeyPublicSerializer
    extends JsonSerializer<AccountKeyPublic> {
        public void serialize(AccountKeyPublic accountKeyPublic, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonProcessingException {
            jsonGenerator.writeStartObject();
            jsonGenerator.writeFieldName("keyType");
            jsonGenerator.writeNumber(Numeric.toBigInt((String)AccountKeyPublic.getType()));
            String[] xy = accountKeyPublic.getXYPoint();
            jsonGenerator.writeFieldName("key");
            jsonGenerator.writeStartObject();
            jsonGenerator.writeStringField("x", Utils.addHexPrefix(xy[0]));
            jsonGenerator.writeStringField("y", Utils.addHexPrefix(xy[1]));
            jsonGenerator.writeEndObject();
            jsonGenerator.writeEndObject();
        }
    }
}

