/*
 * Decompiled with CFR 0.152.
 */
package com.klaytn.caver.account;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.klaytn.caver.account.IAccountKey;
import java.io.IOException;
import org.web3j.utils.Numeric;

@JsonSerialize(using=AccountKeyNilSerializer.class)
public class AccountKeyNil
implements IAccountKey {
    private static final byte[] RLP = new byte[]{-128};

    public static AccountKeyNil decode(String rlpEncodedKey) {
        return AccountKeyNil.decode(Numeric.hexStringToByteArray((String)rlpEncodedKey));
    }

    public static AccountKeyNil decode(byte[] rlpEncodedKey) {
        if (rlpEncodedKey.length != 1 || rlpEncodedKey[0] != RLP[0]) {
            throw new IllegalArgumentException("Invalid RLP-encoded AccountKeyNil");
        }
        return new AccountKeyNil();
    }

    @Override
    public String getRLPEncoding() {
        return Numeric.toHexString((byte[])RLP);
    }

    public static String getType() {
        return Numeric.toHexString((byte[])RLP);
    }

    public static class AccountKeyNilSerializer
    extends JsonSerializer<AccountKeyNil> {
        public void serialize(AccountKeyNil value, JsonGenerator gen, SerializerProvider serializers) throws IOException, JsonProcessingException {
            gen.writeStartObject();
            gen.writeFieldName("keyType");
            gen.writeNumber(0);
            gen.writeFieldName("key");
            gen.writeStartObject();
            gen.writeEndObject();
            gen.writeEndObject();
        }
    }
}

