/*
 * Decompiled with CFR 0.152.
 */
package com.klaytn.caver.account;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.klaytn.caver.account.IAccountKey;
import java.io.IOException;
import java.util.Arrays;
import org.web3j.utils.Numeric;

@JsonSerialize(using=AccountKeyFailSerializer.class)
public class AccountKeyFail
implements IAccountKey {
    private static final byte[] RLP = new byte[]{3, -64};
    private static final String TYPE = "0x03";

    public static AccountKeyFail decode(String rlpEncodedKey) {
        return AccountKeyFail.decode(Numeric.hexStringToByteArray((String)rlpEncodedKey));
    }

    public static AccountKeyFail decode(byte[] rlpEncodedKey) {
        if (!Arrays.equals(rlpEncodedKey, RLP)) {
            throw new RuntimeException("Invalid RLP-encoded account key String");
        }
        return new AccountKeyFail();
    }

    @Override
    public String getRLPEncoding() {
        return Numeric.toHexString((byte[])RLP);
    }

    public static String getType() {
        return TYPE;
    }

    public static class AccountKeyFailSerializer
    extends JsonSerializer<AccountKeyFail> {
        public void serialize(AccountKeyFail value, JsonGenerator gen, SerializerProvider serializers) throws IOException, JsonProcessingException {
            gen.writeStartObject();
            gen.writeFieldName("keyType");
            gen.writeNumber(Numeric.toBigInt((String)AccountKeyFail.getType()));
            gen.writeFieldName("key");
            gen.writeStartObject();
            gen.writeEndObject();
            gen.writeEndObject();
        }
    }
}

