/*
 * Decompiled with CFR 0.152.
 */
package com.klaytn.caver.account;

import com.klaytn.caver.account.AccountKeyFail;
import com.klaytn.caver.account.AccountKeyLegacy;
import com.klaytn.caver.account.AccountKeyNil;
import com.klaytn.caver.account.AccountKeyPublic;
import com.klaytn.caver.account.AccountKeyRoleBased;
import com.klaytn.caver.account.AccountKeyWeightedMultiSig;
import com.klaytn.caver.account.IAccountKey;
import org.web3j.utils.Numeric;

public class AccountKeyDecoder {
    public static IAccountKey decode(String rlpEncodedKey) {
        String hexPrefixEncoded = Numeric.prependHexPrefix((String)rlpEncodedKey);
        if (hexPrefixEncoded.startsWith(AccountKeyFail.getType())) {
            return AccountKeyFail.decode(hexPrefixEncoded);
        }
        if (hexPrefixEncoded.startsWith(AccountKeyLegacy.getType())) {
            return AccountKeyLegacy.decode(hexPrefixEncoded);
        }
        if (hexPrefixEncoded.startsWith(AccountKeyPublic.getType())) {
            return AccountKeyPublic.decode(hexPrefixEncoded);
        }
        if (hexPrefixEncoded.startsWith(AccountKeyWeightedMultiSig.getType())) {
            return AccountKeyWeightedMultiSig.decode(hexPrefixEncoded);
        }
        if (hexPrefixEncoded.startsWith(AccountKeyRoleBased.getType())) {
            return AccountKeyRoleBased.decode(hexPrefixEncoded);
        }
        if (hexPrefixEncoded.startsWith(AccountKeyNil.getType())) {
            return AccountKeyNil.decode(hexPrefixEncoded);
        }
        throw new RuntimeException("Invalid RLP-encoded account key string");
    }
}

