/*
 * Decompiled with CFR 0.152.
 */
package com.klaytn.caver.abi;

import com.klaytn.caver.abi.TypeDecoder;
import com.klaytn.caver.abi.datatypes.AbiTypes;
import com.klaytn.caver.abi.datatypes.DynamicArray;
import com.klaytn.caver.abi.datatypes.DynamicStruct;
import com.klaytn.caver.abi.datatypes.StaticArray;
import com.klaytn.caver.abi.datatypes.StaticStruct;
import com.klaytn.caver.abi.datatypes.Type;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class TypeReference<T extends Type>
implements Comparable<TypeReference<T>> {
    protected static Pattern ARRAY_SUFFIX = Pattern.compile("\\[(\\d*)]");
    private final java.lang.reflect.Type type;
    private final boolean indexed;

    protected TypeReference() {
        this(false);
    }

    protected TypeReference(boolean indexed) {
        java.lang.reflect.Type superclass = this.getClass().getGenericSuperclass();
        if (superclass instanceof Class) {
            throw new RuntimeException("Missing type parameter.");
        }
        this.type = ((ParameterizedType)superclass).getActualTypeArguments()[0];
        this.indexed = indexed;
    }

    TypeReference getSubTypeReference() {
        return null;
    }

    @Override
    public int compareTo(TypeReference<T> o) {
        return 0;
    }

    public java.lang.reflect.Type getType() {
        return this.type;
    }

    public boolean isIndexed() {
        return this.indexed;
    }

    public Class<T> getClassType() throws ClassNotFoundException {
        java.lang.reflect.Type clsType = this.getType();
        if (this.getType() instanceof ParameterizedType) {
            return (Class)((ParameterizedType)clsType).getRawType();
        }
        return Class.forName(clsType.getTypeName());
    }

    public static <T extends Type> TypeReference<T> create(Class<T> cls) {
        return TypeReference.create(cls, false);
    }

    public static <T extends Type> TypeReference<T> create(final Class<T> cls, boolean indexed) {
        return new TypeReference<T>(indexed){

            @Override
            public java.lang.reflect.Type getType() {
                return cls;
            }
        };
    }

    protected static Class<? extends Type> getAtomicTypeClass(String solidityType, boolean primitives) throws ClassNotFoundException {
        if (ARRAY_SUFFIX.matcher(solidityType).find()) {
            throw new ClassNotFoundException("getAtomicTypeClass does not work with array types. See makeTypeReference()");
        }
        return AbiTypes.getType(solidityType, primitives);
    }

    public static TypeReference makeTypeReference(String solidityType) throws ClassNotFoundException {
        return TypeReference.makeTypeReference(solidityType, false, false);
    }

    public static TypeReference makeTypeReference(String solidityType, final boolean indexed, boolean primitives) throws ClassNotFoundException {
        TypeReference arrayWrappedType;
        if (TypeReference.isAtomicTypeString(solidityType)) {
            if (solidityType.contains("tuple")) {
                return TypeReference.makeStructTypeReference(solidityType);
            }
            Class<Type> typeClass = TypeReference.getAtomicTypeClass(solidityType, primitives);
            return TypeReference.create(typeClass, indexed);
        }
        Matcher nextSquareBrackets = ARRAY_SUFFIX.matcher(solidityType);
        nextSquareBrackets.find();
        int lastReadStringPosition = nextSquareBrackets.start();
        if (solidityType.contains("tuple")) {
            int index = solidityType.lastIndexOf(41);
            String baseType = solidityType.substring(0, index + 1);
            arrayWrappedType = TypeReference.makeStructTypeReference(baseType);
            lastReadStringPosition = index + 1;
            nextSquareBrackets.find(lastReadStringPosition);
        } else {
            String baseType = solidityType.substring(0, lastReadStringPosition);
            Class<Type> baseClass = TypeReference.getAtomicTypeClass(baseType, primitives);
            arrayWrappedType = TypeReference.create(baseClass, indexed);
        }
        int len = solidityType.length();
        while (lastReadStringPosition < len) {
            String arraySize = nextSquareBrackets.group(1);
            final TypeReference baseTr = arrayWrappedType;
            if (arraySize == null || arraySize.equals("")) {
                arrayWrappedType = new TypeReference<DynamicArray>(indexed){

                    @Override
                    TypeReference getSubTypeReference() {
                        return baseTr;
                    }

                    @Override
                    public java.lang.reflect.Type getType() {
                        return new ParameterizedType(){

                            @Override
                            public java.lang.reflect.Type[] getActualTypeArguments() {
                                return new java.lang.reflect.Type[]{baseTr.getType()};
                            }

                            @Override
                            public java.lang.reflect.Type getRawType() {
                                return DynamicArray.class;
                            }

                            @Override
                            public java.lang.reflect.Type getOwnerType() {
                                return Class.class;
                            }
                        };
                    }
                };
            } else {
                int arraySizeInt = Integer.parseInt(arraySize);
                final Class arrayclass = arraySizeInt <= 32 ? Class.forName("com.klaytn.caver.abi.datatypes.generated.StaticArray" + arraySize) : StaticArray.class;
                arrayWrappedType = new StaticArrayTypeReference<StaticArray>(arraySizeInt){

                    @Override
                    TypeReference getSubTypeReference() {
                        return baseTr;
                    }

                    @Override
                    public boolean isIndexed() {
                        return indexed;
                    }

                    @Override
                    public java.lang.reflect.Type getType() {
                        return new ParameterizedType(){

                            @Override
                            public java.lang.reflect.Type[] getActualTypeArguments() {
                                return new java.lang.reflect.Type[]{baseTr.getType()};
                            }

                            @Override
                            public java.lang.reflect.Type getRawType() {
                                return arrayclass;
                            }

                            @Override
                            public java.lang.reflect.Type getOwnerType() {
                                return Class.class;
                            }
                        };
                    }
                };
            }
            lastReadStringPosition = nextSquareBrackets.end();
            nextSquareBrackets = ARRAY_SUFFIX.matcher(solidityType);
            if (nextSquareBrackets.find(lastReadStringPosition) || lastReadStringPosition == len) continue;
            throw new ClassNotFoundException("Unable to make TypeReference from " + solidityType);
        }
        return arrayWrappedType;
    }

    public static TypeReference makeStructTypeReference(String tupleString) throws ClassNotFoundException {
        ArrayList<TypeReference> typeReferences = new ArrayList<TypeReference>();
        List<String> components = TypeReference.splitComponent(tupleString);
        boolean hasDynamic = false;
        for (int i = 0; i < components.size(); ++i) {
            TypeReference reference = TypeReference.makeTypeReference(components.get(i));
            typeReferences.add(reference);
            if (!TypeDecoder.isDynamic(reference)) continue;
            hasDynamic = true;
        }
        if (hasDynamic) {
            return new StructTypeReference<DynamicStruct>(typeReferences){

                @Override
                public java.lang.reflect.Type getType() {
                    return DynamicStruct.class;
                }
            };
        }
        return new StructTypeReference<StaticStruct>(typeReferences){

            @Override
            public java.lang.reflect.Type getType() {
                return StaticStruct.class;
            }
        };
    }

    private static List<String> splitComponent(String tupleString) {
        String component = tupleString.substring(6, tupleString.length() - 1);
        ArrayList<String> array = new ArrayList<String>();
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < component.length(); ++i) {
            char a = component.charAt(i);
            if (a == 't' && component.startsWith("tuple", i)) {
                int endIndex = TypeReference.findTupleEndIndex(component, i);
                builder.append(component.substring(i, endIndex + 1));
                i = endIndex;
            } else if (a == ',') {
                array.add(builder.toString());
                builder.setLength(0);
            } else {
                builder.append(a);
            }
            if (i != component.length() - 1) continue;
            array.add(builder.toString());
            builder.setLength(0);
        }
        return array;
    }

    private static int findTupleEndIndex(String subString, int startIndex) {
        int depth = 0;
        int endIndex = 0;
        for (int i = startIndex; i < subString.length(); ++i) {
            char a = subString.charAt(i);
            if (a == '(') {
                ++depth;
                continue;
            }
            if (a != ')' || --depth != 0) continue;
            endIndex = i;
            break;
        }
        return endIndex;
    }

    private static boolean isAtomicTypeString(String solidityType) {
        boolean isTupleArray = solidityType.startsWith("tuple") && solidityType.charAt(solidityType.length() - 1) == ']';
        Matcher nextSquareBrackets = ARRAY_SUFFIX.matcher(solidityType);
        if (!nextSquareBrackets.find()) {
            return true;
        }
        return solidityType.startsWith("tuple") && !isTupleArray;
    }

    public static abstract class StaticArrayTypeReference<T extends Type>
    extends TypeReference<T> {
        private final int size;

        protected StaticArrayTypeReference(int size) {
            this.size = size;
        }

        public int getSize() {
            return this.size;
        }
    }

    public static abstract class StructTypeReference<T extends Type>
    extends TypeReference<T> {
        private List<TypeReference> typeList;

        public StructTypeReference(List<TypeReference> typeList) {
            this.typeList = typeList;
        }

        public List<TypeReference> getTypeList() {
            return this.typeList;
        }
    }
}

