/*
 * Decompiled with CFR 0.152.
 */
package com.klaytn.caver.abi;

import com.klaytn.caver.abi.DefaultFunctionReturnDecoder;
import com.klaytn.caver.abi.TypeReference;
import com.klaytn.caver.abi.Utils;
import com.klaytn.caver.abi.datatypes.AbiTypes;
import com.klaytn.caver.abi.datatypes.Address;
import com.klaytn.caver.abi.datatypes.Array;
import com.klaytn.caver.abi.datatypes.Bool;
import com.klaytn.caver.abi.datatypes.Bytes;
import com.klaytn.caver.abi.datatypes.BytesType;
import com.klaytn.caver.abi.datatypes.DynamicArray;
import com.klaytn.caver.abi.datatypes.DynamicBytes;
import com.klaytn.caver.abi.datatypes.DynamicStruct;
import com.klaytn.caver.abi.datatypes.Fixed;
import com.klaytn.caver.abi.datatypes.FixedPointType;
import com.klaytn.caver.abi.datatypes.Int;
import com.klaytn.caver.abi.datatypes.IntType;
import com.klaytn.caver.abi.datatypes.NumericType;
import com.klaytn.caver.abi.datatypes.StaticArray;
import com.klaytn.caver.abi.datatypes.StaticStruct;
import com.klaytn.caver.abi.datatypes.StructType;
import com.klaytn.caver.abi.datatypes.Type;
import com.klaytn.caver.abi.datatypes.Ufixed;
import com.klaytn.caver.abi.datatypes.Uint;
import com.klaytn.caver.abi.datatypes.Utf8String;
import com.klaytn.caver.abi.datatypes.generated.Uint160;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.BiFunction;
import org.web3j.utils.Numeric;

public class TypeDecoder {
    static final int MAX_BYTE_LENGTH_FOR_HEX_STRING = 64;

    public static Type instantiateType(String solidityType, Object value) throws InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException, ClassNotFoundException {
        return TypeDecoder.instantiateType(TypeReference.makeTypeReference(solidityType), value);
    }

    public static Type instantiateType(TypeReference ref, Object value) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException, ClassNotFoundException {
        Class rc = ref.getClassType();
        if (Array.class.isAssignableFrom(rc)) {
            if (StructType.class.isAssignableFrom(rc)) {
                return TypeDecoder.instantiateStructType(ref, value);
            }
            return TypeDecoder.instantiateArrayType(ref, value);
        }
        return TypeDecoder.instantiateAtomicType(rc, value);
    }

    public static <T extends Array> T decode(String input, int offset, TypeReference<T> typeReference) {
        Class<?> cls = ((ParameterizedType)typeReference.getType()).getRawType().getClass();
        if (StaticArray.class.isAssignableFrom(cls)) {
            return (T)((Array)TypeDecoder.decodeStaticArray(input, offset, typeReference, 1));
        }
        if (DynamicArray.class.isAssignableFrom(cls)) {
            return (T)((Array)TypeDecoder.decodeDynamicArray(input, offset, typeReference));
        }
        throw new UnsupportedOperationException("Unsupported TypeReference: " + cls.getName() + ", only Array types can be passed as TypeReferences");
    }

    static <T extends Type> T decode(String input, int offset, Class<T> type) {
        if (NumericType.class.isAssignableFrom(type)) {
            return TypeDecoder.decodeNumeric(input.substring(offset), type);
        }
        if (Address.class.isAssignableFrom(type)) {
            return (T)TypeDecoder.decodeAddress(input.substring(offset));
        }
        if (Bool.class.isAssignableFrom(type)) {
            return (T)TypeDecoder.decodeBool(input, offset);
        }
        if (Bytes.class.isAssignableFrom(type)) {
            return TypeDecoder.decodeBytes(input, offset, type);
        }
        if (DynamicBytes.class.isAssignableFrom(type)) {
            return (T)TypeDecoder.decodeDynamicBytes(input, offset);
        }
        if (Utf8String.class.isAssignableFrom(type)) {
            return (T)TypeDecoder.decodeUtf8String(input, offset);
        }
        if (Array.class.isAssignableFrom(type)) {
            throw new UnsupportedOperationException("Array types must be wrapped in a TypeReference");
        }
        throw new UnsupportedOperationException("Type cannot be encoded: " + type.getClass());
    }

    static <T extends Type> T decode(String input, Class<T> type) {
        return TypeDecoder.decode(input, 0, type);
    }

    static Address decodeAddress(String input) {
        return new Address(TypeDecoder.decodeNumeric(input, Uint160.class));
    }

    static <T extends NumericType> T decodeNumeric(String input, Class<T> type) {
        try {
            byte[] inputByteArray = Numeric.hexStringToByteArray((String)input);
            int typeLengthAsBytes = TypeDecoder.getTypeLengthInBytes(type);
            byte[] resultByteArray = new byte[typeLengthAsBytes + 1];
            if (Int.class.isAssignableFrom(type) || Fixed.class.isAssignableFrom(type)) {
                resultByteArray[0] = inputByteArray[0];
            }
            int valueOffset = 32 - typeLengthAsBytes;
            System.arraycopy(inputByteArray, valueOffset, resultByteArray, 1, typeLengthAsBytes);
            BigInteger numericValue = new BigInteger(resultByteArray);
            return (T)((NumericType)type.getConstructor(BigInteger.class).newInstance(numericValue));
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new UnsupportedOperationException("Unable to create instance of " + type.getName(), e);
        }
    }

    static <T extends NumericType> int getTypeLengthInBytes(Class<T> type) {
        return TypeDecoder.getTypeLength(type) >> 3;
    }

    static <T extends NumericType> int getTypeLength(Class<T> type) {
        if (IntType.class.isAssignableFrom(type)) {
            String regex = "(" + Uint.class.getSimpleName() + "|" + Int.class.getSimpleName() + ")";
            String[] splitName = type.getSimpleName().split(regex);
            if (splitName.length == 2) {
                return Integer.parseInt(splitName[1]);
            }
        } else if (FixedPointType.class.isAssignableFrom(type)) {
            String regex = "(" + Ufixed.class.getSimpleName() + "|" + Fixed.class.getSimpleName() + ")";
            String[] splitName = type.getSimpleName().split(regex);
            if (splitName.length == 2) {
                String[] bitsCounts = splitName[1].split("x");
                return Integer.parseInt(bitsCounts[0]) + Integer.parseInt(bitsCounts[1]);
            }
        }
        return 256;
    }

    static Type instantiateStructType(TypeReference ref, Object value) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException, ClassNotFoundException {
        List values;
        if (value instanceof List) {
            values = (List)value;
        } else if (value.getClass().isArray()) {
            values = TypeDecoder.arrayToList(value);
        } else {
            throw new ClassCastException("Arg of type " + value.getClass() + " should be a list to instantiate Array");
        }
        ArrayList<Type> transformedList = new ArrayList<Type>(values.size());
        List<TypeReference> subTypeReference = ((TypeReference.StructTypeReference)ref).getTypeList();
        for (int i = 0; i < subTypeReference.size(); ++i) {
            transformedList.add(TypeDecoder.instantiateType(subTypeReference.get(i), values.get(i)));
        }
        if (DynamicStruct.class.isAssignableFrom(ref.getClassType())) {
            return new DynamicStruct((List<Type>)transformedList);
        }
        return new StaticStruct((List<Type>)transformedList);
    }

    static Type instantiateArrayType(TypeReference ref, Object value) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException, ClassNotFoundException {
        Constructor<Object> listcons;
        int arraySize;
        List values;
        if (value instanceof List) {
            values = (List)value;
        } else if (value.getClass().isArray()) {
            values = TypeDecoder.arrayToList(value);
        } else {
            throw new ClassCastException("Arg of type " + value.getClass() + " should be a list to instantiate Array");
        }
        int n = arraySize = ref instanceof TypeReference.StaticArrayTypeReference ? ((TypeReference.StaticArrayTypeReference)ref).getSize() : -1;
        if (arraySize <= 0) {
            listcons = DynamicArray.class.getConstructor(Class.class, List.class);
        } else {
            Class<?> arrayClass = Class.forName("com.klaytn.caver.abi.datatypes.generated.StaticArray" + arraySize);
            listcons = arrayClass.getConstructor(Class.class, List.class);
        }
        ArrayList<Type> transformedList = new ArrayList<Type>(values.size());
        TypeReference subTypeReference = ref.getSubTypeReference();
        for (Object o : values) {
            transformedList.add(TypeDecoder.instantiateType(subTypeReference, o));
        }
        return (Type)listcons.newInstance(subTypeReference.getClassType(), transformedList);
    }

    static Type instantiateAtomicType(Class<?> referenceClass, Object value) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException, ClassNotFoundException {
        Object constructorArg = null;
        if (NumericType.class.isAssignableFrom(referenceClass)) {
            constructorArg = TypeDecoder.asBigInteger(value);
        } else if (BytesType.class.isAssignableFrom(referenceClass)) {
            if (value instanceof byte[]) {
                constructorArg = value;
            } else if (value instanceof BigInteger) {
                constructorArg = ((BigInteger)value).toByteArray();
            } else if (value instanceof String) {
                constructorArg = Numeric.hexStringToByteArray((String)((String)value));
            }
        } else if (Utf8String.class.isAssignableFrom(referenceClass)) {
            constructorArg = value.toString();
        } else if (Address.class.isAssignableFrom(referenceClass)) {
            constructorArg = value instanceof BigInteger || value instanceof Uint160 ? value : value.toString();
        } else if (Bool.class.isAssignableFrom(referenceClass)) {
            if (value instanceof Boolean) {
                constructorArg = value;
            } else {
                BigInteger bival = TypeDecoder.asBigInteger(value);
                Object object = bival == null ? null : (constructorArg = Boolean.valueOf(!bival.equals(BigInteger.ZERO)));
            }
        }
        if (constructorArg == null) {
            throw new InstantiationException("Could not create type " + referenceClass + " from arg " + value.toString() + " of type " + value.getClass());
        }
        Class[] types = new Class[]{constructorArg.getClass()};
        Constructor<?> cons = referenceClass.getConstructor(types);
        return (Type)cons.newInstance(constructorArg);
    }

    static <T extends Type> int getSingleElementLength(String input, int offset, TypeReference typeReference) throws ClassNotFoundException {
        Class type = typeReference.getClassType();
        if (input.length() == offset) {
            return 0;
        }
        if (DynamicBytes.class.isAssignableFrom(type) || Utf8String.class.isAssignableFrom(type)) {
            return TypeDecoder.decodeUintAsInt(input, offset) / 32 + 2;
        }
        if (StaticStruct.class.isAssignableFrom(type)) {
            return Utils.getStaticStructComponentSize((TypeReference.StructTypeReference)typeReference);
        }
        if (StaticArray.class.isAssignableFrom(type)) {
            if (TypeDecoder.isDynamic(typeReference)) {
                return 1;
            }
            return Utils.getStaticArrayElementSize((TypeReference.StaticArrayTypeReference)typeReference);
        }
        return 1;
    }

    static int decodeUintAsInt(String rawInput, int offset) {
        String input = rawInput.substring(offset, offset + 64);
        return TypeDecoder.decode(input, 0, Uint.class).getValue().intValue();
    }

    static Bool decodeBool(String rawInput, int offset) {
        String input = rawInput.substring(offset, offset + 64);
        BigInteger numericValue = Numeric.toBigInt((String)input);
        boolean value = numericValue.equals(BigInteger.ONE);
        return new Bool(value);
    }

    static <T extends Bytes> T decodeBytes(String input, Class<T> type) {
        return TypeDecoder.decodeBytes(input, 0, type);
    }

    static <T extends Bytes> T decodeBytes(String input, int offset, Class<T> type) {
        try {
            String simpleName = type.getSimpleName();
            String[] splitName = simpleName.split(Bytes.class.getSimpleName());
            int length = Integer.parseInt(splitName[1]);
            int hexStringLength = length << 1;
            byte[] bytes = Numeric.hexStringToByteArray((String)input.substring(offset, offset + hexStringLength));
            return (T)((Bytes)type.getConstructor(byte[].class).newInstance(new Object[]{bytes}));
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new UnsupportedOperationException("Unable to create instance of " + type.getName(), e);
        }
    }

    static DynamicBytes decodeDynamicBytes(String input, int offset) {
        int encodedLength = TypeDecoder.decodeUintAsInt(input, offset);
        int hexStringEncodedLength = encodedLength << 1;
        int valueOffset = offset + 64;
        String data = input.substring(valueOffset, valueOffset + hexStringEncodedLength);
        byte[] bytes = Numeric.hexStringToByteArray((String)data);
        return new DynamicBytes(bytes);
    }

    static Utf8String decodeUtf8String(String input, int offset) {
        DynamicBytes dynamicBytesResult = TypeDecoder.decodeDynamicBytes(input, offset);
        byte[] bytes = dynamicBytesResult.getValue();
        return new Utf8String(new String(bytes, StandardCharsets.UTF_8));
    }

    static <T extends Type> T decodeStaticArray(String input, int offset, TypeReference<T> typeReference, int length) {
        BiFunction<List, String, Type> function = (elements, typeName) -> {
            if (elements.isEmpty()) {
                throw new UnsupportedOperationException("Zero length fixed array is invalid type");
            }
            return TypeDecoder.instantiateStaticArray(elements, length);
        };
        return (T)TypeDecoder.decodeArrayElements(input, offset, typeReference, length, function);
    }

    public static <T extends Type> T decodeStaticStruct(String input, int offset, TypeReference<T> typeReference) throws ClassNotFoundException {
        return TypeDecoder.decodeStaticStructElement(input, offset, (TypeReference.StructTypeReference)typeReference);
    }

    private static <T extends Type> T decodeStaticStructElement(String input, int startOffset, TypeReference.StructTypeReference<T> staticStructTypeRef) throws ClassNotFoundException {
        int length = staticStructTypeRef.getTypeList().size();
        ArrayList<Type> elements = new ArrayList<Type>(length);
        int currOffset = startOffset;
        for (int i = 0; i < length; ++i) {
            Object value;
            TypeReference elementTypeRef;
            Class elementTypeCls = staticStructTypeRef.getTypeList().get(i).getClassType();
            if (StaticStruct.class.isAssignableFrom(elementTypeCls)) {
                elementTypeRef = (TypeReference.StructTypeReference)staticStructTypeRef.getTypeList().get(i);
                int nestedStructLength = Utils.getStaticStructComponentSize((TypeReference.StructTypeReference)elementTypeRef) * 64;
                value = TypeDecoder.decodeStaticStruct(input.substring(currOffset, currOffset + nestedStructLength), 0, elementTypeRef);
                currOffset += nestedStructLength;
            } else if (StaticArray.class.isAssignableFrom(elementTypeCls)) {
                elementTypeRef = (TypeReference.StaticArrayTypeReference)staticStructTypeRef.getTypeList().get(i);
                int arraySize = ((TypeReference.StaticArrayTypeReference)elementTypeRef).getSize();
                value = TypeDecoder.decodeStaticArray(input.substring(currOffset), 0, elementTypeRef, ((TypeReference.StaticArrayTypeReference)elementTypeRef).getSize());
                currOffset += Utils.getStaticArrayElementSize((TypeReference.StaticArrayTypeReference)elementTypeRef) * 64;
            } else {
                value = TypeDecoder.decode(input.substring(currOffset, currOffset + 64), 0, elementTypeCls);
                currOffset += 64;
            }
            elements.add((Type)value);
        }
        return (T)new StaticStruct((List<Type>)elements);
    }

    static <T extends Type> T decodeDynamicArray(String input, int offset, TypeReference<T> typeReference) {
        int length = TypeDecoder.decodeUintAsInt(input, offset);
        BiFunction<List, String, Type> function = (elements, typeName) -> {
            Class<Object> baseTypeCls = Array.class.isAssignableFrom(((Type)elements.get(0)).getClass()) ? ((Type)elements.get(0)).getClass() : AbiTypes.getType(((Type)elements.get(0)).getTypeAsString());
            return new DynamicArray((Class<?>)baseTypeCls, (List<?>)elements);
        };
        int valueOffset = offset + 64;
        return (T)TypeDecoder.decodeArrayElements(input, valueOffset, typeReference, length, function);
    }

    static <T extends Type> T decodeDynamicStruct(String input, int offset, TypeReference<T> typeReference) throws ClassNotFoundException {
        return TypeDecoder.decodeDynamicStructElements(input, offset, (TypeReference.StructTypeReference)typeReference);
    }

    private static <T extends Type> T decodeDynamicStructElements(String input, int offset, TypeReference.StructTypeReference<T> typeReference) throws ClassNotFoundException {
        int length = typeReference.getTypeList().size();
        int staticOffset = 0;
        HashMap<Integer, T> parameters = new HashMap<Integer, T>();
        ArrayList<Integer> parameterOffsets = new ArrayList<Integer>();
        for (int i = 0; i < length; ++i) {
            T value;
            TypeReference elementTypeRef = typeReference.getTypeList().get(i);
            Class elementTypeCls = elementTypeRef.getClassType();
            int beginIndex = offset + staticOffset;
            if (TypeDecoder.isDynamic(elementTypeRef)) {
                boolean isOnlyParameterInStruct = length == 1;
                int parameterOffset = isOnlyParameterInStruct ? offset : TypeDecoder.decodeDynamicStructDynamicParameterOffset(input.substring(beginIndex, beginIndex + 64)) + offset;
                parameterOffsets.add(parameterOffset);
                staticOffset += 64;
                continue;
            }
            if (StaticStruct.class.isAssignableFrom(elementTypeCls)) {
                value = TypeDecoder.decodeStaticStruct(input.substring(beginIndex), 0, typeReference.getTypeList().get(i));
                staticOffset += Utils.getStaticStructComponentSize((TypeReference.StructTypeReference)typeReference.getTypeList().get(i)) * 64;
            } else if (StaticArray.class.isAssignableFrom(elementTypeCls)) {
                TypeReference.StaticArrayTypeReference staticArrayTypeReference = (TypeReference.StaticArrayTypeReference)typeReference.getTypeList().get(i);
                int arraySize = staticArrayTypeReference.getSize();
                value = TypeDecoder.decodeStaticArray(input.substring(beginIndex), 0, staticArrayTypeReference, arraySize);
                staticOffset = TypeDecoder.isDynamic(elementTypeRef) ? (staticOffset += arraySize * 64) : (staticOffset += TypeDecoder.getSingleElementLength(input, staticOffset, elementTypeRef) * 64);
            } else {
                value = TypeDecoder.decode(input.substring(beginIndex), 0, elementTypeCls);
                staticOffset += value.bytes32PaddedLength() * 2;
            }
            parameters.put(i, value);
        }
        int dynamicParametersProcessed = 0;
        int dynamicParametersToProcess = TypeDecoder.getDynamicStructDynamicParametersCount(typeReference.getTypeList());
        for (int i = 0; i < length; ++i) {
            TypeReference subTypeReference = typeReference.getTypeList().get(i);
            Class subClsType = subTypeReference.getClassType();
            if (!TypeDecoder.isDynamic(subTypeReference)) continue;
            boolean isLastParameterInStruct = dynamicParametersProcessed == dynamicParametersToProcess - 1;
            int parameterLength = isLastParameterInStruct ? input.length() - (Integer)parameterOffsets.get(dynamicParametersProcessed) : (Integer)parameterOffsets.get(dynamicParametersProcessed + 1) - (Integer)parameterOffsets.get(dynamicParametersProcessed);
            parameters.put(i, TypeDecoder.decodeDynamicParameterFromStruct(input, (Integer)parameterOffsets.get(dynamicParametersProcessed), parameterLength, typeReference.getTypeList().get(i)));
            ++dynamicParametersProcessed;
        }
        ArrayList<Type> elements = new ArrayList<Type>();
        for (int i = 0; i < length; ++i) {
            elements.add((Type)parameters.get(i));
        }
        return (T)new DynamicStruct((List<Type>)elements);
    }

    private static <T extends Type> int getDynamicStructDynamicParametersCount(List<TypeReference> list) {
        return (int)list.stream().filter(t -> {
            try {
                return TypeDecoder.isDynamic(t);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }).count();
    }

    private static <T extends Type> T decodeDynamicParameterFromStruct(String input, int parameterOffset, int parameterLength, TypeReference<T> typeReference) throws ClassNotFoundException {
        T value;
        String dynamicElementData = input.substring(parameterOffset, parameterOffset + parameterLength);
        if (DynamicStruct.class.isAssignableFrom(typeReference.getClassType())) {
            value = TypeDecoder.decodeDynamicStruct(dynamicElementData, 0, typeReference);
        } else if (StaticStruct.class.isAssignableFrom(typeReference.getClassType())) {
            value = TypeDecoder.decodeStaticStruct(dynamicElementData, 0, typeReference);
        } else if (DynamicArray.class.isAssignableFrom(typeReference.getClassType())) {
            value = TypeDecoder.decodeDynamicArray(dynamicElementData, 0, typeReference);
        } else if (StaticArray.class.isAssignableFrom(typeReference.getClassType())) {
            TypeReference.StaticArrayTypeReference reference = (TypeReference.StaticArrayTypeReference)typeReference;
            value = TypeDecoder.decodeStaticArray(dynamicElementData, 0, reference, reference.getSize());
        } else {
            value = TypeDecoder.decode(dynamicElementData, typeReference.getClassType());
        }
        return value;
    }

    private static int decodeDynamicStructDynamicParameterOffset(String input) {
        return TypeDecoder.decodeUintAsInt(input, 0) * 2;
    }

    static <T extends Type> boolean isDynamic(TypeReference<T> parameter) throws ClassNotFoundException {
        Class<T> cls = parameter.getClassType();
        if (StaticArray.class.isAssignableFrom(cls)) {
            if (StaticStruct.class.isAssignableFrom(cls)) {
                return false;
            }
            TypeReference subTypeRef = parameter.getSubTypeReference();
            return TypeDecoder.isDynamic(subTypeRef);
        }
        return DynamicBytes.class.isAssignableFrom(cls) || Utf8String.class.isAssignableFrom(cls) || DynamicArray.class.isAssignableFrom(cls);
    }

    static <T extends Type> boolean isDynamic(Class<T> parameter) {
        return DynamicBytes.class.isAssignableFrom(parameter) || Utf8String.class.isAssignableFrom(parameter) || DynamicArray.class.isAssignableFrom(parameter);
    }

    static BigInteger asBigInteger(Object arg) {
        if (arg instanceof BigInteger) {
            return (BigInteger)arg;
        }
        if (arg instanceof BigDecimal) {
            return ((BigDecimal)arg).toBigInteger();
        }
        if (arg instanceof String) {
            return Numeric.toBigInt((String)((String)arg));
        }
        if (arg instanceof byte[]) {
            return Numeric.toBigInt((byte[])((byte[])arg));
        }
        if (arg instanceof Double || arg instanceof Float || arg instanceof Double || arg instanceof Float) {
            return BigDecimal.valueOf(((Number)arg).doubleValue()).toBigInteger();
        }
        if (arg instanceof Number) {
            return BigInteger.valueOf(((Number)arg).longValue());
        }
        return null;
    }

    static List arrayToList(Object array) {
        int len = java.lang.reflect.Array.getLength(array);
        ArrayList<Object> rslt = new ArrayList<Object>(len);
        for (int i = 0; i < len; ++i) {
            rslt.add(java.lang.reflect.Array.get(array, i));
        }
        return rslt;
    }

    private static <T extends Type> T instantiateStaticArray(List<T> elements, int length) {
        try {
            Class<?> arrayClass = Class.forName("com.klaytn.caver.abi.datatypes.generated.StaticArray" + length);
            Class<Object> baseTypeCls = Array.class.isAssignableFrom(((Type)elements.get(0)).getClass()) ? ((Type)elements.get(0)).getClass() : AbiTypes.getType(((Type)elements.get(0)).getTypeAsString());
            return (T)((Type)arrayClass.getConstructor(Class.class, List.class).newInstance(baseTypeCls, elements));
        }
        catch (ReflectiveOperationException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    private static <T extends Type> T decodeArrayElements(String input, int startOffset, TypeReference<T> typeReference, int length, BiFunction<List<T>, String, T> consumer) {
        try {
            TypeReference elementTypeRef = typeReference.getSubTypeReference();
            Class elementTypeCls = elementTypeRef.getClassType();
            if (StructType.class.isAssignableFrom(elementTypeCls)) {
                ArrayList<T> elements = new ArrayList<T>(length);
                int currOffset = startOffset;
                for (int i = 0; i < length; ++i) {
                    T value;
                    int hexStringOffset = 0;
                    if (DynamicStruct.class.isAssignableFrom(elementTypeCls)) {
                        hexStringOffset = startOffset + DefaultFunctionReturnDecoder.getDataOffset(input, currOffset, typeReference);
                        value = TypeDecoder.decodeDynamicStruct(input, hexStringOffset, elementTypeRef);
                    } else {
                        hexStringOffset = currOffset;
                        value = TypeDecoder.decodeStaticStruct(input, hexStringOffset, elementTypeRef);
                    }
                    elements.add(value);
                    currOffset += TypeDecoder.getSingleElementLength(input, currOffset, elementTypeRef) * 64;
                }
                String typeName = Utils.getSimpleTypeName(elementTypeCls);
                return (T)((Type)consumer.apply(elements, typeName));
            }
            if (Array.class.isAssignableFrom(elementTypeCls)) {
                ArrayList<T> elements = new ArrayList<T>(length);
                int currOffset = startOffset;
                for (int i = 0; i < length; ++i) {
                    T value;
                    if (DynamicArray.class.isAssignableFrom(elementTypeCls)) {
                        int hexStringDataOffset = DefaultFunctionReturnDecoder.getDataOffset(input, currOffset, elementTypeRef);
                        value = TypeDecoder.decodeDynamicArray(input, startOffset + hexStringDataOffset, elementTypeRef);
                    } else {
                        int arraySize = ((TypeReference.StaticArrayTypeReference)elementTypeRef).getSize();
                        int hexStringDataOffset = 0;
                        hexStringDataOffset = TypeDecoder.isDynamic(elementTypeRef.getSubTypeReference()) ? startOffset + DefaultFunctionReturnDecoder.getDataOffset(input, currOffset, elementTypeRef) : currOffset;
                        value = TypeDecoder.decodeStaticArray(input, hexStringDataOffset, elementTypeRef, arraySize);
                    }
                    elements.add(value);
                    currOffset += TypeDecoder.getSingleElementLength(input, currOffset, elementTypeRef) * 64;
                }
                String typeName = Utils.getSimpleTypeName(elementTypeCls);
                return (T)((Type)consumer.apply(elements, typeName));
            }
            ArrayList elements = new ArrayList(length);
            int currOffset = startOffset;
            for (int i = 0; i < length; ++i) {
                Object value;
                if (TypeDecoder.isDynamic(elementTypeRef)) {
                    int hexStringDataOffset = DefaultFunctionReturnDecoder.getDataOffset(input, currOffset, elementTypeRef);
                    value = TypeDecoder.decode(input, startOffset + hexStringDataOffset, elementTypeCls);
                    currOffset += 64;
                } else {
                    value = TypeDecoder.decode(input, currOffset, elementTypeCls);
                    currOffset += TypeDecoder.getSingleElementLength(input, currOffset, elementTypeRef) * 64;
                }
                elements.add(value);
            }
            String typeName = Utils.getSimpleTypeName(elementTypeCls);
            return (T)((Type)consumer.apply(elements, typeName));
        }
        catch (ClassNotFoundException e) {
            throw new UnsupportedOperationException("Unable to access parameterized type " + typeReference.getType().getTypeName(), e);
        }
    }
}

