/*
 * Decompiled with CFR 0.152.
 */
package com.klaytn.caver.abi;

import com.klaytn.caver.abi.Function;
import com.klaytn.caver.abi.FunctionEncoder;
import com.klaytn.caver.abi.TypeEncoder;
import com.klaytn.caver.abi.Utils;
import com.klaytn.caver.abi.datatypes.StaticArray;
import com.klaytn.caver.abi.datatypes.StaticStruct;
import com.klaytn.caver.abi.datatypes.Type;
import com.klaytn.caver.abi.datatypes.Uint;
import java.math.BigInteger;
import java.util.List;

public class DefaultFunctionEncoder
extends FunctionEncoder {
    @Override
    public String encodeFunction(Function function) {
        List<Type> parameters = function.getInputParameters();
        String methodSignature = DefaultFunctionEncoder.buildMethodSignature(function.getName(), parameters);
        String methodId = DefaultFunctionEncoder.buildMethodId(methodSignature);
        StringBuilder result = new StringBuilder();
        result.append(methodId);
        return DefaultFunctionEncoder.encodeParameters(parameters, result);
    }

    @Override
    public String encodeParameters(List<Type> parameters) {
        return DefaultFunctionEncoder.encodeParameters(parameters, new StringBuilder());
    }

    private static String encodeParameters(List<Type> parameters, StringBuilder result) {
        int dynamicDataOffset = DefaultFunctionEncoder.getLength(parameters) * 32;
        StringBuilder dynamicData = new StringBuilder();
        for (Type parameter : parameters) {
            String encodedValue = TypeEncoder.encode(parameter);
            if (TypeEncoder.isDynamic(parameter)) {
                String encodedDataOffset = TypeEncoder.encodeNumeric(new Uint(BigInteger.valueOf(dynamicDataOffset)));
                result.append(encodedDataOffset);
                dynamicData.append(encodedValue);
                dynamicDataOffset += encodedValue.length() >> 1;
                continue;
            }
            result.append(encodedValue);
        }
        result.append((CharSequence)dynamicData);
        return result.toString();
    }

    private static int getLength(List<Type> parameters) {
        int count = 0;
        for (Type type : parameters) {
            if (type instanceof StaticStruct) {
                count += Utils.getStaticStructComponentSize((StaticStruct)type);
                continue;
            }
            if (type instanceof StaticArray) {
                if (TypeEncoder.isDynamic(type)) {
                    ++count;
                    continue;
                }
                count += Utils.getStaticArrayElementSize((StaticArray)type);
                continue;
            }
            ++count;
        }
        return count;
    }
}

