/*
 * Decompiled with CFR 0.152.
 */
package com.kizitonwose.calendar.data;

import com.kizitonwose.calendar.core.CalendarMonth;
import com.kizitonwose.calendar.core.CalendarYear;
import com.kizitonwose.calendar.core.OutDateStyle;
import com.kizitonwose.calendar.data.MonthDataKt;
import java.time.DayOfWeek;
import java.time.Month;
import java.time.Year;
import java.time.YearMonth;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a&\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u001a\u0016\u0010\n\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0003\u001a\u0016\u0010\f\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u0003\u00a8\u0006\u000e"}, d2={"getCalendarYearData", "Lcom/kizitonwose/calendar/core/CalendarYear;", "startYear", "Ljava/time/Year;", "offset", "", "firstDayOfWeek", "Ljava/time/DayOfWeek;", "outDateStyle", "Lcom/kizitonwose/calendar/core/OutDateStyle;", "getYearIndex", "targetYear", "getYearIndicesCount", "endYear", "data"})
public final class YearDataKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final CalendarYear getCalendarYearData(@NotNull Year startYear, int offset, @NotNull DayOfWeek firstDayOfWeek, @NotNull OutDateStyle outDateStyle) {
        Intrinsics.checkNotNullParameter((Object)startYear, (String)"startYear");
        Intrinsics.checkNotNullParameter((Object)firstDayOfWeek, (String)"firstDayOfWeek");
        Intrinsics.checkNotNullParameter((Object)outDateStyle, (String)"outDateStyle");
        Year year = startYear.plusYears(offset);
        int n = EntriesMappings.entries$0.size();
        ArrayList<CalendarMonth> arrayList = new ArrayList<CalendarMonth>(n);
        int n2 = 0;
        while (n2 < n) {
            void index;
            int n3;
            int n4 = n3 = n2++;
            ArrayList<CalendarMonth> arrayList2 = arrayList;
            boolean bl = false;
            YearMonth yearMonth = year.atMonth(Month.JANUARY);
            Intrinsics.checkNotNullExpressionValue((Object)yearMonth, (String)"atMonth(...)");
            arrayList2.add(MonthDataKt.getCalendarMonthData(yearMonth, (int)index, firstDayOfWeek, outDateStyle).getCalendarMonth());
        }
        List months = arrayList;
        Intrinsics.checkNotNull((Object)year);
        return new CalendarYear(year, months);
    }

    public static final int getYearIndex(@NotNull Year startYear, @NotNull Year targetYear) {
        Intrinsics.checkNotNullParameter((Object)startYear, (String)"startYear");
        Intrinsics.checkNotNullParameter((Object)targetYear, (String)"targetYear");
        return (int)ChronoUnit.YEARS.between(startYear, targetYear);
    }

    public static final int getYearIndicesCount(@NotNull Year startYear, @NotNull Year endYear) {
        Intrinsics.checkNotNullParameter((Object)startYear, (String)"startYear");
        Intrinsics.checkNotNullParameter((Object)endYear, (String)"endYear");
        return YearDataKt.getYearIndex(startYear, endYear) + 1;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class EntriesMappings {
        public static final /* synthetic */ EnumEntries<Month> entries$0;

        static {
            entries$0 = EnumEntriesKt.enumEntries((Enum[])Month.values());
        }
    }
}

