/*
 * Decompiled with CFR 0.152.
 */
package com.kizitonwose.calendar.data;

import com.kizitonwose.calendar.core.OutDateStyle;
import com.kizitonwose.calendar.data.ExtensionsKt;
import com.kizitonwose.calendar.data.MonthData;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.YearMonth;
import java.time.temporal.ChronoUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u001a&\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u001a\u001e\u0010\n\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u0016\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u0003\u001a\u0016\u0010\r\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u0003\u00a8\u0006\u000f"}, d2={"getCalendarMonthData", "Lcom/kizitonwose/calendar/data/MonthData;", "startMonth", "Ljava/time/YearMonth;", "offset", "", "firstDayOfWeek", "Ljava/time/DayOfWeek;", "outDateStyle", "Lcom/kizitonwose/calendar/core/OutDateStyle;", "getHeatMapCalendarMonthData", "getMonthIndex", "targetMonth", "getMonthIndicesCount", "endMonth", "data"})
public final class MonthDataKt {
    @NotNull
    public static final MonthData getCalendarMonthData(@NotNull YearMonth startMonth, int offset, @NotNull DayOfWeek firstDayOfWeek, @NotNull OutDateStyle outDateStyle) {
        int n;
        int endOfRowDays;
        Intrinsics.checkNotNullParameter((Object)startMonth, (String)"startMonth");
        Intrinsics.checkNotNullParameter((Object)firstDayOfWeek, (String)"firstDayOfWeek");
        Intrinsics.checkNotNullParameter((Object)outDateStyle, (String)"outDateStyle");
        YearMonth month = startMonth.plusMonths(offset);
        Intrinsics.checkNotNull((Object)month);
        LocalDate firstDay = com.kizitonwose.calendar.core.ExtensionsKt.atStartOfMonth((YearMonth)month);
        DayOfWeek dayOfWeek = firstDay.getDayOfWeek();
        Intrinsics.checkNotNullExpressionValue((Object)dayOfWeek, (String)"getDayOfWeek(...)");
        int inDays = ExtensionsKt.daysUntil(firstDayOfWeek, dayOfWeek);
        int inAndMonthDays = inDays + month.lengthOfMonth();
        boolean bl = false;
        int n2 = endOfRowDays = inAndMonthDays % 7 != 0 ? 7 - inAndMonthDays % 7 : 0;
        if (outDateStyle == OutDateStyle.EndOfRow) {
            n = 0;
        } else {
            int weeksInMonth = (inAndMonthDays + endOfRowDays) / 7;
            n = (6 - weeksInMonth) * 7;
        }
        int endOfGridDays = n;
        int outDays = endOfRowDays + endOfGridDays;
        return new MonthData(month, inDays, outDays);
    }

    @NotNull
    public static final MonthData getHeatMapCalendarMonthData(@NotNull YearMonth startMonth, int offset, @NotNull DayOfWeek firstDayOfWeek) {
        int n;
        Intrinsics.checkNotNullParameter((Object)startMonth, (String)"startMonth");
        Intrinsics.checkNotNullParameter((Object)firstDayOfWeek, (String)"firstDayOfWeek");
        YearMonth month = startMonth.plusMonths(offset);
        Intrinsics.checkNotNull((Object)month);
        LocalDate firstDay = com.kizitonwose.calendar.core.ExtensionsKt.atStartOfMonth((YearMonth)month);
        if (offset == 0) {
            DayOfWeek dayOfWeek = firstDay.getDayOfWeek();
            Intrinsics.checkNotNullExpressionValue((Object)dayOfWeek, (String)"getDayOfWeek(...)");
            n = ExtensionsKt.daysUntil(firstDayOfWeek, dayOfWeek);
        } else {
            DayOfWeek dayOfWeek = firstDay.getDayOfWeek();
            Intrinsics.checkNotNullExpressionValue((Object)dayOfWeek, (String)"getDayOfWeek(...)");
            n = -ExtensionsKt.daysUntil(dayOfWeek, firstDayOfWeek);
        }
        int inDays = n;
        int inAndMonthDays = inDays + month.lengthOfMonth();
        boolean bl = false;
        int outDays = inAndMonthDays % 7 != 0 ? 7 - inAndMonthDays % 7 : 0;
        return new MonthData(month, inDays, outDays);
    }

    public static final int getMonthIndex(@NotNull YearMonth startMonth, @NotNull YearMonth targetMonth) {
        Intrinsics.checkNotNullParameter((Object)startMonth, (String)"startMonth");
        Intrinsics.checkNotNullParameter((Object)targetMonth, (String)"targetMonth");
        return (int)ChronoUnit.MONTHS.between(startMonth, targetMonth);
    }

    public static final int getMonthIndicesCount(@NotNull YearMonth startMonth, @NotNull YearMonth endMonth) {
        Intrinsics.checkNotNullParameter((Object)startMonth, (String)"startMonth");
        Intrinsics.checkNotNullParameter((Object)endMonth, (String)"endMonth");
        return MonthDataKt.getMonthIndex(startMonth, endMonth) + 1;
    }
}

