/*
 * Decompiled with CFR 0.152.
 */
package com.kizitonwose.calendar.data;

import com.kizitonwose.calendar.core.Week;
import com.kizitonwose.calendar.core.WeekDay;
import com.kizitonwose.calendar.core.WeekDayPosition;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c2\u0003J\t\u0010\f\u001a\u00020\u0003H\u00c2\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c2\u0003J'\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\t\u0010\u0016\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0019"}, d2={"Lcom/kizitonwose/calendar/data/WeekData;", "", "firstDayInWeek", "Ljava/time/LocalDate;", "desiredStartDate", "desiredEndDate", "(Ljava/time/LocalDate;Ljava/time/LocalDate;Ljava/time/LocalDate;)V", "week", "Lcom/kizitonwose/calendar/core/Week;", "getWeek", "()Lcom/kizitonwose/calendar/core/Week;", "component1", "component2", "component3", "copy", "equals", "", "other", "getDay", "Lcom/kizitonwose/calendar/core/WeekDay;", "dayOffset", "", "hashCode", "toString", "", "data_release"})
@SourceDebugExtension(value={"SMAP\nWeekData.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WeekData.kt\ncom/kizitonwose/calendar/data/WeekData\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,64:1\n1549#2:65\n1620#2,3:66\n*S KotlinDebug\n*F\n+ 1 WeekData.kt\ncom/kizitonwose/calendar/data/WeekData\n*L\n43#1:65\n43#1:66,3\n*E\n"})
public final class WeekData {
    @NotNull
    private final LocalDate firstDayInWeek;
    @NotNull
    private final LocalDate desiredStartDate;
    @NotNull
    private final LocalDate desiredEndDate;
    @NotNull
    private final Week week;

    /*
     * WARNING - void declaration
     */
    public WeekData(@NotNull LocalDate firstDayInWeek, @NotNull LocalDate desiredStartDate, @NotNull LocalDate desiredEndDate) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)firstDayInWeek, (String)"firstDayInWeek");
        Intrinsics.checkNotNullParameter((Object)desiredStartDate, (String)"desiredStartDate");
        Intrinsics.checkNotNullParameter((Object)desiredEndDate, (String)"desiredEndDate");
        this.firstDayInWeek = firstDayInWeek;
        this.desiredStartDate = desiredStartDate;
        this.desiredEndDate = desiredEndDate;
        Iterable iterable = (Iterable)RangesKt.until((int)0, (int)7);
        WeekData weekData = this;
        boolean $i$f$map = false;
        void var6_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void dayOffset;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.getDay((int)dayOffset));
        }
        List list = (List)destination$iv$iv;
        weekData.week = new Week(list);
    }

    @NotNull
    public final Week getWeek() {
        return this.week;
    }

    private final WeekDay getDay(int dayOffset) {
        LocalDate date = this.firstDayInWeek.plusDays(dayOffset);
        WeekDayPosition position = date.compareTo(this.desiredStartDate) < 0 ? WeekDayPosition.InDate : (date.compareTo(this.desiredEndDate) > 0 ? WeekDayPosition.OutDate : WeekDayPosition.RangeDate);
        Intrinsics.checkNotNull((Object)date);
        return new WeekDay(date, position);
    }

    private final LocalDate component1() {
        return this.firstDayInWeek;
    }

    private final LocalDate component2() {
        return this.desiredStartDate;
    }

    private final LocalDate component3() {
        return this.desiredEndDate;
    }

    @NotNull
    public final WeekData copy(@NotNull LocalDate firstDayInWeek, @NotNull LocalDate desiredStartDate, @NotNull LocalDate desiredEndDate) {
        Intrinsics.checkNotNullParameter((Object)firstDayInWeek, (String)"firstDayInWeek");
        Intrinsics.checkNotNullParameter((Object)desiredStartDate, (String)"desiredStartDate");
        Intrinsics.checkNotNullParameter((Object)desiredEndDate, (String)"desiredEndDate");
        return new WeekData(firstDayInWeek, desiredStartDate, desiredEndDate);
    }

    public static /* synthetic */ WeekData copy$default(WeekData weekData, LocalDate localDate, LocalDate localDate2, LocalDate localDate3, int n, Object object) {
        if ((n & 1) != 0) {
            localDate = weekData.firstDayInWeek;
        }
        if ((n & 2) != 0) {
            localDate2 = weekData.desiredStartDate;
        }
        if ((n & 4) != 0) {
            localDate3 = weekData.desiredEndDate;
        }
        return weekData.copy(localDate, localDate2, localDate3);
    }

    @NotNull
    public String toString() {
        return "WeekData(firstDayInWeek=" + this.firstDayInWeek + ", desiredStartDate=" + this.desiredStartDate + ", desiredEndDate=" + this.desiredEndDate + ")";
    }

    public int hashCode() {
        int result = this.firstDayInWeek.hashCode();
        result = result * 31 + this.desiredStartDate.hashCode();
        result = result * 31 + this.desiredEndDate.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof WeekData)) {
            return false;
        }
        WeekData weekData = (WeekData)other;
        if (!Intrinsics.areEqual((Object)this.firstDayInWeek, (Object)weekData.firstDayInWeek)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.desiredStartDate, (Object)weekData.desiredStartDate)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.desiredEndDate, (Object)weekData.desiredEndDate);
    }
}

