/*
 * Decompiled with CFR 0.152.
 */
package com.kizitonwose.calendar.data;

import com.kizitonwose.calendar.core.CalendarDay;
import com.kizitonwose.calendar.core.CalendarMonth;
import com.kizitonwose.calendar.core.DayPosition;
import com.kizitonwose.calendar.core.ExtensionsKt;
import java.time.LocalDate;
import java.time.YearMonth;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B!\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0005H\u0002J\t\u0010\u0018\u001a\u00020\u0003H\u00c2\u0003J\t\u0010\u0019\u001a\u00020\u0005H\u00c2\u0003J\t\u0010\u001a\u001a\u00020\u0005H\u00c2\u0003J,\u0010\u001b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c0\u0001\u00a2\u0006\u0002\b\u001cJ\u0014\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010 \u001a\u00020\u0005H\u00d6\u0081\u0004J\n\u0010!\u001a\u00020\"H\u00d6\u0081\u0004R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006#"}, d2={"Lcom/kizitonwose/calendar/data/MonthData;", "", "month", "Ljava/time/YearMonth;", "inDays", "", "outDays", "<init>", "(Ljava/time/YearMonth;II)V", "totalDays", "firstDay", "Ljava/time/LocalDate;", "kotlin.jvm.PlatformType", "rows", "", "previousMonth", "nextMonth", "calendarMonth", "Lcom/kizitonwose/calendar/core/CalendarMonth;", "getCalendarMonth", "()Lcom/kizitonwose/calendar/core/CalendarMonth;", "getDay", "Lcom/kizitonwose/calendar/core/CalendarDay;", "dayOffset", "component1", "component2", "component3", "copy", "copy$data", "equals", "", "other", "hashCode", "toString", "", "data"})
@SourceDebugExtension(value={"SMAP\nMonthData.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MonthData.kt\ncom/kizitonwose/calendar/data/MonthData\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,94:1\n1586#2:95\n1661#2,3:96\n*S KotlinDebug\n*F\n+ 1 MonthData.kt\ncom/kizitonwose/calendar/data/MonthData\n*L\n32#1:95\n32#1:96,3\n*E\n"})
public final class MonthData {
    @NotNull
    private final YearMonth month;
    private final int inDays;
    private final int outDays;
    private final int totalDays;
    private final LocalDate firstDay;
    @NotNull
    private final List<List<Integer>> rows;
    @NotNull
    private final YearMonth previousMonth;
    @NotNull
    private final YearMonth nextMonth;
    @NotNull
    private final CalendarMonth calendarMonth;

    /*
     * WARNING - void declaration
     */
    public MonthData(@NotNull YearMonth month, int inDays, int outDays) {
        Collection<List> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)month, (String)"month");
        this.month = month;
        this.inDays = inDays;
        this.outDays = outDays;
        this.totalDays = this.inDays + this.month.lengthOfMonth() + this.outDays;
        this.firstDay = ExtensionsKt.atStartOfMonth((YearMonth)this.month).minusDays(this.inDays);
        this.rows = CollectionsKt.chunked((Iterable)((Iterable)RangesKt.until((int)0, (int)this.totalDays)), (int)7);
        this.previousMonth = ExtensionsKt.getPreviousMonth((YearMonth)this.month);
        this.nextMonth = ExtensionsKt.getNextMonth((YearMonth)this.month);
        Iterable iterable = this.rows;
        YearMonth yearMonth = this.month;
        MonthData monthData = this;
        boolean $i$f$map = false;
        void var6_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void $this$mapTo$iv$iv2;
            void week;
            List list = (List)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Iterable $this$map$iv2 = (Iterable)week;
            boolean $i$f$map2 = false;
            Iterable iterable2 = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                void dayOffset;
                int n = ((Number)item$iv$iv2).intValue();
                Collection collection2 = destination$iv$iv2;
                boolean bl2 = false;
                collection2.add(this.getDay((int)dayOffset));
            }
            collection.add((List)destination$iv$iv2);
        }
        collection = (List)destination$iv$iv;
        List list = collection;
        YearMonth yearMonth2 = yearMonth;
        monthData.calendarMonth = new CalendarMonth(yearMonth2, list);
    }

    @NotNull
    public final CalendarMonth getCalendarMonth() {
        return this.calendarMonth;
    }

    private final CalendarDay getDay(int dayOffset) {
        DayPosition dayPosition;
        LocalDate date = this.firstDay.plusDays(dayOffset);
        Intrinsics.checkNotNull((Object)date);
        YearMonth yearMonth = ExtensionsKt.getYearMonth((LocalDate)date);
        if (Intrinsics.areEqual((Object)yearMonth, (Object)this.month)) {
            dayPosition = DayPosition.MonthDate;
        } else if (Intrinsics.areEqual((Object)yearMonth, (Object)this.previousMonth)) {
            dayPosition = DayPosition.InDate;
        } else if (Intrinsics.areEqual((Object)yearMonth, (Object)this.nextMonth)) {
            dayPosition = DayPosition.OutDate;
        } else {
            throw new IllegalArgumentException("Invalid date: " + date + " in month: " + this.month);
        }
        DayPosition position = dayPosition;
        return new CalendarDay(date, position);
    }

    private final YearMonth component1() {
        return this.month;
    }

    private final int component2() {
        return this.inDays;
    }

    private final int component3() {
        return this.outDays;
    }

    @NotNull
    public final MonthData copy$data(@NotNull YearMonth month, int inDays, int outDays) {
        Intrinsics.checkNotNullParameter((Object)month, (String)"month");
        return new MonthData(month, inDays, outDays);
    }

    public static /* synthetic */ MonthData copy$data$default(MonthData monthData, YearMonth yearMonth, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            yearMonth = monthData.month;
        }
        if ((n3 & 2) != 0) {
            n = monthData.inDays;
        }
        if ((n3 & 4) != 0) {
            n2 = monthData.outDays;
        }
        return monthData.copy$data(yearMonth, n, n2);
    }

    @NotNull
    public String toString() {
        return "MonthData(month=" + this.month + ", inDays=" + this.inDays + ", outDays=" + this.outDays + ")";
    }

    public int hashCode() {
        int result = this.month.hashCode();
        result = result * 31 + Integer.hashCode(this.inDays);
        result = result * 31 + Integer.hashCode(this.outDays);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MonthData)) {
            return false;
        }
        MonthData monthData = (MonthData)other;
        if (!Intrinsics.areEqual((Object)this.month, (Object)monthData.month)) {
            return false;
        }
        if (this.inDays != monthData.inDays) {
            return false;
        }
        return this.outDays == monthData.outDays;
    }
}

