/*
 * Decompiled with CFR 0.152.
 */
package com.kizitonwose.calendar.core;

import androidx.compose.runtime.Immutable;
import com.kizitonwose.calendar.core.CalendarMonth;
import java.io.Serializable;
import java.time.Year;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0087\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0096\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J#\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0018"}, d2={"Lcom/kizitonwose/calendar/core/CalendarYear;", "Ljava/io/Serializable;", "year", "Ljava/time/Year;", "months", "", "Lcom/kizitonwose/calendar/core/CalendarMonth;", "<init>", "(Ljava/time/Year;Ljava/util/List;)V", "getYear", "()Ljava/time/Year;", "getMonths", "()Ljava/util/List;", "equals", "", "other", "", "hashCode", "", "toString", "", "component1", "component2", "copy", "core"})
@Immutable
public final class CalendarYear
implements Serializable {
    @NotNull
    private final Year year;
    @NotNull
    private final List<CalendarMonth> months;

    public CalendarYear(@NotNull Year year, @NotNull List<CalendarMonth> months) {
        Intrinsics.checkNotNullParameter((Object)year, (String)"year");
        Intrinsics.checkNotNullParameter(months, (String)"months");
        this.year = year;
        this.months = months;
    }

    @NotNull
    public final Year getYear() {
        return this.year;
    }

    @NotNull
    public final List<CalendarMonth> getMonths() {
        return this.months;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Object object2 = other;
        Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type com.kizitonwose.calendar.core.CalendarYear");
        CalendarYear cfr_ignored_0 = (CalendarYear)object2;
        if (!Intrinsics.areEqual((Object)this.year, (Object)((CalendarYear)other).year)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)CollectionsKt.first(this.months), (Object)CollectionsKt.first(((CalendarYear)other).months))) {
            return false;
        }
        return Intrinsics.areEqual((Object)CollectionsKt.last(this.months), (Object)CollectionsKt.last(((CalendarYear)other).months));
    }

    public int hashCode() {
        int result = this.year.hashCode();
        result = 31 * result + ((CalendarMonth)CollectionsKt.first(this.months)).hashCode();
        result = 31 * result + ((CalendarMonth)CollectionsKt.last(this.months)).hashCode();
        return result;
    }

    @NotNull
    public String toString() {
        return "CalendarYear { year = " + this.year + ", firstMonth = " + CollectionsKt.first(this.months) + ", lastMonth = " + CollectionsKt.last(this.months) + " } ";
    }

    @NotNull
    public final Year component1() {
        return this.year;
    }

    @NotNull
    public final List<CalendarMonth> component2() {
        return this.months;
    }

    @NotNull
    public final CalendarYear copy(@NotNull Year year, @NotNull List<CalendarMonth> months) {
        Intrinsics.checkNotNullParameter((Object)year, (String)"year");
        Intrinsics.checkNotNullParameter(months, (String)"months");
        return new CalendarYear(year, months);
    }

    public static /* synthetic */ CalendarYear copy$default(CalendarYear calendarYear, Year year, List list, int n, Object object) {
        if ((n & 1) != 0) {
            year = calendarYear.year;
        }
        if ((n & 2) != 0) {
            list = calendarYear.months;
        }
        return calendarYear.copy(year, list);
    }
}

