/*
 * Decompiled with CFR 0.152.
 */
package com.jwenfeng.library.pulltorefresh;

import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.support.v4.view.ViewCompat;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.jwenfeng.library.R;
import com.jwenfeng.library.pulltorefresh.BaseRefreshListener;
import com.jwenfeng.library.pulltorefresh.util.DisplayUtil;
import com.jwenfeng.library.pulltorefresh.view.FooterView;
import com.jwenfeng.library.pulltorefresh.view.HeadRefreshView;
import com.jwenfeng.library.pulltorefresh.view.HeadView;
import com.jwenfeng.library.pulltorefresh.view.LoadMoreView;

public class PullToRefreshLayout
extends FrameLayout {
    private HeadView mHeaderView;
    private FooterView mFooterView;
    private View mChildView;
    private static final long ANIM_TIME = 300L;
    private static int HEAD_HEIGHT = 60;
    private static int FOOT_HEIGHT = 60;
    private static int head_height;
    private static int head_height_2;
    private static int foot_height;
    private static int foot_height_2;
    private float mTouchY;
    private float mCurrentY;
    private boolean canLoadMore = true;
    private boolean canRefresh = true;
    private boolean isRefresh;
    private boolean isLoadMore;
    private int mTouchSlope;
    private BaseRefreshListener refreshListener;
    private View loadingView;
    private View errorView;
    private View emptyView;
    private int loading = R.layout.layout_loading;
    private int empty = R.layout.layout_empty;
    private int error = R.layout.layout_error;

    public void setRefreshListener(BaseRefreshListener refreshListener) {
        this.refreshListener = refreshListener;
    }

    public PullToRefreshLayout(Context context) {
        this(context, null);
    }

    public PullToRefreshLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public PullToRefreshLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.PullToRefreshLayout, defStyleAttr, 0);
        this.error = a.getResourceId(R.styleable.PullToRefreshLayout_view_error, this.error);
        this.loading = a.getResourceId(R.styleable.PullToRefreshLayout_view_loading, this.loading);
        this.empty = a.getResourceId(R.styleable.PullToRefreshLayout_view_empty, this.empty);
        this.init();
    }

    private void cal() {
        head_height = DisplayUtil.dp2Px(this.getContext(), HEAD_HEIGHT);
        foot_height = DisplayUtil.dp2Px(this.getContext(), FOOT_HEIGHT);
        head_height_2 = DisplayUtil.dp2Px(this.getContext(), HEAD_HEIGHT * 2);
        foot_height_2 = DisplayUtil.dp2Px(this.getContext(), FOOT_HEIGHT * 2);
        this.mTouchSlope = ViewConfiguration.get((Context)this.getContext()).getScaledTouchSlop();
    }

    private void init() {
        this.cal();
        int count = this.getChildCount();
        if (count != 1) {
            new IllegalArgumentException("child only can be one");
        }
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.mChildView = this.getChildAt(0);
        this.addHeadView();
        this.addFooterView();
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
    }

    private void addHeadView() {
        if (this.mHeaderView == null) {
            this.mHeaderView = new HeadRefreshView(this.getContext());
        } else {
            this.removeView(this.mHeaderView.getView());
        }
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, 0);
        this.mHeaderView.getView().setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        if (this.mHeaderView.getView().getParent() != null) {
            ((ViewGroup)this.mHeaderView.getView().getParent()).removeAllViews();
        }
        this.addView(this.mHeaderView.getView(), 0);
    }

    private void addFooterView() {
        if (this.mFooterView == null) {
            this.mFooterView = new LoadMoreView(this.getContext());
        } else {
            this.removeView(this.mFooterView.getView());
        }
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, 0);
        layoutParams.gravity = 80;
        this.mFooterView.getView().setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        if (this.mFooterView.getView().getParent() != null) {
            ((ViewGroup)this.mFooterView.getView().getParent()).removeAllViews();
        }
        this.addView(this.mFooterView.getView());
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        if (!this.canLoadMore && !this.canRefresh) {
            return super.onInterceptTouchEvent(ev);
        }
        switch (ev.getAction()) {
            case 0: {
                this.mCurrentY = this.mTouchY = ev.getY();
                break;
            }
            case 2: {
                float currentY = ev.getY();
                float dy = currentY - this.mCurrentY;
                if (this.canRefresh) {
                    boolean canChildScrollUp = this.canChildScrollUp();
                    if (dy > (float)this.mTouchSlope && !canChildScrollUp) {
                        this.mHeaderView.begin();
                        return true;
                    }
                }
                if (!this.canLoadMore) break;
                boolean canChildScrollDown = this.canChildScrollDown();
                if (!(dy < (float)(-this.mTouchSlope)) || canChildScrollDown) break;
                this.mFooterView.begin();
                return true;
            }
        }
        return super.onInterceptTouchEvent(ev);
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.isRefresh || this.isLoadMore) {
            return true;
        }
        switch (event.getAction()) {
            case 2: {
                this.mCurrentY = event.getY();
                float dura = (this.mCurrentY - this.mTouchY) / 3.0f;
                if (dura > 0.0f && this.canRefresh) {
                    dura = Math.min((float)head_height_2, dura);
                    dura = Math.max(0.0f, dura);
                    this.mHeaderView.getView().getLayoutParams().height = (int)dura;
                    ViewCompat.setTranslationY((View)this.mChildView, (float)dura);
                    this.requestLayout();
                    this.mHeaderView.progress(dura, head_height);
                } else if (this.canLoadMore) {
                    dura = Math.min((float)foot_height_2, Math.abs(dura));
                    dura = Math.max(0.0f, Math.abs(dura));
                    this.mFooterView.getView().getLayoutParams().height = (int)dura;
                    ViewCompat.setTranslationY((View)this.mChildView, (float)(-dura));
                    this.requestLayout();
                    this.mFooterView.progress(dura, foot_height);
                }
                return true;
            }
            case 1: 
            case 3: {
                float currentY = event.getY();
                int dy1 = (int)(currentY - this.mTouchY) / 3;
                if (dy1 > 0 && this.canRefresh) {
                    if (dy1 >= head_height) {
                        this.createAnimatorTranslationY(10, dy1 > head_height_2 ? head_height_2 : dy1, head_height, new CallBack(){

                            @Override
                            public void onSuccess() {
                                PullToRefreshLayout.this.isRefresh = true;
                                if (PullToRefreshLayout.this.refreshListener != null) {
                                    PullToRefreshLayout.this.refreshListener.refresh();
                                }
                                PullToRefreshLayout.this.mHeaderView.loading();
                            }
                        });
                        break;
                    }
                    if (dy1 <= 0 || dy1 >= head_height) break;
                    this.setFinish(dy1, 10);
                    this.mHeaderView.normal();
                    break;
                }
                if (!this.canLoadMore) break;
                if (Math.abs(dy1) >= foot_height) {
                    this.createAnimatorTranslationY(11, Math.abs(dy1) > foot_height_2 ? foot_height_2 : Math.abs(dy1), foot_height, new CallBack(){

                        @Override
                        public void onSuccess() {
                            PullToRefreshLayout.this.isLoadMore = true;
                            if (PullToRefreshLayout.this.refreshListener != null) {
                                PullToRefreshLayout.this.refreshListener.loadMore();
                            }
                            PullToRefreshLayout.this.mFooterView.loading();
                        }
                    });
                    break;
                }
                this.setFinish(Math.abs(dy1), 11);
                this.mFooterView.normal();
            }
        }
        return super.onTouchEvent(event);
    }

    private boolean canChildScrollDown() {
        if (this.mChildView == null) {
            return false;
        }
        return ViewCompat.canScrollVertically((View)this.mChildView, (int)1);
    }

    private boolean canChildScrollUp() {
        if (this.mChildView == null) {
            return false;
        }
        return ViewCompat.canScrollVertically((View)this.mChildView, (int)-1);
    }

    public void createAnimatorTranslationY(final int state, int start, final int purpose, final CallBack callBack) {
        ValueAnimator anim = ValueAnimator.ofInt((int[])new int[]{start, purpose});
        anim.setDuration(300L);
        anim.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                int value = (Integer)valueAnimator.getAnimatedValue();
                if (state == 10) {
                    ((PullToRefreshLayout)PullToRefreshLayout.this).mHeaderView.getView().getLayoutParams().height = value;
                    ViewCompat.setTranslationY((View)PullToRefreshLayout.this.mChildView, (float)value);
                    if (purpose == 0) {
                        PullToRefreshLayout.this.mHeaderView.finishing(value, head_height_2);
                    } else {
                        PullToRefreshLayout.this.mHeaderView.progress(value, head_height);
                    }
                } else {
                    ((PullToRefreshLayout)PullToRefreshLayout.this).mFooterView.getView().getLayoutParams().height = value;
                    ViewCompat.setTranslationY((View)PullToRefreshLayout.this.mChildView, (float)(-value));
                    if (purpose == 0) {
                        PullToRefreshLayout.this.mFooterView.finishing(value, head_height_2);
                    } else {
                        PullToRefreshLayout.this.mFooterView.progress(value, foot_height);
                    }
                }
                if (value == purpose && callBack != null) {
                    callBack.onSuccess();
                }
                PullToRefreshLayout.this.requestLayout();
            }
        });
        anim.start();
    }

    private void setFinish(int height, final int state) {
        this.createAnimatorTranslationY(state, height, 0, new CallBack(){

            @Override
            public void onSuccess() {
                if (state == 10) {
                    PullToRefreshLayout.this.isRefresh = false;
                    PullToRefreshLayout.this.mHeaderView.normal();
                } else {
                    PullToRefreshLayout.this.isLoadMore = false;
                    PullToRefreshLayout.this.mFooterView.normal();
                }
            }
        });
    }

    private void setFinish(int state) {
        if (state == 10) {
            if (this.mHeaderView != null && this.mHeaderView.getView().getLayoutParams().height > 0 && this.isRefresh) {
                this.setFinish(head_height, state);
            }
        } else if (this.mFooterView != null && this.mFooterView.getView().getLayoutParams().height > 0 && this.isLoadMore) {
            this.setFinish(foot_height, state);
        }
    }

    private void showLoadingView() {
        if (this.loadingView == null) {
            this.loadingView = LayoutInflater.from((Context)this.getContext()).inflate(this.loading, null);
            FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, -1);
            this.addView(this.loadingView, (ViewGroup.LayoutParams)layoutParams);
        } else {
            this.loadingView.setVisibility(0);
        }
    }

    private void showEmptyView() {
        if (this.emptyView == null) {
            this.emptyView = LayoutInflater.from((Context)this.getContext()).inflate(this.empty, null);
            FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, -1);
            this.addView(this.emptyView, (ViewGroup.LayoutParams)layoutParams);
        } else {
            this.emptyView.setVisibility(0);
        }
    }

    private void showErrorView() {
        if (this.errorView == null) {
            this.errorView = LayoutInflater.from((Context)this.getContext()).inflate(this.error, null);
            FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, -1);
            this.addView(this.errorView, (ViewGroup.LayoutParams)layoutParams);
        } else {
            this.errorView.setVisibility(0);
        }
    }

    private void hideView(View view) {
        if (view != null) {
            view.setVisibility(8);
        }
    }

    private void switchView(int status) {
        switch (status) {
            case 0: {
                this.hideView(this.loadingView);
                this.hideView(this.emptyView);
                this.hideView(this.errorView);
                this.mChildView.setVisibility(0);
                break;
            }
            case 1: {
                this.hideView(this.mChildView);
                this.hideView(this.emptyView);
                this.hideView(this.errorView);
                this.showLoadingView();
                break;
            }
            case 2: {
                this.hideView(this.mChildView);
                this.hideView(this.loadingView);
                this.hideView(this.errorView);
                this.showEmptyView();
                break;
            }
            case 3: {
                this.hideView(this.mChildView);
                this.hideView(this.loadingView);
                this.hideView(this.emptyView);
                this.showErrorView();
                break;
            }
            default: {
                this.hideView(this.loadingView);
                this.hideView(this.emptyView);
                this.hideView(this.errorView);
                this.mChildView.setVisibility(0);
            }
        }
    }

    public void showView(int status) {
        this.switchView(status);
    }

    public View getView(int status) {
        switch (status) {
            case 2: {
                return this.emptyView;
            }
            case 1: {
                return this.loadingView;
            }
            case 3: {
                return this.errorView;
            }
            case 0: {
                return this.mChildView;
            }
        }
        return null;
    }

    public void autoRefresh() {
        this.createAnimatorTranslationY(10, 0, head_height, new CallBack(){

            @Override
            public void onSuccess() {
                PullToRefreshLayout.this.isRefresh = true;
                if (PullToRefreshLayout.this.refreshListener != null) {
                    PullToRefreshLayout.this.refreshListener.refresh();
                }
                PullToRefreshLayout.this.mHeaderView.loading();
            }
        });
    }

    public void finishRefresh() {
        this.setFinish(10);
    }

    public void finishLoadMore() {
        this.setFinish(11);
    }

    public void setCanLoadMore(boolean canLoadMore) {
        this.canLoadMore = canLoadMore;
    }

    public void setCanRefresh(boolean canRefresh) {
        this.canRefresh = canRefresh;
    }

    public void setHeaderView(HeadView mHeaderView) {
        this.mHeaderView = mHeaderView;
        this.addHeadView();
    }

    public void setFooterView(FooterView mFooterView) {
        this.mFooterView = mFooterView;
        this.addFooterView();
    }

    public void setHeadHeight(int dp) {
        head_height = DisplayUtil.dp2Px(this.getContext(), dp);
    }

    public void setFootHeight(int dp) {
        foot_height = DisplayUtil.dp2Px(this.getContext(), dp);
    }

    public void setAllHeight(int dp) {
        head_height = DisplayUtil.dp2Px(this.getContext(), dp);
        foot_height = DisplayUtil.dp2Px(this.getContext(), dp);
    }

    public void setAllHeight(int refresh, int loadMore) {
        head_height = DisplayUtil.dp2Px(this.getContext(), refresh);
        foot_height = DisplayUtil.dp2Px(this.getContext(), loadMore);
    }

    public void setMaxHeadHeight(int dp) {
        if (head_height >= DisplayUtil.dp2Px(this.getContext(), dp)) {
            return;
        }
        head_height_2 = DisplayUtil.dp2Px(this.getContext(), dp);
    }

    public void setMaxFootHeight(int dp) {
        if (foot_height >= DisplayUtil.dp2Px(this.getContext(), dp)) {
            return;
        }
        foot_height_2 = DisplayUtil.dp2Px(this.getContext(), dp);
    }

    public void setAllMaxHeight(int dp) {
        if (head_height >= DisplayUtil.dp2Px(this.getContext(), dp)) {
            return;
        }
        if (foot_height >= DisplayUtil.dp2Px(this.getContext(), dp)) {
            return;
        }
        head_height_2 = DisplayUtil.dp2Px(this.getContext(), dp);
        foot_height_2 = DisplayUtil.dp2Px(this.getContext(), dp);
    }

    public void setAllMaxHeight(int refresh, int loadMore) {
        if (head_height >= DisplayUtil.dp2Px(this.getContext(), refresh)) {
            return;
        }
        if (foot_height >= DisplayUtil.dp2Px(this.getContext(), loadMore)) {
            return;
        }
        head_height_2 = DisplayUtil.dp2Px(this.getContext(), refresh);
        foot_height_2 = DisplayUtil.dp2Px(this.getContext(), loadMore);
    }

    public static interface CallBack {
        public void onSuccess();
    }
}

