/*
 * Decompiled with CFR 0.152.
 */
package com.jwenfeng.library.pulltorefresh;

import android.animation.ValueAnimator;
import android.content.Context;
import android.support.v4.view.ViewCompat;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.jwenfeng.library.pulltorefresh.BaseRefreshListener;
import com.jwenfeng.library.pulltorefresh.view.FooterView;
import com.jwenfeng.library.pulltorefresh.view.HeadRefreshView;
import com.jwenfeng.library.pulltorefresh.view.HeadView;
import com.jwenfeng.library.pulltorefresh.view.LoadMoreView;

public class PullToRefreshLayout
extends FrameLayout {
    private HeadView mHeaderView;
    private FooterView mFooterView;
    private View mChildView;
    private static final long ANIM_TIME = 250L;
    private static int HEAD_HEIGHT = 60;
    private static int FOOT_HEIGHT = 60;
    private static int head_height;
    private static int head_height_2;
    private static int foot_height;
    private static int foot_height_2;
    private float mTouchY;
    private float mCurrentY;
    private boolean canLoadMore = true;
    private boolean canRefresh = true;
    private boolean isRefresh;
    private boolean isLoadMore;
    private BaseRefreshListener refreshListener;

    public void setRefreshListener(BaseRefreshListener refreshListener) {
        this.refreshListener = refreshListener;
    }

    public PullToRefreshLayout(Context context) {
        this(context, null);
    }

    public PullToRefreshLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public PullToRefreshLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void cal() {
        head_height = PullToRefreshLayout.Dp2Px(this.getContext(), HEAD_HEIGHT);
        foot_height = PullToRefreshLayout.Dp2Px(this.getContext(), FOOT_HEIGHT);
        head_height_2 = PullToRefreshLayout.Dp2Px(this.getContext(), HEAD_HEIGHT * 2);
        foot_height_2 = PullToRefreshLayout.Dp2Px(this.getContext(), FOOT_HEIGHT * 2);
    }

    private void init() {
        this.cal();
        int count = this.getChildCount();
        if (count != 1) {
            new IllegalArgumentException("child only can be one");
        }
    }

    public void setHeaderView(HeadView mHeaderView) {
        this.mHeaderView = mHeaderView;
    }

    public void setFooterView(FooterView mFooterView) {
        this.mFooterView = mFooterView;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mChildView = this.getChildAt(0);
        this.addHeadView();
        this.addFooterView();
    }

    private void addHeadView() {
        if (this.mHeaderView == null) {
            this.mHeaderView = new HeadRefreshView(this.getContext());
        }
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, 0);
        this.mHeaderView.getView().setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        if (this.mHeaderView.getView().getParent() != null) {
            ((ViewGroup)this.mHeaderView.getView().getParent()).removeAllViews();
        }
        this.addView(this.mHeaderView.getView(), 0);
    }

    private void addFooterView() {
        if (this.mFooterView == null) {
            this.mFooterView = new LoadMoreView(this.getContext());
        }
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, 0);
        layoutParams.gravity = 80;
        this.mFooterView.getView().setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        if (this.mFooterView.getView().getParent() != null) {
            ((ViewGroup)this.mFooterView.getView().getParent()).removeAllViews();
        }
        this.addView(this.mFooterView.getView());
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        if (!this.canLoadMore && !this.canRefresh) {
            return super.onInterceptTouchEvent(ev);
        }
        if (this.isRefresh || this.isLoadMore) {
            return true;
        }
        switch (ev.getAction()) {
            case 0: {
                this.mCurrentY = this.mTouchY = ev.getY();
                break;
            }
            case 2: {
                float currentY = ev.getY();
                float dy = currentY - this.mCurrentY;
                if (this.canRefresh) {
                    boolean canChildScrollUp = this.canChildScrollUp();
                    if (dy > 0.0f && !canChildScrollUp) {
                        this.mHeaderView.begin();
                        return true;
                    }
                }
                if (!this.canLoadMore) break;
                boolean canChildScrollDown = this.canChildScrollDown();
                if (!(dy < 0.0f) || canChildScrollDown) break;
                this.mFooterView.begin();
                return true;
            }
        }
        return super.onInterceptTouchEvent(ev);
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.isRefresh || this.isLoadMore) {
            return true;
        }
        switch (event.getAction()) {
            case 2: {
                this.mCurrentY = event.getY();
                float dura = (this.mCurrentY - this.mTouchY) / 3.0f;
                if (dura > 0.0f && this.canRefresh) {
                    dura = Math.min((float)head_height_2, dura);
                    dura = Math.max(0.0f, dura);
                    this.mHeaderView.getView().getLayoutParams().height = (int)dura;
                    ViewCompat.setTranslationY((View)this.mChildView, (float)dura);
                    this.requestLayout();
                    this.mHeaderView.progress(dura, head_height);
                } else if (this.canLoadMore) {
                    dura = Math.min((float)foot_height_2, Math.abs(dura));
                    dura = Math.max(0.0f, Math.abs(dura));
                    this.mFooterView.getView().getLayoutParams().height = (int)dura;
                    ViewCompat.setTranslationY((View)this.mChildView, (float)(-dura));
                    this.requestLayout();
                    this.mFooterView.progress(dura, foot_height);
                }
                return true;
            }
            case 1: 
            case 3: {
                float currentY = event.getY();
                int dy1 = (int)(currentY - this.mTouchY) / 3;
                if (dy1 > 0 && this.canRefresh) {
                    if (dy1 >= head_height) {
                        this.createAnimatorTranslationY(10, dy1 > head_height_2 ? head_height_2 : dy1, head_height, new CallBack(){

                            @Override
                            public void onSuccess() {
                                PullToRefreshLayout.this.isRefresh = true;
                                if (PullToRefreshLayout.this.refreshListener != null) {
                                    PullToRefreshLayout.this.refreshListener.refresh();
                                }
                                PullToRefreshLayout.this.mHeaderView.loading();
                            }
                        });
                        break;
                    }
                    if (dy1 <= 0 || dy1 >= head_height) break;
                    this.setFinish(dy1, 10);
                    this.mHeaderView.normal();
                    break;
                }
                if (!this.canLoadMore) break;
                if (Math.abs(dy1) >= foot_height) {
                    this.createAnimatorTranslationY(11, Math.abs(dy1) > foot_height_2 ? foot_height_2 : Math.abs(dy1), foot_height, new CallBack(){

                        @Override
                        public void onSuccess() {
                            PullToRefreshLayout.this.isLoadMore = true;
                            if (PullToRefreshLayout.this.refreshListener != null) {
                                PullToRefreshLayout.this.refreshListener.loadMore();
                            }
                            PullToRefreshLayout.this.mFooterView.loading();
                        }
                    });
                    break;
                }
                this.setFinish(Math.abs(dy1), 11);
                this.mFooterView.normal();
            }
        }
        return super.onTouchEvent(event);
    }

    private boolean canChildScrollDown() {
        if (this.mChildView == null) {
            return false;
        }
        return ViewCompat.canScrollVertically((View)this.mChildView, (int)1);
    }

    private boolean canChildScrollUp() {
        if (this.mChildView == null) {
            return false;
        }
        return ViewCompat.canScrollVertically((View)this.mChildView, (int)-1);
    }

    public void createAnimatorTranslationY(final int state, int start, final int purpose, final CallBack callBack) {
        ValueAnimator anim = ValueAnimator.ofInt((int[])new int[]{start, purpose});
        anim.setDuration(250L);
        anim.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                int value = (Integer)valueAnimator.getAnimatedValue();
                if (state == 10) {
                    ((PullToRefreshLayout)PullToRefreshLayout.this).mHeaderView.getView().getLayoutParams().height = value;
                    ViewCompat.setTranslationY((View)PullToRefreshLayout.this.mChildView, (float)value);
                    if (purpose == 0) {
                        PullToRefreshLayout.this.mHeaderView.finishing(value, head_height_2);
                    } else {
                        PullToRefreshLayout.this.mHeaderView.progress(value, head_height);
                    }
                } else {
                    ((PullToRefreshLayout)PullToRefreshLayout.this).mFooterView.getView().getLayoutParams().height = value;
                    ViewCompat.setTranslationY((View)PullToRefreshLayout.this.mChildView, (float)(-value));
                    if (purpose == 0) {
                        PullToRefreshLayout.this.mFooterView.finishing(value, head_height_2);
                    } else {
                        PullToRefreshLayout.this.mFooterView.progress(value, foot_height);
                    }
                }
                if (value == purpose && callBack != null) {
                    callBack.onSuccess();
                }
                PullToRefreshLayout.this.requestLayout();
            }
        });
        anim.start();
    }

    private void setFinish(int height, final int state) {
        this.createAnimatorTranslationY(state, height, 0, new CallBack(){

            @Override
            public void onSuccess() {
                if (state == 10) {
                    PullToRefreshLayout.this.isRefresh = false;
                    PullToRefreshLayout.this.mHeaderView.normal();
                } else {
                    PullToRefreshLayout.this.isLoadMore = false;
                    PullToRefreshLayout.this.mFooterView.normal();
                }
            }
        });
    }

    public void setFinish(int state) {
        if (state == 10) {
            if (this.mHeaderView != null && this.mHeaderView.getView().getLayoutParams().height > 0 && this.isRefresh) {
                this.setFinish(head_height, state);
            }
        } else if (this.mFooterView != null && this.mFooterView.getView().getLayoutParams().height > 0 && this.isLoadMore) {
            this.setFinish(foot_height, state);
        }
    }

    public static int Dp2Px(Context context, float dp) {
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)(dp * scale + 0.5f);
    }

    public static int Px2Dp(Context context, float px) {
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)(px / scale + 0.5f);
    }

    public static int sp2px(Context context, float spValue) {
        float fontScale = context.getResources().getDisplayMetrics().scaledDensity;
        return (int)(spValue * fontScale + 0.5f);
    }

    public static interface CallBack {
        public void onSuccess();
    }
}

